/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.tech.client.jccf.win;

import com.ishmed.tech.client.jccf.JCCFControlI;
import com.ishmed.tech.client.jccf.JCCFControlListenerI;
import com.ishmed.tech.client.jccf.JCCFException;
import com.ishmed.tech.client.jccf.JCCFRestrictedControl;
import com.ishmed.tech.client.jccf.util.FilteredEventQueue;
import com.ishmed.tech.client.jccf.win.JCCFWinPluginClassLoaderHelper;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JCCFWinControl
extends JCCFRestrictedControl {
    private static final long serialVersionUID = -6307832842366851128L;
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REG_CMD = "reg query \"HKLM\\SOFTWARE\\Cerner\\Prefs\\com\\ishmed\\jccf\" /v ";
    private boolean controlReady = false;

    public JCCFWinControl() {
        super(false);
        javagui = false;
        if (System.getProperty("java.version").substring(0, 3).equals("1.5")) {
            try {
                if (!System.getProperty("java.version").substring(0, 8).equals("1.5.0_11") && Class.forName("sun.plugin.viewer.frame.AxBridgeEmbeddedFrame", false, null) != null) {
                    Toolkit.getDefaultToolkit().getSystemEventQueue().push(new FilteredEventQueue(this.log.getLogger()));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    @Override
    protected JCCFControlI getUsedControl(String string, String string2) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFWinControl", "getUsedControl", "START " + string + " " + string2);
        }
        String string3 = this.getJarFilename(string);
        try {
            ClassLoader classLoader;
            try {
                classLoader = new JCCFWinPluginClassLoaderHelper().addJarToClassPath(string3);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (this.log.isInfo()) {
                    this.log.info("JCCFWinControl", "getUsedControl", "JCCF022 - Java Plugin is not available. Could not dynamically add jar file " + string3);
                }
                classLoader = this.getClass().getClassLoader();
            }
            Object obj = classLoader.loadClass(string2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            JCCFControlI jCCFControlI = (JCCFControlI)obj;
            if (this.log.isDebug()) {
                this.log.debug("JCCFWinControl", "getUsedControl", "END " + String.valueOf(jCCFControlI));
            }
            return jCCFControlI;
        }
        catch (Exception exception) {
            if (this.log.isDebug()) {
                this.log.debug("JCCFWinControl", "getUsedControl", "END " + String.valueOf(exception));
            }
            return null;
        }
    }

    @Override
    protected File getFile(URL uRL) {
        if (uRL == null) {
            return null;
        }
        return new File(uRL.getFile());
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.controlReady) {
            for (JCCFControlListenerI jCCFControlListenerI : this.extEventListeners) {
                jCCFControlListenerI.controlReady("");
            }
            this.controlReady = true;
        }
    }

    @Override
    protected void getLogSettings(Properties properties) {
        String string = "";
        string = "";
        string = System.getProperty("com.ishmed.jccf.oldlogfileage", "");
        if (string != null && !string.equalsIgnoreCase("")) {
            this.log.setLogOldFileAge(Long.parseLong(string) * 1000L);
        } else {
            string = this.getRegistriyValue("oldlogfileage", true);
            if (string != null && !string.equalsIgnoreCase("")) {
                this.log.setLogOldFileAge(Long.parseLong(string) * 1000L);
            } else {
                this.log.setLogOldFileAge(2419200000L);
            }
        }
        string = "";
        string = System.getProperty("com.ishmed.jccf.splitlogfilesize", "");
        if (string != null && !string.equalsIgnoreCase("")) {
            this.log.setLogFileSize(Integer.parseInt(string));
        } else {
            string = this.getRegistriyValue("logfilesize", true);
            if (string != null && !string.equalsIgnoreCase("")) {
                this.log.setLogFileSize(Integer.parseInt(string));
            } else {
                this.log.setLogFileSize(10);
            }
        }
    }

    @Override
    protected String getPluginPath() {
        block25: {
            if (this.log.isTrace()) {
                this.log.trace("JCCFWinControl", "getPluginPath", "START ");
            }
            try {
                String string;
                Preferences preferences;
                if (this.getCompname().equals("kurve")) {
                    preferences = Preferences.systemRoot().node("com/ishmed/jccf/kurve");
                    if (preferences.keys().length == 0) {
                        if (this.log.isWarn()) {
                            this.log.warn("JCCFWinControl", "getPluginPath", "JCCF018 - Registry warning.  com/ishmed/jccf/kurve contains nothing.");
                        }
                    } else {
                        string = preferences.get("installpath", "XXX");
                        if (!string.equals("XXX")) {
                            if (this.log.isDebug()) {
                                this.log.debug("JCCFWinControl", "getPluginPath", "END " + string);
                            }
                            return string;
                        }
                        if (this.log.isWarn()) {
                            this.log.warn("JCCFWinControl", "getPluginPath", "JCCF018 - Registry warning.  com/ishmed/jccf/kurve/installpath not found.");
                        }
                    }
                }
                if (this.getCompname().equals("ISHMEDUtilities")) {
                    preferences = Preferences.systemRoot().node("com/ishmed/jccf/ishmedutilities");
                    if (preferences.keys().length == 0) {
                        if (this.log.isWarn()) {
                            this.log.warn("JCCFWinControl", "getPluginPath", "JCCF018 - Registry warning.  com/ishmed/jccf/ishmedutilities contains nothing.");
                        }
                    } else {
                        string = preferences.get("installpath", "XXX");
                        if (!string.equals("XXX")) {
                            if (this.log.isDebug()) {
                                this.log.debug("JCCFWinControl", "getPluginPath", "END " + string);
                            }
                            return string;
                        }
                        if (this.log.isWarn()) {
                            this.log.warn("JCCFWinControl", "getPluginPath", "JCCF018 - Registry warning.  com/ishmed/jccf/ishmedutilities/installpath not found.");
                        }
                    }
                }
                if (this.getCompname().equals("Scheduler")) {
                    preferences = Preferences.systemRoot().node("com/ishmed/jccf/scheduler");
                    if (preferences.keys().length == 0) {
                        if (this.log.isWarn()) {
                            this.log.warn("JCCFWinControl", "getPluginPath", "JCCF018 - Registry warning.  com/ishmed/jccf/scheduler contains nothing.");
                        }
                    } else {
                        string = preferences.get("installpath", "XXX");
                        if (!string.equals("XXX")) {
                            if (this.log.isDebug()) {
                                this.log.debug("JCCFWinControl", "getPluginPath", "END " + string);
                            }
                            return string;
                        }
                        if (this.log.isWarn()) {
                            this.log.warn("JCCFWinControl", "getPluginPath", "JCCF018 - Registry warning.  com/ishmed/jccf/scheduler/installpath not found.");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                new JCCFException(2, 1, "JCCF001 - Unspecified error. " + this.getCompname(), throwable);
                if (!this.log.isWarn()) break block25;
                this.log.warn("JCCFWinControl", "getPluginPath", "JCCF001 - Unspecified error. " + this.getCompname(), throwable);
            }
        }
        if (this.log.isDebug()) {
            this.log.debug("JCCFWinControl", "getPluginPath", "END " + super.getPluginPath());
        }
        return super.getPluginPath();
    }

    private String getRegistriyValue(String string, boolean bl) {
        if (bl) {
            return this.getRegistriyDWORD(string);
        }
        return "";
    }

    private String getRegistriyDWORD(String string) {
        try {
            String string2 = "REG_DWORD";
            ProcessBuilder processBuilder = new ProcessBuilder(REG_CMD, string);
            Process process = processBuilder.start();
            StreamReader streamReader = new StreamReader(this, process.getInputStream());
            streamReader.start();
            process.waitFor();
            streamReader.join();
            String string3 = streamReader.getResult();
            int n = string3.indexOf(string2);
            if (n == -1) {
                return null;
            }
            String string4 = string3.substring(n + string2.length()).trim();
            return Integer.toString(Integer.parseInt(string4.substring("0x".length()), 16));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected String getLoggingPath(Properties properties) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFWinControl", "getLoggingPath", "START " + String.valueOf(properties));
        }
        String string = "";
        string = System.getProperty("com.ishmed.jccf.logpath", "");
        if (string != null && !string.equalsIgnoreCase("")) {
            if (this.log.isDebug()) {
                this.log.debug("JCCFWinControl", "getLoggingPath", "Filelogging System property:  " + string);
            }
        } else {
            string = this.getRegistriyValue("logpath", false);
            if (string != null && !string.equalsIgnoreCase("")) {
                if (this.log.isDebug()) {
                    this.log.debug("JCCFWinControl", "getLoggingPath", "Filelogging Registriy:  " + string);
                }
            } else {
                string = null;
                if (this.log.isDebug()) {
                    this.log.debug("JCCFWinControl", "getLoggingPath", "null ");
                }
            }
        }
        return string;
    }

    @Override
    protected boolean isFileLoggingActive(Properties properties) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFWinControl", "isFileLoggingActive", "START " + String.valueOf(properties));
        }
        return true;
    }

    @Override
    protected boolean createNewLoggingFile(Properties properties) {
        return false;
    }

    @Override
    protected String getFileLoggingLevel(Properties properties) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFWinControl", "getFileLoggingLevel", "START " + String.valueOf(properties));
        }
        String string = "";
        string = System.getProperty("com.ishmed.jccf.loglevel", "");
        if (string != null && !string.equalsIgnoreCase("")) {
            if (this.log.isInfo()) {
                this.log.info("JCCFWinControl", "getFileLoggingLevel", "Filelogging Level System Propertys: " + string);
            }
            return string;
        }
        string = this.getRegistriyValue("loglevel", true);
        if (string != null && !string.equalsIgnoreCase("")) {
            if (this.log.isInfo()) {
                this.log.info("JCCFWinControl", "getFileLoggingLevel", "Filelogging Level registry: " + string);
            }
            return string;
        }
        if (this.log.isInfo()) {
            this.log.info("JCCFWinControl", "getFileLoggingLevel", "Filelogging Level default: 2");
        }
        return "2";
    }

    class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw;

        StreamReader(JCCFWinControl jCCFWinControl, InputStream inputStream) {
            this.is = inputStream;
            this.sw = new StringWriter();
        }

        @Override
        public void run() {
            try {
                int n;
                while ((n = this.is.read()) != -1) {
                    this.sw.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }
}

