/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.tech.client.jccf.util;

import java.io.File;
import java.io.ObjectStreamClass;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class ClassUtilities {
    private ClassUtilities() {
    }

    public static final URL getClassPathComponentURL(Class clazz, ClassLoader classLoader) {
        if (clazz == null) {
            return null;
        }
        String string = clazz.getName().replace('.', '/') + ".class";
        return ClassUtilities.getClassPathComponentURL(string, classLoader);
    }

    public static final File getClassPathComponentRoot(String string) {
        try {
            File file = new File(new URI(ClassUtilities.getClassPathComponentURL(string, null).toExternalForm()));
            if (file.isDirectory()) {
                return file;
            }
            return file.getParentFile();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static final File getClassPathComponentRoot(Class clazz) {
        try {
            File file = new File(new URI(ClassUtilities.getClassPathComponentURL(clazz, null).toExternalForm()));
            if (file.isDirectory()) {
                return file;
            }
            return file.getParentFile();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static final URL getClassPathComponentURL(String string, ClassLoader classLoader) {
        URL uRL = null;
        uRL = classLoader == null ? ClassLoader.getSystemResource(string) : classLoader.getResource(string);
        if (uRL == null) {
            return null;
        }
        String string2 = uRL.toString();
        if (string2 == null) {
            return null;
        }
        String string3 = string2.substring(0, string2.indexOf(string) - 1);
        if (string3.startsWith("jar:")) {
            string3 = string3.substring("jar:".length(), string3.length() - 1);
        }
        try {
            return new URL(string3);
        }
        catch (Exception exception) {
            throw new Error("This should never happen! (" + exception.toString() + ")");
        }
    }

    public static final File getClassPathComponentFile(Object object) {
        try {
            Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
            return new File(new URI(ClassUtilities.getClassPathComponentURL(clazz, null).toExternalForm()));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static void printSerialVersionUID(Class clazz) {
        long l = ObjectStreamClass.lookup(clazz).getSerialVersionUID();
        System.err.println(String.valueOf(clazz) + "\n==========================");
        System.err.println("    static final long serialVersionUID = " + l + "L;\n");
    }
}

