/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.tech.client.jccf;

import com.ishmed.tech.client.jccf.util.Util;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.print.attribute.EnumSyntax;

public class JCCFType
extends EnumSyntax {
    private static final long serialVersionUID = 3L;
    public static final JCCFType INTEGER = new JCCFType(0, Integer.class);
    public static final JCCFType LONG = new JCCFType(1, Long.class);
    public static final JCCFType DOUBLE = new JCCFType(2, Double.class);
    public static final JCCFType STRING = new JCCFType(3, String.class);
    public static final JCCFType BYTEARRAY = new JCCFType(4, byte[].class);
    private static final String[] stringTable = new String[]{"Integer", "Long", "Double", "String", "byte[]"};
    private static final JCCFType[] enumValueTable = new JCCFType[]{INTEGER, LONG, DOUBLE, STRING, BYTEARRAY};
    private static final String[] xmlTypes = new String[]{"INT", "LON", "DOU", "STR", "BYA"};
    private Class c = null;

    public JCCFType(int n, Class clazz) {
        super(n);
        this.c = clazz;
    }

    @Override
    protected String[] getStringTable() {
        return stringTable;
    }

    @Override
    protected EnumSyntax[] getEnumValueTable() {
        return enumValueTable;
    }

    public Class getClassType() {
        return this.c;
    }

    public String getXMLType() {
        return xmlTypes[this.getValue()];
    }

    public String getXMLValue(Object object) {
        if (object == null) {
            return null;
        }
        if (this == INTEGER) {
            return object.toString();
        }
        if (this == LONG) {
            return object.toString();
        }
        if (this == DOUBLE) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.GERMAN);
            return numberFormat.format((Double)object);
        }
        if (this == STRING) {
            return (String)object;
        }
        if (this == BYTEARRAY) {
            return Util.toHexString((byte[])object);
        }
        return null;
    }

    public Object getValueFromXML(String string) throws ParseException {
        if (string == null) {
            if (this == INTEGER) {
                return null;
            }
            if (this == LONG) {
                return null;
            }
            if (this == DOUBLE) {
                return null;
            }
            if (this == STRING) {
                return null;
            }
            if (this == BYTEARRAY) {
                return null;
            }
        }
        if (this == INTEGER) {
            return Integer.parseInt(string);
        }
        if (this == LONG) {
            return Long.parseLong(string);
        }
        if (this == DOUBLE) {
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.GERMAN);
            return numberFormat.parse(string).doubleValue();
        }
        if (this == STRING) {
            return string;
        }
        if (this == BYTEARRAY) {
            return Util.fromHexString(string);
        }
        return null;
    }

    public static JCCFType getType(String string) {
        for (int i = 0; i < stringTable.length; ++i) {
            if (!stringTable[i].equals(string)) continue;
            return enumValueTable[i];
        }
        return null;
    }

    public static JCCFType getTypeFromXML(String string) {
        for (int i = 0; i < xmlTypes.length; ++i) {
            if (!xmlTypes[i].equals(string)) continue;
            return enumValueTable[i];
        }
        return null;
    }

    public static JCCFType getType(Class clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz == Integer.class) {
            return INTEGER;
        }
        if (clazz == Long.class) {
            return LONG;
        }
        if (clazz == Double.class) {
            return DOUBLE;
        }
        if (clazz == String.class) {
            return STRING;
        }
        if (clazz == byte[].class) {
            return BYTEARRAY;
        }
        return null;
    }
}

