/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.tech.client.jccf;

import com.ishmed.tech.client.jccf.JCCFMethod;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JCCFMethods {
    private ArrayList methods = null;

    public void addMethod(JCCFMethod jCCFMethod) {
        if (this.methods == null) {
            this.methods = new ArrayList(3);
        }
        this.methods.add(jCCFMethod);
    }

    public void setMethods(ArrayList arrayList) {
        this.methods = arrayList;
    }

    public JCCFMethod[] getMethods() {
        if (this.methods == null || this.methods.size() == 0) {
            return null;
        }
        return this.methods.toArray(new JCCFMethod[this.methods.size()]);
    }

    public static JCCFMethods getFromXML(Document document) throws ParserConfigurationException {
        NodeList nodeList = document.getElementsByTagName("meth");
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        JCCFMethods jCCFMethods = new JCCFMethods();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            jCCFMethods.addMethod(JCCFMethod.getFromXML(node));
        }
        return jCCFMethods;
    }

    public Document getXMLDoc() throws ParserConfigurationException {
        if (this.methods == null || this.methods.size() == 0) {
            return null;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("msg");
        document.appendChild(element);
        for (int i = 0; i < this.methods.size(); ++i) {
            JCCFMethod jCCFMethod = (JCCFMethod)this.methods.get(i);
            jCCFMethod.appendXML(document, element);
        }
        return document;
    }

    public void invokeMethods(Object object) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (this.methods == null || this.methods.size() == 0) {
            return;
        }
        for (int i = 0; i < this.methods.size(); ++i) {
            JCCFMethod jCCFMethod = (JCCFMethod)this.methods.get(i);
            jCCFMethod.invokeMethod(object);
        }
    }
}

