/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.tech.client.jccf;

import com.ishmed.tech.client.jccf.JCCFException;
import com.ishmed.tech.client.jccf.JCCFParam;
import com.ishmed.tech.client.jccf.JCCFParams;
import com.ishmed.tech.client.jccf.JCCFReturn;
import com.ishmed.tech.client.jccf.JCCFType;
import com.ishmed.tech.client.jccf.util.Base64;
import com.ishmed.tech.client.jccf.util.XMLUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class JCCFMethod {
    public static final String CALL_TARGET_BASECONTROL = "basecontrol";
    public static final String CALL_TARGET_EMBEDDEDCONTROL = "embeddedcontrol";
    private String methodname = null;
    private String targetname = null;
    private JCCFParams params = new JCCFParams();
    private JCCFReturn ret;
    private JCCFException exception = null;

    public JCCFMethod(String string, String string2) {
        this.methodname = string;
        this.targetname = string2;
    }

    public String getTargetname() {
        return this.targetname;
    }

    protected void setTargetname(String string) {
        this.targetname = string;
    }

    public void addParameter(JCCFParam jCCFParam) {
        this.params.addParameter(jCCFParam);
    }

    public JCCFParam[] getParams() {
        return this.params.getParams();
    }

    public void setParams(JCCFParams jCCFParams) {
        this.params = jCCFParams;
    }

    public void setReturn(JCCFReturn jCCFReturn) {
        this.ret = jCCFReturn;
    }

    public JCCFReturn getReturn() {
        return this.ret;
    }

    public JCCFException getException() {
        return this.exception;
    }

    public void setException(JCCFException jCCFException) {
        this.exception = jCCFException;
    }

    public static JCCFMethod getFromXML(Node node) throws ParserConfigurationException {
        if (node == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            throw new ParserConfigurationException("Node has no attributes!" + String.valueOf(node));
        }
        if (namedNodeMap.getNamedItem("name") == null) {
            throw new ParserConfigurationException("Node has no attribute name!" + String.valueOf(node));
        }
        Node node2 = namedNodeMap.getNamedItem("name");
        if (namedNodeMap.getNamedItem("calltarget") == null) {
            throw new ParserConfigurationException("Node has no attribute calltarget!" + String.valueOf(node));
        }
        Node node3 = namedNodeMap.getNamedItem("calltarget");
        JCCFMethod jCCFMethod = new JCCFMethod(node2.getNodeValue(), node3.getNodeValue());
        jCCFMethod.setParams(JCCFParams.getFromXML(node));
        return jCCFMethod;
    }

    public void appendXML(Document document, Element element) throws ParserConfigurationException {
        if (this.getTargetname().equals(CALL_TARGET_BASECONTROL) && this.exception == null && this.ret != null && this.ret.getType().equals(JCCFType.STRING)) {
            try {
                byte[] byArray = Base64.decode((String)this.ret.getValue());
                String string = new String(byArray, "UTF-8");
                Document document2 = new XMLUtil().createDocument(string);
                Node node = document2.getElementsByTagName("mret").item(0);
                node = document.importNode(node, true);
                element.appendChild(node);
                return;
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        Element element2 = document.createElement("mret");
        element.appendChild(element2);
        if (this.methodname != null) {
            Attr attr = document.createAttribute("name");
            attr.setNodeValue(this.methodname);
            element2.setAttributeNode(attr);
        }
        if (this.exception != null) {
            this.exception.appendXML(document, element2);
        } else if (this.ret != null) {
            this.ret.appendXML(document, element2);
        }
    }

    public void invokeMethod(Object object) {
        Class[] classArray = (Class[])this.params.getParamValues();
        Object[] objectArray = this.params.getParamValues();
        try {
            Method method = object.getClass().getMethod(this.methodname, classArray);
            Object object2 = null;
            object2 = method.invoke(object, objectArray);
            JCCFType jCCFType = JCCFType.getType(method.getReturnType());
            this.ret = jCCFType != null ? new JCCFReturn(jCCFType, object2) : null;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() != null && invocationTargetException.getCause() instanceof JCCFException) {
                this.exception = (JCCFException)invocationTargetException.getCause();
                return;
            }
            this.exception = new JCCFException(1, 1, "JCCF001 - Unspecified error. " + this.methodname, invocationTargetException.getCause());
        }
        catch (Exception exception) {
            this.exception = new JCCFException(1, 1, "JCCF001 - Unspecified error. " + this.methodname, exception.getCause());
        }
    }
}

