/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.tech.client.jccf;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JCCFException
extends Exception {
    private static final long serialVersionUID = 2L;
    public static final int JCCF000 = 0;
    public static final String JCCF000STR = "JCCF000 - Error from custom control. ";
    public static final int JCCF001 = 1;
    public static final String JCCF001STR = "JCCF001 - Unspecified error. ";
    public static final int JCCF002 = 2;
    public static final String JCCF002STR = "JCCF002 - Custom control not found. ";
    public static final int JCCF003 = 3;
    public static final String JCCF003STR = "JCCF003 - Can't identify BasePath. ";
    public static final int JCCF004 = 4;
    public static final String JCCF004STR = "JCCF004 - Communication error: Error in xml. No method to call available. ";
    public static final int JCCF005 = 5;
    public static final String JCCF005STR = "JCCF005 - Communication error: Error in xml. ";
    public static final int JCCF006 = 6;
    public static final String JCCF006STR = "JCCF006 - Extracted Path is not a directory. ";
    public static final int JCCF007 = 7;
    public static final String JCCF007STR = "JCCF007 - Plugin has no META-INF/plugin.properties. ";
    public static final int JCCF008 = 8;
    public static final String JCCF008STR = "JCCF008 - XML Parse Exception on: ";
    public static final int JCCF009 = 9;
    public static final String JCCF009STR = "JCCF009 - Jarfile for plugin does not exist. ";
    public static final int JCCF010 = 10;
    public static final String JCCF010STR = "JCCF010 - Error during reading plugin. ";
    public static final int JCCF011 = 11;
    public static final String JCCF011STR = "JCCF011 - Plugin has no property plugin.version. ";
    public static final int JCCF012 = 12;
    public static final String JCCF012STR = "JCCF012 - No ISHMEDBasisControl.properties found. ";
    public static final int JCCF013 = 13;
    public static final String JCCF013STR = "JCCF013 - Jar has no META-INF/ISHMEDBasisControl.properties. ";
    public static final int JCCF014 = 14;
    public static final String JCCF014STR = "JCCF014 - Custom control could not be created. ";
    public static final int JCCF015 = 15;
    public static final String JCCF015STR = "JCCF015 - Creation of custom control was interrupted. ";
    public static final int JCCF016 = 16;
    public static final String JCCF016STR = "JCCF016 - Creation of custom control failed. ";
    public static final int JCCF017 = 17;
    public static final String JCCF017STR = "JCCF017 - Custom control not registered. ";
    public static final int JCCF018 = 18;
    public static final String JCCF018STR = "JCCF018 - Registry warning. ";
    public static final int JCCF019 = 19;
    public static final String JCCF019STR = "JCCF019 - Can't identify JarPath. ";
    public static final int JCCF020 = 20;
    public static final String JCCF020STR = "JCCF020 - Extracted Path is not a file. ";
    public static final int JCCF021 = 21;
    public static final String JCCF021STR = "JCCF021 - Parameter calltarget has wrong value. ";
    public static final int JCCF022 = 22;
    public static final String JCCF022STR = "JCCF022 - Java Plugin is not available. Could not dynamically add jar file ";
    public static final int JCCF023 = 23;
    public static final String JCCF023STR = "JCCF023 - Creation of custom control dubble. ";
    public static final int SEVERE = 1;
    public static final int WARNING = 2;
    private int cat;
    private int id;

    public JCCFException(int n, int n2, String string) {
        super(string);
        this.init(n, n2);
    }

    public JCCFException(int n, int n2, String string, Throwable throwable) {
        super(string, throwable);
        this.init(n, n2);
    }

    public int getCat() {
        return this.cat;
    }

    public void setCat(int n) {
        this.cat = n;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    private void init(int n, int n2) {
        this.cat = n;
        this.id = n2;
    }

    public String getCatText() {
        switch (this.cat) {
            case 1: {
                return "SEVERE";
            }
            case 2: {
                return "WARNING";
            }
        }
        return "Illegal error type!!!";
    }

    public static String text(JCCFException jCCFException) {
        return jCCFException.getCatText() + ": " + jCCFException.getMessage();
    }

    public void appendXML(Document document, Element element) throws ParserConfigurationException {
        Element element2 = document.createElement("excp");
        element.appendChild(element2);
        Attr attr = document.createAttribute("cat");
        attr.setNodeValue(String.valueOf(this.cat));
        element2.setAttributeNode(attr);
        Attr attr2 = document.createAttribute("id");
        attr2.setNodeValue(String.valueOf(this.id));
        element2.setAttributeNode(attr2);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getMessage() != null) {
            stringBuffer.append(this.getMessage());
        }
        if (this.getCause() != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(this.getCause().toString());
        }
        if (stringBuffer.length() > 0) {
            element2.appendChild(document.createTextNode(stringBuffer.toString()));
        }
    }

    public Document getXMLDoc() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("msg");
        document.appendChild(element);
        this.appendXML(document, element);
        return document;
    }
}

