/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.tech.client.jccf;

import com.ishmed.tech.client.jccf.JCCFContext;
import com.ishmed.tech.client.jccf.JCCFControlEventSupport;
import com.ishmed.tech.client.jccf.JCCFControlEventlListenerI;
import com.ishmed.tech.client.jccf.JCCFControlI;
import com.ishmed.tech.client.jccf.JCCFControlListenerI;
import com.ishmed.tech.client.jccf.JCCFEvent;
import com.ishmed.tech.client.jccf.JCCFException;
import com.ishmed.tech.client.jccf.JCCFLogger;
import com.ishmed.tech.client.jccf.JCCFLoggerI;
import com.ishmed.tech.client.jccf.JCCFMethod;
import com.ishmed.tech.client.jccf.JCCFMethods;
import com.ishmed.tech.client.jccf.JCCFParam;
import com.ishmed.tech.client.jccf.JCCFUpdate;
import com.ishmed.tech.client.jccf.util.Base64;
import com.ishmed.tech.client.jccf.util.ClassUtilities;
import com.ishmed.tech.client.jccf.util.Util;
import com.ishmed.tech.client.jccf.util.XMLUtil;
import com.ishmed.tech.client.jccf.zip.JCCFInputStream;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class JCCFControl
extends JComponent {
    private static final long serialVersionUID = 7623810937210122960L;
    public static final String VERSION = "7.6.7";
    protected static boolean logfileresetdone = false;
    protected Vector extEventListeners = new Vector();
    protected JCCFControlEventSupport jccfEventSupport = new JCCFControlEventSupport();
    protected JCCFControlI customcontrol = null;
    protected String compname = null;
    private JCCFContext context = null;
    protected JCCFLogger log = null;
    public static boolean javagui = false;
    protected boolean oldcontrol = false;
    protected boolean pluginpath = false;
    protected static int logNumber = 0;
    protected static final long DEFAULT_LOGOLDFILEAGE = 2419200000L;
    protected static final int DEFAULT_LOGFILESIZE = 10;
    protected String fileSeparator = System.getProperty("file.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCCFControl(boolean bl) {
        JCCFControl jCCFControl = this;
        synchronized (jCCFControl) {
            javagui = bl;
            this.setLayout(new BorderLayout());
            this.setVisible(true);
            ++logNumber;
            this.context = new JCCFContext(this, Logger.getAnonymousLogger());
            this.log = this.context.getLogger();
            if (this.log.isInfo()) {
                this.log.info("JCCFControl", "JCCFControl Version = ", "7.6.7 " + this.makeReturnString("getBasisControlVersionInfo", VERSION));
                this.log.info("JCCFControl", "JCCFControl", "Java Version = " + System.getProperty("java.version"));
            }
            if (!javagui) {
                this.handleProperties();
            }
            if (this.log.isInfo()) {
                this.log.info("JCCFControl", "JCCFControl", "Java Version = " + System.getProperty("java.version"));
            }
            this.log.info("JCCFControl", "JCCFControl", "JCCFControl Version = 7.6.7");
            this.memoryProtocol();
            this.jccfEventSupport.addControlEventListener(new JCCFControlEventlListener());
            this.context.setEventsupport(this.jccfEventSupport);
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "JCCFControl", "END ");
            }
        }
    }

    public synchronized String getVersionInfo(String string) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "getVersionInfo", "START " + string);
        }
        String string2 = "";
        try {
            string2 = this.callMethodWithData("getVersionInfo", null);
        }
        catch (Throwable throwable) {
            if (this.log.isError()) {
                this.log.error("JCCFControl", "getVersionInfo", "JCCF010 - Error during reading plugin.  plugin " + string + " " + this.getCompname(), throwable);
            }
            JCCFException jCCFException = new JCCFException(1, 10, "JCCF010 - Error during reading plugin.  plugin " + string + " " + this.getCompname(), throwable);
            return this.generateErrorString(jCCFException, "getVersionInfo");
        }
        if (this.log.isInfo()) {
            this.log.info("JCCFControl", "getVersionInfo", "END " + string2 + " " + this.makeReturnString(string2));
        }
        return this.makeReturnString("getVersionInfo", string2);
    }

    public synchronized String getBasisControlVersionInfo() {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "getBasisControlVersionInfo", "START ");
        }
        if (this.log.isInfo()) {
            this.log.info("JCCFControl", "getBasisControlVersionInfo", "END 7.6.7 " + this.makeReturnString("getBasisControlVersionInfo", VERSION));
        }
        return this.makeReturnString("getBasisControlVersionInfo", VERSION);
    }

    public synchronized String free() {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "free", "START ");
        }
        try {
            this.memoryProtocol();
            if (this.customcontrol != null) {
                this.customcontrol.free();
            }
            this.customcontrol = null;
            if (this.context != null) {
                this.context.free();
            }
            this.context = null;
        }
        catch (Throwable throwable) {
            JCCFException jCCFException = new JCCFException(1, 1, "JCCF001 - Unspecified error. " + this.getCompname(), throwable);
            if (this.log.isError()) {
                this.log.error("JCCFControl", "free", "JCCF001 - Unspecified error. " + this.getCompname(), throwable);
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "free", "END " + this.generateErrorString(jCCFException, "free"));
            }
            return this.generateErrorString(jCCFException, "free");
        }
        return this.makeReturnString("free");
    }

    public synchronized void setProperty(String string, String string2) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "setProperty", "START " + this.getCompname() + " " + string + " " + string2);
        }
    }

    public synchronized String getProperty(String string) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "getProperty", "START " + this.getCompname() + " " + string);
        }
        return null;
    }

    public synchronized String setUsedControl(final String string, final String string2) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "setUsedControl", "START " + string + " " + string2);
        }
        this.memoryProtocol();
        if (this.customcontrol != null) {
            this.remove((Component)((Object)this.customcontrol));
            this.customcontrol.free();
            this.customcontrol = null;
            if (this.log.isWarn()) {
                this.log.warn("JCCFControl", "setUsedControl", "JCCF023 - Creation of custom control dubble. " + this.getCompname());
            }
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JCCFControl.this.setUsedControlEventDispatching(string, string2);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            JCCFException jCCFException = new JCCFException(1, 15, "JCCF015 - Creation of custom control was interrupted. " + this.getCompname(), interruptedException);
            if (this.log.isWarn()) {
                this.log.warn("JCCFControl", "setUsedControl", "JCCF015 - Creation of custom control was interrupted. " + this.getCompname() + " " + String.valueOf(interruptedException));
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "setUsedControl", "END " + this.generateErrorString(jCCFException, "setUsedControl"));
            }
            this.memoryProtocol();
            return this.generateErrorString(jCCFException, "setUsedControl");
        }
        catch (InvocationTargetException invocationTargetException) {
            JCCFException jCCFException = null;
            Throwable throwable = invocationTargetException.getCause();
            if (this.log.isTrace()) {
                this.log.trace("JCCFControl", "setUsedControl", String.valueOf(invocationTargetException.getCause()));
            }
            if (throwable != null) {
                Throwable throwable2 = throwable.getCause();
                if (this.log.isTrace()) {
                    this.log.trace("JCCFControl", "setUsedControl", String.valueOf(throwable.getCause()));
                }
                if (throwable2 != null && throwable2.getClass().equals(JCCFException.class)) {
                    jCCFException = new JCCFException(1, 16, "JCCF016 - Creation of custom control failed. " + this.getCompname(), (JCCFException)throwable2);
                    if (this.log.isWarn()) {
                        this.log.warn("JCCFControl", "setUsedControl", "JCCF016 - Creation of custom control failed. " + this.getCompname() + " " + String.valueOf((JCCFException)throwable2));
                    }
                    if (this.log.isDebug()) {
                        this.log.debug("JCCFControl", "setUsedControl", "END " + this.generateErrorString(jCCFException, "setUsedControl"));
                    }
                    this.memoryProtocol();
                    return this.generateErrorString(jCCFException, "setUsedControl");
                }
            }
            jCCFException = new JCCFException(1, 16, "JCCF016 - Creation of custom control failed. " + this.getCompname(), invocationTargetException);
            if (this.log.isWarn()) {
                this.log.warn("JCCFControl", "setUsedControl", "JCCF016 - Creation of custom control failed. " + this.getCompname() + " " + String.valueOf(invocationTargetException));
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "setUsedControl", "END " + this.generateErrorString(jCCFException, "setUsedControl"));
            }
            this.memoryProtocol();
            return this.generateErrorString(jCCFException, "setUsedControl");
        }
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "setUsedControl", "END " + this.makeReturnString("setUsedControl"));
        }
        this.memoryProtocol();
        return this.makeReturnString("setUsedControl");
    }

    public synchronized String callMethodCompressed(String string, int n, String string2) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "callMethodCompressed", "START " + this.getCompname() + " " + string + " " + n);
        }
        this.memoryProtocol();
        try {
            String string3 = "";
            byte[] byArray = Base64.decode(string2);
            string3 = this.unZip(byArray, n);
            byArray = null;
            String string4 = "";
            if (string.equals("")) {
                string4 = this.callMethodSimple(string3);
                string4 = Base64.encodeBytes(string4.getBytes("UTF-8"));
            } else {
                string4 = this.callMethodWithData(string, string3);
                string4 = this.makeReturnString("callMethodCompressed", string4);
            }
            string3 = null;
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "callMethodCompressed", "END " + this.getCompname() + " " + string4);
            }
            this.memoryProtocol();
            return string4;
        }
        catch (Throwable throwable) {
            if (this.log.isError()) {
                this.log.error("JCCFControl", "callMethodCompressed", "JCCF001 - Unspecified error. " + this.getCompname());
            }
            JCCFException jCCFException = new JCCFException(1, 1, "JCCF001 - Unspecified error. " + this.getCompname(), throwable);
            this.memoryProtocol();
            return this.generateErrorString(jCCFException, "callMethodCompressed");
        }
    }

    public synchronized String callMethod(String string, String string2) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "callMethod(String,String)", "START " + this.getCompname() + " " + string);
        }
        this.memoryProtocol();
        try {
            byte[] byArray = Base64.decode(string2);
            String string3 = new String(byArray, "UTF-8");
            byArray = null;
            String string4 = "";
            if (string.equals("")) {
                string4 = this.callMethodSimple(string3);
                string4 = Base64.encodeBytes(string4.getBytes("UTF-8"));
            } else {
                string4 = this.callMethodWithData(string, string3);
                string4 = this.makeReturnString("callMethod", string4);
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "callMethod(String,String)", "END " + this.getCompname() + " " + string4);
            }
            this.memoryProtocol();
            return string4;
        }
        catch (Throwable throwable) {
            if (this.log.isError()) {
                this.log.error("JCCFControl", "callMethod(String,String)", "JCCF001 - Unspecified error. " + this.getCompname(), throwable);
            }
            JCCFException jCCFException = new JCCFException(1, 1, "JCCF001 - Unspecified error. " + this.getCompname(), throwable);
            this.memoryProtocol();
            return this.generateErrorString(jCCFException, "callMethod");
        }
    }

    public synchronized String callMethodSimple(String string) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "callMethod(String)", "START " + string);
        }
        try {
            JCCFMethods jCCFMethods;
            JCCFMethod[] jCCFMethodArray;
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "callMethod(String)", "Now creating empty doc " + this.getCompname());
            }
            Document document = new XMLUtil().createDocument(string);
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "callMethod(String)", "Now reading input XML structure " + this.getCompname());
            }
            if ((jCCFMethodArray = (jCCFMethods = JCCFMethods.getFromXML(document)).getMethods()) == null) {
                if (this.log.isWarn()) {
                    this.log.warn("JCCFControl", "callMethod(String)", "JCCF001 - Unspecified error. " + this.getCompname());
                }
                JCCFException jCCFException = new JCCFException(2, 4, "JCCF004 - Communication error: Error in xml. No method to call available. " + this.getCompname());
                String string2 = XMLUtil.createStringFromDoc(jCCFException.getXMLDoc());
                if (this.log.isDebug()) {
                    this.log.debug("JCCFControl", "callMethod(String)", "END " + this.getCompname() + " " + string2);
                }
                return string2;
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "callMethod(String)", "Now invoking methods " + this.getCompname());
            }
            for (int i = 0; i < jCCFMethodArray.length; ++i) {
                if (jCCFMethodArray[i] == null) continue;
                if (jCCFMethodArray[i].getTargetname().equals("basecontrol")) {
                    if (this.log.isDebug()) {
                        this.log.debug("JCCFControl", "callMethod(String)", "Now invoking method #" + i + " in basecontrol " + this.getCompname());
                    }
                    jCCFMethodArray[i].invokeMethod(this);
                } else if (jCCFMethodArray[i].getTargetname().equals("embeddedcontrol")) {
                    if (this.log.isDebug()) {
                        this.log.debug("JCCFControl", "callMethod(String)", "Now invoking method #" + i + " in embeddedcontrol " + this.getCompname());
                    }
                    jCCFMethodArray[i].invokeMethod(this.customcontrol);
                } else {
                    if (this.log.isWarn()) {
                        this.log.warn("JCCFControl", "callMethod(String)", "JCCF021 - Parameter calltarget has wrong value. " + this.getCompname());
                    }
                    JCCFException jCCFException = new JCCFException(2, 21, "JCCF021 - Parameter calltarget has wrong value. " + this.getCompname());
                    throw jCCFException;
                }
                if (jCCFMethodArray[i].getException() != null) break;
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "callMethod(String)", "Now creating return XML structure " + this.getCompname());
            }
            String string3 = XMLUtil.createStringFromDoc(jCCFMethods.getXMLDoc());
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "callMethod(String)", "END " + this.getCompname() + " " + string3);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (this.log.isError()) {
                this.log.error("JCCFControl", "callMethod(String)", "JCCF005 - Communication error: Error in xml. " + this.getCompname(), throwable);
            }
            JCCFException jCCFException = new JCCFException(1, 5, "JCCF005 - Communication error: Error in xml. " + this.getCompname(), throwable);
            try {
                String string4 = XMLUtil.createStringFromDoc(jCCFException.getXMLDoc());
                if (this.log.isDebug()) {
                    this.log.debug("JCCFControl", "callMethod(String)", "END " + this.getCompname() + " " + string4, jCCFException);
                }
                return string4;
            }
            catch (Throwable throwable2) {
                if (this.log.isError()) {
                    this.log.error("JCCFControl", "callMethod(String)", "JCCF001 - Unspecified error. " + this.getCompname(), throwable2);
                }
                new JCCFException(1, 1, "JCCF001 - Unspecified error. " + this.getCompname(), throwable2);
                if (this.log.isDebug()) {
                    this.log.debug("JCCFControl", "callMethod(String)", "END " + this.getCompname() + " null");
                }
                return null;
            }
        }
    }

    public synchronized String updateVersion(String string) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "updateVersion", "START " + this.getCompname() + " " + string);
        }
        if (string == null) {
            if (this.log.isWarn()) {
                this.log.warn("JCCFControl", "updateVersion", "Plugin contains no data!");
            }
            JCCFException jCCFException = new JCCFException(1, 1, "JCCF001 - Unspecified error. Plugin contains no data!");
            return this.generateErrorString(jCCFException, "updateVersion");
        }
        try {
            Document document = new XMLUtil().createDocument(string);
            JCCFUpdate jCCFUpdate = JCCFUpdate.getFromXML(document);
            JCCFParam[] jCCFParamArray = jCCFUpdate.getParams();
            if (jCCFParamArray == null) {
                if (this.log.isWarn()) {
                    this.log.warn("JCCFControl", "updateVersion", "Plugin " + this.getCompname() + " " + jCCFUpdate.getCompname() + " " + jCCFUpdate.getVersion() + " contains no data to update!");
                }
                if (this.log.isDebug()) {
                    this.log.debug("JCCFControl", "updateVersion", "END " + this.getCompname() + " null");
                }
                JCCFException jCCFException = new JCCFException(1, 1, "JCCF001 - Unspecified error. Plugin " + this.getCompname() + " " + jCCFUpdate.getCompname() + " " + jCCFUpdate.getVersion() + " contains no data to update!");
                return this.generateErrorString(jCCFException, "updateVersion");
            }
            for (int i = 0; i < jCCFParamArray.length; ++i) {
                this.updateRes(jCCFParamArray[i].getName(), (byte[])jCCFParamArray[i].getValue());
            }
        }
        catch (Throwable throwable) {
            JCCFException jCCFException = new JCCFException(1, 1, "JCCF001 - Unspecified error. " + this.getCompname(), throwable);
            if (this.log.isError()) {
                this.log.error("JCCFControl", "updateVersion", "JCCF001 - Unspecified error. " + this.getCompname() + " " + string, throwable);
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "updateVersion", "END " + this.generateErrorString(jCCFException, "updateVersion"));
            }
            return this.generateErrorString(jCCFException, "updateVersion");
        }
        return this.makeReturnString("updateVersion");
    }

    public synchronized void addISHMEDControlListener(JCCFControlListenerI jCCFControlListenerI) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "addISHMEDControlListener", "START " + String.valueOf(jCCFControlListenerI));
        }
        this.extEventListeners.add(jCCFControlListenerI);
    }

    public synchronized void removeISHMEDControlListener(JCCFControlListenerI jCCFControlListenerI) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "removeISHMEDControlListener", "START " + String.valueOf(jCCFControlListenerI));
        }
        this.extEventListeners.remove(jCCFControlListenerI);
    }

    public synchronized String setLogLevel(int n) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "setLogLevel", "START " + n);
        }
        switch (n) {
            case 0: {
                this.log.setConsolehandlerlevel(Level.OFF);
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "setLogLevel", "Logging: Level = OFF");
                }
                this.log.setFilehandlerlevel(Level.OFF);
                if (!this.log.isInfo()) break;
                this.log.info("JCCFControl", "setLogLevel", "Filelogging: Level = OFF");
                break;
            }
            case 1: {
                this.log.setConsolehandlerlevel(Level.SEVERE);
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "setLogLevel", "Logging: Level = ERROR");
                }
                this.log.setFilehandlerlevel(Level.SEVERE);
                if (!this.log.isInfo()) break;
                this.log.info("JCCFControl", "setLogLevel", "Filelogging: Level = ERROR");
                break;
            }
            case 2: {
                this.log.setConsolehandlerlevel(Level.WARNING);
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "setLogLevel", "Logging: Level = WARN");
                }
                this.log.setFilehandlerlevel(Level.WARNING);
                if (!this.log.isInfo()) break;
                this.log.info("JCCFControl", "setLogLevel", "Filelogging: Level = WARN");
                break;
            }
            case 3: {
                this.log.setConsolehandlerlevel(Level.INFO);
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "setLogLevel", "Logging: Level = INFO");
                }
                this.log.setFilehandlerlevel(Level.INFO);
                if (!this.log.isInfo()) break;
                this.log.info("JCCFControl", "setLogLevel", "Filelogging: Level = INFO");
                break;
            }
            case 4: {
                this.log.setConsolehandlerlevel(Level.FINE);
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "setLogLevel", "Logging: Level = DEBUG");
                }
                this.log.setFilehandlerlevel(Level.FINE);
                if (!this.log.isInfo()) break;
                this.log.info("JCCFControl", "setLogLevel", "Filelogging: Level = DEBUG");
                break;
            }
            case 5: {
                this.log.setConsolehandlerlevel(Level.ALL);
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "setLogLevel", "Logging: Level = TRACE");
                }
                this.log.setFilehandlerlevel(Level.ALL);
                if (!this.log.isInfo()) break;
                this.log.info("JCCFControl", "setLogLevel", "Filelogging: Level = TRACE");
                break;
            }
            default: {
                this.log.setConsolehandlerlevel(Level.OFF);
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "setLogLevel", "Logging: Level = OFF");
                }
                this.log.setFilehandlerlevel(Level.OFF);
                if (!this.log.isInfo()) break;
                this.log.info("JCCFControl", "setLogLevel", "Filelogging: Level = OFF");
            }
        }
        if (this.log.isInfo()) {
            this.log.info("JCCFControl", "setLogLevel", "Java Version = " + System.getProperty("java.version"));
        }
        this.log.info("JCCFControl", "setLogLevel", "JCCFControl Version = 7.6.7");
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "setLogLevel", "END " + this.makeReturnString("setLogLevel"));
        }
        return this.makeReturnString("setLogLevel");
    }

    public JCCFLoggerI getLogger() {
        if (this.context != null) {
            if (this.context.getLogger() != null) {
                return this.context.getLogger();
            }
            return new JCCFLogger(Logger.getAnonymousLogger(), null);
        }
        return new JCCFLogger(Logger.getAnonymousLogger(), null);
    }

    public JCCFContext getContext() {
        if (this.context != null) {
            return this.context;
        }
        return new JCCFContext(this, Logger.getAnonymousLogger());
    }

    protected abstract JCCFControlI getUsedControl(String var1, String var2);

    private void setUsedControlEventDispatching(String string, String string2) throws RuntimeException {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "setUsedControlEventDispatching", "START " + string + " " + string2);
        }
        try {
            this.compname = string;
            this.customcontrol = this.getUsedControl(string, string2);
            if (this.customcontrol == null) {
                JCCFException jCCFException = new JCCFException(1, 14, "JCCF014 - Custom control could not be created. ");
                if (this.log.isWarn()) {
                    this.log.warn("JCCFControl", "setUsedControlEventDispatching", "JCCF014 - Custom control could not be created. ");
                }
                throw jCCFException;
            }
            this.context.getLogger().setControlname(this.compname + logNumber);
            if (this.log.isTrace()) {
                this.log.trace("JCCFControl", "setUsedControlEventDispatching", "Invoking custom control method init.");
            }
            this.customcontrol.init(this.context);
            if (this.log.isTrace()) {
                this.log.trace("JCCFControl", "setUsedControlEventDispatching", "Invoking of custom control method init done.");
            }
            this.add((Component)((Object)this.customcontrol), "Center");
            this.validate();
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "setUsedControlEventDispatching", "END ");
            }
        }
        catch (Throwable throwable) {
            if (this.log.isInfo()) {
                this.log.info("JCCFControl", "setUsedControlEventDispatching", String.valueOf(new RuntimeException(throwable)));
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "setUsedControlEventDispatching", "END ");
            }
            throw new RuntimeException(throwable);
        }
    }

    protected void memoryProtocol() {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "memoryProtocol", "START ");
        }
        if (this.log.getConsolehandlerlevel().intValue() < Level.INFO.intValue() || this.log.getDebugconsolehandlerlevel().intValue() < Level.INFO.intValue() || this.log.getFilehandlerlevel().intValue() < Level.INFO.intValue()) {
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "memoryProtocol", "usedMemory: " + (runtime.totalMemory() - runtime.freeMemory()) / 1000L + " = " + 100L * (runtime.totalMemory() - runtime.freeMemory()) / runtime.maxMemory() + "%   maxMemory: " + runtime.maxMemory() / 1000L + "   totalMemory: " + runtime.totalMemory() / 1000L + "   freeMemory: " + runtime.freeMemory() / 1000L);
            }
        }
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "memoryProtocol", "END ");
        }
    }

    protected String unZip(byte[] byArray, int n) throws JCCFException {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "unZip", "START " + n + " " + String.valueOf(byArray));
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            JCCFInputStream jCCFInputStream = new JCCFInputStream((InputStream)byteArrayInputStream, n);
            byte[] byArray2 = new byte[n];
            int n2 = ((InputStream)jCCFInputStream).read(byArray2);
            byArray = null;
            String string = new String(byArray2, 0, n2, "UTF-8");
            byArray2 = null;
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "unZip", "END ");
            }
            return string;
        }
        catch (Throwable throwable) {
            if (this.log.isError()) {
                this.log.error("JCCFControl", "unZip", "JCCF001 - Unspecified error. " + this.getCompname(), throwable);
            }
            throw new JCCFException(1, 1, "JCCF001 - Unspecified error. " + this.getCompname(), throwable);
        }
    }

    protected String makeReturnString(String string) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "makeReturnString String", "START " + string);
        }
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "makeReturnString String", "END " + this.makeReturnString(string, null, null, null));
        }
        return this.makeReturnString(string, null, null, null);
    }

    protected String makeReturnString(String string, String string2) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "makeReturnString String String", "START " + string + " " + string2);
        }
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "makeReturnString String String", "END " + this.makeReturnString(string, string2, null, null));
        }
        return this.makeReturnString(string, string2, null, null);
    }

    protected String makeReturnString(String string, String[] stringArray, String[] stringArray2) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "makeReturnString String[] String[]", "START " + string + " " + String.valueOf(stringArray) + " " + String.valueOf(stringArray2));
        }
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "makeReturnString String[] String[]", "END " + this.makeReturnString(string, null, stringArray, stringArray2));
        }
        return this.makeReturnString(string, null, stringArray, stringArray2);
    }

    protected String makeReturnString(String string, String string2, String[] stringArray, String[] stringArray2) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "makeReturnString", "START " + string + " " + string2 + " " + String.valueOf(stringArray) + " " + String.valueOf(stringArray2));
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("msg");
            Object object = document.createElement("mret");
            Node node = document.createAttribute("name");
            node.setNodeValue(string);
            object.setAttributeNode((Attr)node);
            if (string2 != null) {
                node = document.createElement("para");
                Attr attr = document.createAttribute("type");
                attr.setNodeValue("STR");
                node.setAttributeNode(attr);
                node.appendChild(document.createTextNode(string2));
                object.appendChild(node);
            }
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    Element element2 = document.createElement("excp");
                    Attr attr = document.createAttribute("id");
                    attr.setNodeValue(stringArray[i]);
                    element2.setAttributeNode(attr);
                    element2.appendChild(document.createTextNode(stringArray2[i]));
                    object.appendChild(element2);
                }
            }
            element.appendChild((Node)object);
            document.appendChild(element);
            object = XMLUtil.createStringFromDoc(document);
            if (this.log.isTrace()) {
                this.log.trace("JCCFControl", "makeReturnString", "Uncoded: " + (String)object);
            }
            document = null;
            String string3 = Base64.encodeBytes(((String)object).getBytes("UTF-8"));
            object = null;
            if (this.log.isTrace()) {
                this.log.trace("JCCFControl", "makeReturnString", "END " + string3);
            }
            return string3;
        }
        catch (Throwable throwable) {
            if (this.log.isError()) {
                this.log.error("JCCFControl", "makeReturnString", "Error during calling JCCFControl.makeReturnString: Error in Making Return String -> Returning Empty String " + this.getCompname());
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "makeReturnString", "END empty string");
            }
            return "";
        }
    }

    protected String generateErrorString(JCCFException jCCFException, String string) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "generateErrorString", "START " + String.valueOf(jCCFException));
        }
        Throwable throwable = jCCFException;
        int n = 0;
        while (true) {
            if (this.log.isTrace()) {
                this.log.trace("JCCFControl", "generateErrorString", String.valueOf(throwable.getCause()));
            }
            if (throwable.getCause() == null) break;
            throwable = throwable.getCause();
            ++n;
        }
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        if (n > 0) {
            throwable = jCCFException;
            for (int i = 0; i < n; ++i) {
                throwable = throwable.getCause();
                stringArray[i] = throwable.getClass().toString();
                stringArray2[i] = Util.generateStackTrace(throwable);
            }
            stringArray2[0] = jCCFException.getClass().toString() + " " + jCCFException.getMessage() + "\n" + stringArray2[0];
        } else {
            stringArray = new String[1];
            stringArray2 = new String[1];
            stringArray[0] = jCCFException.getClass().toString();
            stringArray2[0] = jCCFException.getMessage();
        }
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "generateErrorString", "END " + n + " " + String.valueOf(stringArray) + " " + String.valueOf(stringArray2));
        }
        return this.makeReturnString(string, stringArray, stringArray2);
    }

    protected String callMethodWithData(String string, String string2) throws JCCFException {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "callMethodWithData", "START " + string);
        }
        Class[] classArray = new Class[]{String.class};
        Object[] objectArray = new Object[]{string2};
        try {
            Class clazz = this.getCustomControlClass();
            if (clazz != null) {
                Method method = clazz.getMethod(string, classArray);
                classArray = null;
                if (this.log.isDebug()) {
                    this.log.debug("JCCFControl", "callMethodWithData", "Invoking " + string + " " + this.getCustomControlClassName());
                }
                this.memoryProtocol();
                Object object = method.invoke((Object)this.customcontrol, objectArray);
                this.memoryProtocol();
                if (this.log.isDebug()) {
                    this.log.debug("JCCFControl", "callMethodWithData", "Invoking of " + string + " done result = " + String.valueOf(object));
                }
                objectArray = null;
                if (object != null) {
                    if (this.log.isDebug()) {
                        this.log.debug("JCCFControl", "callMethodWithData", String.valueOf(object.getClass()));
                    }
                    if (object.getClass().equals(String.class)) {
                        if (this.log.isDebug()) {
                            this.log.debug("JCCFControl", "callMethodWithData", "END " + (String)object);
                        }
                        return (String)object;
                    }
                    if (this.log.isDebug()) {
                        this.log.debug("JCCFControl", "callMethodWithData", "END null(1)");
                    }
                    return null;
                }
                if (this.log.isDebug()) {
                    this.log.debug("JCCFControl", "callMethodWithData", "END null(2)");
                }
                return null;
            }
            if (this.log.isError()) {
                this.log.error("JCCFControl", "callMethodWithData", "JCCF002 - Custom control not found. " + this.getCompname() + " " + string2);
            }
            throw new JCCFException(1, 2, "JCCF002 - Custom control not found. " + this.getCompname() + " " + string2);
        }
        catch (Throwable throwable) {
            if (this.log.isError()) {
                this.log.error("JCCFControl", "callMethodWithData", "JCCF001 - Unspecified error. " + this.getCompname() + " " + string2, throwable);
            }
            throw new JCCFException(1, 1, "JCCF001 - Unspecified error. " + this.getCompname() + " " + string2, throwable);
        }
    }

    protected String getCompname() {
        if (this.compname != null) {
            return this.compname;
        }
        return "compname";
    }

    protected Class getCustomControlClass() {
        if (this.customcontrol != null) {
            return this.customcontrol.getClass();
        }
        return null;
    }

    protected String getCustomControlClassName() {
        if (this.customcontrol != null) {
            return this.customcontrol.getClass().getName();
        }
        return "customcontrol.class.name";
    }

    protected String getBasePath() {
        URL uRL;
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "getBasePath", "START ");
        }
        if ((uRL = ClassUtilities.getClassPathComponentURL(this.getClass(), this.getClass().getClassLoader())) == null) {
            if (this.log.isWarn()) {
                this.log.warn("JCCFControl", "getBasePath", "JCCF003 - Can't identify BasePath. " + String.valueOf(this.getClass()) + " " + String.valueOf(this.getClass().getClassLoader()));
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "getBasePath", "END null");
            }
            return null;
        }
        File file = null;
        file = this.getFile(uRL);
        if (file == null) {
            return null;
        }
        File file2 = new File(file.getParent());
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "getBasePath", "END " + file2.getPath());
        }
        return file2.getPath().replaceAll("%20", " ");
    }

    protected String getJarPath() {
        URL uRL;
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "getJarPath", "START ");
        }
        if ((uRL = ClassUtilities.getClassPathComponentURL(this.getClass(), this.getClass().getClassLoader())) == null) {
            if (this.log.isWarn()) {
                this.log.warn("JCCFControl", "getJarPath", "JCCF019 - Can't identify JarPath. " + String.valueOf(this.getClass()) + " " + String.valueOf(this.getClass().getClassLoader()));
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "getJarPath", "END null");
            }
            return null;
        }
        File file = this.getFile(uRL);
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "getJarPath", "END " + file.getPath());
        }
        if (file != null) {
            return file.getPath();
        }
        return null;
    }

    protected File getFile(URL uRL) {
        return null;
    }

    protected Properties getBasisControlProperties() throws IOException {
        File file;
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "getBasisControlProperties", "START ");
        }
        Properties properties = new Properties();
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "getBasisControlProperties", "Trying to find properties within file system " + this.getBasePath() + "/ISHMEDBasisControl.properties");
        }
        if (!(file = new File(this.getBasePath() + "/ISHMEDBasisControl.properties")).exists()) {
            Object object;
            if (this.log.isInfo()) {
                this.log.info("JCCFControl", "getBasisControlProperties", "JCCF012 - No ISHMEDBasisControl.properties found. ");
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "getBasisControlProperties", "Trying to find properties within jar file " + this.getJarPath());
            }
            JarFile jarFile = new JarFile(this.getJarPath());
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "getBasisControlProperties", String.valueOf(jarFile));
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                object = ((ZipEntry)enumeration.nextElement()).getName();
                if (!this.log.isDebug()) continue;
                this.log.debug("JCCFControl", "getBasisControlProperties", (String)object);
            }
            object = jarFile.getEntry("META-INF/ISHMEDBasisControl.properties");
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "getBasisControlProperties", String.valueOf(object));
            }
            if (object == null) {
                if (this.log.isWarn()) {
                    this.log.warn("JCCFControl", "getBasisControlProperties", "JCCF013 - Jar has no META-INF/ISHMEDBasisControl.properties. " + this.getJarPath());
                }
                if (this.log.isDebug()) {
                    this.log.debug("JCCFControl", "getBasisControlProperties", "END null");
                }
                return null;
            }
            InputStream inputStream = jarFile.getInputStream((ZipEntry)object);
            properties.load(inputStream);
            inputStream.close();
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "getBasisControlProperties", "END " + String.valueOf(properties));
        }
        return properties;
    }

    protected String getPluginPath() {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "getPluginPath", "START ");
        }
        if (!this.pluginpath) {
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "getPluginPath", "END " + this.getBasePath());
            }
            return this.getBasePath();
        }
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "getPluginPath", "END " + this.getBasePath());
        }
        return this.getBasePath();
    }

    protected String getJarFilename(String string) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "getJarFilename", "START " + string);
        }
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "getJarFilename", "END " + this.getPluginPath() + this.fileSeparator + string + ".jar");
        }
        return this.getPluginPath() + this.fileSeparator + string + ".jar";
    }

    protected Properties getPluginProperties(String string) throws IOException {
        JarFile jarFile;
        ZipEntry zipEntry;
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "getPluginProperties", "START " + string);
        }
        if ((zipEntry = (jarFile = new JarFile(string)).getEntry("META-INF/plugin.properties")) == null) {
            if (this.log.isWarn()) {
                this.log.warn("JCCFControl", "getPluginProperties", "JCCF007 - Plugin has no META-INF/plugin.properties. ");
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "getPluginProperties", "END null");
            }
            jarFile.close();
            return null;
        }
        InputStream inputStream = jarFile.getInputStream(zipEntry);
        Properties properties = new Properties();
        properties.load(inputStream);
        inputStream.close();
        jarFile.close();
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "getPluginProperties", "END " + String.valueOf(properties));
        }
        return properties;
    }

    protected void handleProperties() {
        Properties properties;
        block3: {
            if (this.log.isTrace()) {
                this.log.trace("JCCFControl", "handleProperties", "START ");
            }
            properties = null;
            try {
                properties = this.getBasisControlProperties();
            }
            catch (Throwable throwable) {
                if (!this.log.isWarn()) break block3;
                this.log.warn("JCCFControl", "handleProperties", "JCCF001 - Unspecified error. ", throwable);
            }
        }
        this.handleFileLogging(properties);
        this.handlePluginPath(properties);
    }

    protected void handlePluginPath(Properties properties) {
        block11: {
            if (this.log.isTrace()) {
                this.log.trace("JCCFControl", "handlePluginPath", "START " + String.valueOf(properties));
            }
            if (properties == null) {
                return;
            }
            try {
                String string = properties.getProperty("pluginpath");
                if (string == null) {
                    if (this.log.isInfo()) {
                        this.log.info("JCCFControl", "handlePluginPath", "Usage of plugins path for custom controls is off");
                    }
                    this.pluginpath = false;
                } else if (!string.equals("true")) {
                    if (this.log.isInfo()) {
                        this.log.info("JCCFControl", "handlePluginPath", "Usage of plugins path for custom controls is off");
                    }
                    this.pluginpath = false;
                } else {
                    if (this.log.isInfo()) {
                        this.log.info("JCCFControl", "handlePluginPath", "Usage of plugins path for custom controls is on");
                    }
                    this.pluginpath = true;
                }
            }
            catch (Throwable throwable) {
                if (!this.log.isWarn()) break block11;
                this.log.warn("JCCFControl", "handlePluginPath", "JCCF001 - Unspecified error. ", throwable);
            }
        }
    }

    protected void handleFileLogging(Properties properties) {
        block37: {
            if (this.log.isTrace()) {
                this.log.trace("JCCFControl", "handleFileLogging", "START " + String.valueOf(properties));
            }
            this.getLogSettings(properties);
            try {
                Object object;
                if (!this.isFileLoggingActive(properties)) {
                    return;
                }
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "handleFileLogging", "Filelogging is on");
                }
                Object object2 = this.getLoggingPath(properties);
                if (this.log.isDebug()) {
                    this.log.debug("JCCFControl", "handleFileLogging", "Filelogging: Filename given in properties: " + (String)object2);
                }
                if (object2 == null || !this.openFileTest((String)object2)) {
                    object = this.fileSeparator + "dummy.log";
                    boolean bl = false;
                    if (!javagui) {
                        if (this.log.isDebug()) {
                            this.log.debug("JCCFControl", "handleFileLogging", "Filelogging: Trying user.home");
                        }
                        object2 = System.getProperty("user.home") + (String)object;
                        if (this.log.isDebug()) {
                            this.log.debug("JCCFControl", "handleFileLogging", "Filelogging: Filename given in user.home: " + (String)object2);
                        }
                        bl = this.openFileTest((String)object2);
                    }
                    if (!bl) {
                        if (this.log.isDebug()) {
                            this.log.debug("JCCFControl", "handleFileLogging", "Filelogging: Trying java.io.tmpdir");
                        }
                        object2 = System.getProperty("java.io.tmpdir") + (String)object;
                        if (this.log.isDebug()) {
                            this.log.debug("JCCFControl", "handleFileLogging", "Filelogging: Filename given in java.io.tmpdir: " + (String)object2);
                        }
                        if (!this.openFileTest((String)object2)) {
                            if (this.log.isWarn()) {
                                this.log.warn("JCCFControl", "handleFileLogging", "Filelogging: Logfile could not be created.");
                            }
                            object2 = null;
                        }
                    }
                }
                if (object2 != null) {
                    if (this.log.isInfo()) {
                        this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Logfile " + (String)object2 + " could be created.");
                    }
                    this.log.setLoggingPath((String)object2);
                } else {
                    if (this.log.isWarn()) {
                        this.log.warn("JCCFControl", "handleFileLogging", "Filelogging: Output Stream could not be created. No logging will be done.");
                    }
                    this.log.setFilehandlerlevel(Level.OFF);
                    if (this.log.isInfo()) {
                        this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Level = OFF");
                    }
                }
                object = this.getFileLoggingLevel(properties);
                if (object != null) {
                    switch (Integer.valueOf((String)object)) {
                        case 0: {
                            this.log.setFilehandlerlevel(Level.OFF);
                            if (this.log.isInfo()) {
                                this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Level = OFF");
                                break;
                            }
                            break block37;
                        }
                        case 1: {
                            this.log.setFilehandlerlevel(Level.SEVERE);
                            if (this.log.isInfo()) {
                                this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Level = ERROR");
                                break;
                            }
                            break block37;
                        }
                        case 2: {
                            this.log.setFilehandlerlevel(Level.WARNING);
                            if (this.log.isInfo()) {
                                this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Level = WARN");
                                break;
                            }
                            break block37;
                        }
                        case 3: {
                            this.log.setFilehandlerlevel(Level.INFO);
                            if (this.log.isInfo()) {
                                this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Level = INFO");
                                break;
                            }
                            break block37;
                        }
                        case 4: {
                            this.log.setFilehandlerlevel(Level.FINE);
                            if (this.log.isInfo()) {
                                this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Level = DEBUG");
                                break;
                            }
                            break block37;
                        }
                        case 5: {
                            this.log.setFilehandlerlevel(Level.ALL);
                            if (this.log.isInfo()) {
                                this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Level = TRACE");
                                break;
                            }
                            break block37;
                        }
                        default: {
                            this.log.setFilehandlerlevel(Level.OFF);
                            if (this.log.isInfo()) {
                                this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Level = OFF");
                                break;
                            }
                            break block37;
                        }
                    }
                    break block37;
                }
                this.log.setFilehandlerlevel(Level.OFF);
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Level = OFF");
                }
            }
            catch (Throwable throwable) {
                if (!this.log.isWarn()) break block37;
                this.log.warn("JCCFControl", "handleFileLogging", "JCCF001 - Unspecified error. ", throwable);
            }
        }
    }

    protected String checkLoggingFileName(String string) {
        return null;
    }

    protected String getLoggingPath(Properties properties) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "getLoggingPath", "START " + String.valueOf(properties));
        }
        if (properties != null) {
            if (this.log.isInfo()) {
                this.log.info("JCCFControl", "getLoggingPath", "Filelogging path : " + properties.getProperty("filelogging.filename"));
            }
            return properties.getProperty("filelogging.filename");
        }
        if (this.log.isInfo()) {
            this.log.info("JCCFControl", "getLoggingPath", "Filelogging path : null");
        }
        return null;
    }

    protected String getFileLoggingLevel(Properties properties) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "getFileLoggingLevel", "START " + String.valueOf(properties));
        }
        if (properties != null) {
            if (this.log.isInfo()) {
                this.log.info("JCCFControl", "getFileLoggingLevel", "Filelogging Level : " + properties.getProperty("filelogging.level"));
            }
            return properties.getProperty("filelogging.level");
        }
        return null;
    }

    protected boolean isFileLoggingActive(Properties properties) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "isFileLoggingActive", "START " + String.valueOf(properties));
        }
        if (properties != null) {
            String string = properties.getProperty("filelogging");
            if (string == null) {
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "handleFileLogging", "Filelogging is off");
                }
                return false;
            }
            if (!string.equals("true")) {
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "handleFileLogging", "Filelogging is off");
                }
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean createNewLoggingFile(Properties properties) {
        boolean bl = false;
        if (properties != null) {
            String string = properties.getProperty("filelogging.noappend");
            if (string == null) {
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Noappend is off");
                }
            } else if (!string.equals("true")) {
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Noappend is off");
                }
            } else {
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Noappend is on");
                }
                String string2 = properties.getProperty("filelogging.noappend.eachsession");
                boolean bl2 = false;
                if (string2 == null) {
                    if (this.log.isInfo()) {
                        this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Noappend for each session is off");
                    }
                } else if (!string2.equals("true")) {
                    if (this.log.isInfo()) {
                        this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Noappend for each session is off");
                    }
                } else {
                    if (this.log.isInfo()) {
                        this.log.info("JCCFControl", "handleFileLogging", "Filelogging: Noappend for each session is on");
                    }
                    bl2 = true;
                }
                if (bl2) {
                    bl = true;
                } else if (!logfileresetdone) {
                    logfileresetdone = true;
                    bl = true;
                }
            }
        }
        return bl;
    }

    protected void getLogSettings(Properties properties) {
        long l = 0L;
        if (properties != null) {
            String string = properties.getProperty("filelogging.oldlogfileage");
            if (string == null) {
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "getLogSettings", "Filelogging: oldlogfileage off");
                }
                l = 2419200000L;
            } else {
                l = string != null && !string.equalsIgnoreCase("") ? Long.parseLong(string) : 2419200000L;
            }
        } else {
            l = 2419200000L;
        }
        this.log.setLogOldFileAge(l);
        int n = 0;
        if (properties != null) {
            String string = properties.getProperty("filelogging.splitlogfilesize");
            if (string == null) {
                if (this.log.isInfo()) {
                    this.log.info("JCCFControl", "getLogSettings", "Filelogging: splitlogfilesize off");
                }
                n = 10;
            } else {
                n = string != null && !string.equalsIgnoreCase("") ? Integer.parseInt(string) : 10;
            }
        } else {
            n = 10;
        }
        this.log.setLogFileSize(n);
    }

    protected boolean openFileTest(String string) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "openFileTest", "START " + string);
        }
        if (string == null) {
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "openFileTest", "File name is null.");
            }
            return false;
        }
        if (string.equals("")) {
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "openFileTest", "File name is empty.");
            }
            return false;
        }
        try {
            boolean bl;
            File file;
            block27: {
                file = new File(string);
                bl = false;
                if (file.exists()) {
                    if (this.log.isDebug()) {
                        this.log.debug("JCCFControl", "openFileTest", "File " + string + " exists.");
                    }
                    bl = true;
                } else {
                    if (this.log.isDebug()) {
                        this.log.debug("JCCFControl", "openFileTest", "File " + string + " does not exist.");
                    }
                    try {
                        if (file.createNewFile()) {
                            if (this.log.isDebug()) {
                                this.log.debug("JCCFControl", "openFileTest", "File " + string + " created.");
                            }
                            break block27;
                        }
                        if (this.log.isDebug()) {
                            this.log.debug("JCCFControl", "openFileTest", "File " + string + " not created.");
                        }
                        return false;
                    }
                    catch (Throwable throwable) {
                        String string2 = file.getAbsolutePath();
                        String[] stringArray = string2.split(file.getName());
                        File file2 = new File(stringArray[0]);
                        file2.mkdirs();
                        if (file.createNewFile()) {
                            if (this.log.isDebug()) {
                                this.log.debug("JCCFControl", "openFileTest", "File " + string + " created.");
                            }
                        }
                        if (this.log.isDebug()) {
                            this.log.debug("JCCFControl", "openFileTest", "File " + string + " not created.");
                        }
                        return false;
                    }
                }
            }
            if (file.canWrite()) {
                if (this.log.isDebug()) {
                    this.log.debug("JCCFControl", "openFileTest", "Write access to file " + string + " is true");
                }
                if (!bl) {
                    file.delete();
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "openFileTest", "Write access to file " + string + " is false");
            }
            if (!bl) {
                file.delete();
            }
            return false;
        }
        catch (SecurityException securityException) {
            if (this.log.isDebug()) {
                this.log.debug("JCCFControl", "openFileTest", "No write access to file " + string);
            }
            return false;
        }
        catch (Throwable throwable) {
            if (this.log.isWarn()) {
                this.log.warn("JCCFControl", "openFileTest", "JCCF001 - Unspecified error. ", throwable);
            }
            return false;
        }
    }

    protected void updateRes(String string, byte[] byArray) throws IOException {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "updateRes", "START " + string + " " + String.valueOf(byArray));
        }
        String string2 = this.getPluginPath() + this.fileSeparator + string;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2), 4096);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.writeTo(bufferedOutputStream);
        byteArrayOutputStream.close();
        ((OutputStream)bufferedOutputStream).close();
    }

    public void fireCustomEvent(JCCFEvent jCCFEvent) {
        block4: {
            if (this.log.isTrace()) {
                this.log.trace("JCCFControl", "fireCustomEvent", "START " + String.valueOf(jCCFEvent));
            }
            this.memoryProtocol();
            try {
                String string = XMLUtil.createStringFromDoc(jCCFEvent.getXMLDoc());
                String string2 = Base64.encodeBytes(string.getBytes("UTF-8"));
                string = null;
                this.doFireCustomEvent(string2);
            }
            catch (Throwable throwable) {
                if (!this.log.isError()) break block4;
                this.log.error("JCCFControl", "fireCustomEvent", "JCCF001 - Unspecified error. " + this.getCompname(), throwable);
            }
        }
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "fireCustomEvent", "END ");
        }
        this.memoryProtocol();
    }

    protected void doFireCustomEvent(String string) {
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "doFireCustomEvent", "START " + string);
        }
        if (this.log.isTrace()) {
            this.log.trace("JCCFControl", "doFireCustomEvent", this.extEventListeners.size() + " " + String.valueOf(this.extEventListeners));
        }
        for (int i = 0; i < this.extEventListeners.size(); ++i) {
            JCCFControlListenerI jCCFControlListenerI = (JCCFControlListenerI)this.extEventListeners.get(i);
            this.memoryProtocol();
            jCCFControlListenerI.customEvent(string);
            this.memoryProtocol();
        }
        if (this.log.isDebug()) {
            this.log.debug("JCCFControl", "doFireCustomEvent", "END ");
        }
    }

    class JCCFControlEventlListener
    implements JCCFControlEventlListenerI {
        JCCFControlEventlListener() {
        }

        @Override
        public void customEvent(JCCFEvent jCCFEvent) {
            JCCFControl.this.fireCustomEvent(jCCFEvent);
        }
    }
}

