/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.selector.font;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ItemChooser
extends JPanel {
    private static final long serialVersionUID = 6503362736154584936L;
    String name;
    String[] labels;
    Object[] values;
    int selection;
    JList list;
    JTextField jItemTF;
    ArrayList<Listener> listeners = new ArrayList();

    public ItemChooser(String name, String[] labels, Object[] values, int defaultSelection) {
        this.name = name;
        this.labels = labels;
        this.values = values;
        this.selection = defaultSelection;
        if (values == null) {
            this.values = labels;
        }
        this.initComponents();
    }

    public ItemChooser(String name, String[] labels, Object[] values, Object o) {
        this.name = name;
        this.labels = labels;
        this.values = values;
        if (values == null) {
            this.values = labels;
        }
        this.initComponents();
        if (o != null) {
            this.setSelected(o);
        }
    }

    void initComponents() {
        this.list = new JList<String>(this.labels);
        this.list.setSelectedIndex(this.selection);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ItemChooser.this.select(ItemChooser.this.list.getSelectedIndex());
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        JTextField jTextField1 = new JTextField(this.name);
        jTextField1.setEditable(false);
        jTextField1.setBorder(null);
        this.add(jTextField1);
        this.jItemTF = new JTextField(this.labels[this.selection]);
        this.jItemTF.setEditable(false);
        this.add(this.jItemTF);
        this.add(new JScrollPane(this.list));
    }

    protected void select(int selection) {
        this.selection = selection;
        this.jItemTF.setText(this.labels[selection]);
        if (!this.listeners.isEmpty()) {
            Event e = new Event(this, selection, this.values[selection]);
            for (Listener l : this.listeners) {
                l.itemChosen(e);
            }
        }
    }

    protected void setSelected(Object o) {
        this.list.setSelectedValue(o, true);
        this.selection = this.list.getSelectedIndex();
    }

    public void addItemChooserListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeItemChooserListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public int getSelectedIndex() {
        return this.selection;
    }

    public Object getSelectedValue() {
        return this.values[this.selection];
    }

    public void setSelectedIndex(int selection) {
        this.list.setSelectedIndex(selection);
        this.jItemTF.setText((String)this.list.getSelectedValue());
        this.selection = selection;
    }

    public static class Event
    extends EventObject {
        private static final long serialVersionUID = 7293932007628164202L;
        int selectedIndex;
        Object selectedValue;

        public Event(ItemChooser source, int selectedIndex, Object selectedValue) {
            super(source);
            this.selectedIndex = selectedIndex;
            this.selectedValue = selectedValue;
        }

        public ItemChooser getItemChooser() {
            return (ItemChooser)this.getSource();
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public Object getSelectedValue() {
            return this.selectedValue;
        }
    }

    public static interface Listener
    extends EventListener {
        public void itemChosen(Event var1);
    }
}

