/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.selector.color;

import java.awt.Color;

public class PropertyColor {
    private String name;
    private String value;
    private String id;

    public PropertyColor(String theId, String theName, String theValue) {
        this.id = theId;
        this.name = theName;
        this.value = theValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Color getColor() {
        if (this.value == null || this.value.trim().equals("")) {
            return Color.GRAY;
        }
        int len = this.value.length();
        int[] color = new int[len / 2];
        int pos = 0;
        while (pos < len) {
            color[pos / 2] = this.hex2Int(this.value.substring(pos, pos + 2));
            pos += 2;
        }
        return len == 6 ? new Color(color[0], color[1], color[2]) : new Color(color[0], color[1], color[2], color[3]);
    }

    private int hex2Int(String theHexString) {
        return Integer.decode("0x" + theHexString);
    }

    public void setColor(Color color) {
        Object blue;
        Object green;
        if (color == null) {
            return;
        }
        Object red = Integer.toHexString(color.getRed());
        if (((String)red).length() == 1) {
            red = "0" + (String)red;
        }
        if (((String)(green = Integer.toHexString(color.getGreen()))).length() == 1) {
            green = "0" + (String)green;
        }
        if (((String)(blue = Integer.toHexString(color.getBlue()))).length() == 1) {
            blue = "0" + (String)blue;
        }
        this.value = (String)red + (String)green + (String)blue;
    }

    public String getId() {
        return this.id;
    }
}

