/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.gui.client.utl;

import com.ishmed.gui.client.utl.Utils;
import com.ishmed.selector.font.FontSelect;
import com.ishmed.tech.client.jccf.JCCFContext;
import com.ishmed.tech.client.jccf.util.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.JComponent;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FontSelector
extends Utils {
    private static final long serialVersionUID = 1819586565717931942L;
    private FontSelect fontSelector;

    public void update(String s) {
        this.helper.logEntering("FontSelector", "update");
        try {
            this.setVisible(false);
            this.removeAll();
            Dimension d = this.getParent().getSize();
            this.colorChoiceProperty.choice_width = (int)d.getWidth();
            this.colorChoiceProperty.choice_heigth = (int)d.getHeight();
            this.setLayout(new BorderLayout());
            if (this.fontSelector == null) {
                this.fontSelector = new FontSelect(null, null, null, null, null, null, null, null, null);
            }
            this.add((Component)this.fontSelector, "Center");
            return;
        }
        catch (Exception e) {
            this.helper.logThrowing("FontSelector", "update", e);
            this.colorChoiceProperty.error.append("update: " + e.toString() + ".\n");
            e.printStackTrace();
        }
        finally {
            this.validate();
            this.repaint();
            this.setVisible(true);
            if (this.colorChoiceProperty.error.length() > 0) {
                this.helper.showMessage(this.colorChoiceProperty.error.toString());
            }
            this.helper.logExiting("FontSelector", "update");
        }
    }

    @Override
    public void destroyMe(String s) {
        this.helper.logEntering("FontSelector", "free");
        super.destroyMe(s);
        this.colorChoiceProperty = null;
        this.helper = null;
        if (this.fontSelector != null) {
            this.fontSelector.free();
        }
        this.fontSelector = null;
        this.helper.logExiting("FontSelector", "free");
    }

    public void setFonts(String data) {
        this.helper.logEntering("FontSelector", "setFonts", data);
        try {
            NodeList nodeList = this.helper.getRootNode(data).getChildNodes();
            String headerFontName = XMLUtil.getNodeValueS((NodeList)nodeList, (String)"FNH");
            String headerFontStyle = XMLUtil.getNodeValueS((NodeList)nodeList, (String)"FHS");
            String headerFontSize = XMLUtil.getNodeValueS((NodeList)nodeList, (String)"FHSI");
            String pain = XMLUtil.getNodeValueS((NodeList)nodeList, (String)"SP");
            String italic = XMLUtil.getNodeValueS((NodeList)nodeList, (String)"SI");
            String bold = XMLUtil.getNodeValueS((NodeList)nodeList, (String)"SB");
            String boldItalic = XMLUtil.getNodeValueS((NodeList)nodeList, (String)"SBI");
            String testString = XMLUtil.getNodeValueS((NodeList)nodeList, (String)"TS");
            String fontName = XMLUtil.getNodeValueS((NodeList)nodeList, (String)"FN");
            boolean fItalic = this.helper.getBooleanValue(XMLUtil.getNodeValueS((NodeList)nodeList, (String)"FI"));
            boolean fBold = this.helper.getBooleanValue(XMLUtil.getNodeValueS((NodeList)nodeList, (String)"FB"));
            int size = XMLUtil.getNodeValueI((NodeList)nodeList, (String)"FS");
            Font font = null;
            if (fontName != null && !fontName.equals("")) {
                int stayl = 0;
                if (fItalic && fBold) {
                    stayl = 3;
                } else if (fItalic) {
                    stayl = 2;
                } else if (fBold) {
                    stayl = 1;
                }
                font = new Font(fontName, stayl, size);
            }
            this.fontSelector = new FontSelect(headerFontName, headerFontStyle, headerFontSize, pain, italic, bold, boldItalic, font, testString);
            this.update();
        }
        catch (Exception e) {
            this.helper.logThrowing("FontSelector", "getColors", e);
            this.fontSelector = new FontSelect(null, null, null, null, null, null, null, null, null);
            this.colorChoiceProperty.error.append("setFonts: " + e.toString() + ". Daten" + data + "\n");
            e.printStackTrace(System.err);
        }
        this.helper.logExiting("FontSelector", "setFonts");
    }

    public String getSelFont(String s) {
        this.helper.logEntering("FontSelector", "getSelFont");
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("FONT");
            doc.appendChild(root);
            Font f = this.fontSelector.getSelectedFont();
            Element attrib = doc.createElement("FN");
            root.appendChild(attrib);
            attrib.appendChild(doc.createTextNode(f.getFamily()));
            attrib = doc.createElement("FI");
            root.appendChild(attrib);
            if (f.isItalic()) {
                attrib.appendChild(doc.createTextNode("X"));
            } else {
                attrib.appendChild(doc.createTextNode(" "));
            }
            attrib = doc.createElement("FB");
            root.appendChild(attrib);
            if (f.isBold()) {
                attrib.appendChild(doc.createTextNode("X"));
            } else {
                attrib.appendChild(doc.createTextNode(" "));
            }
            attrib = doc.createElement("FS");
            root.appendChild(attrib);
            String size = Integer.toString(f.getSize());
            attrib.appendChild(doc.createTextNode(size));
            String result = this.helper.createStringFromDoc(doc);
            this.helper.logExiting("FontSelector", "getSelFont", result);
            return result;
        }
        catch (Exception e) {
            this.helper.logThrowing("FontSelector", "getSelFont", e);
            this.colorChoiceProperty.error.append("getSelFont: " + e.toString() + ".\n");
            e.printStackTrace(System.err);
            return "";
        }
    }

    public String getAvailableFonts(String s) {
        this.helper.logEntering("FontSelector", "getAvailableFonts");
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.appendAvailableFonts(doc);
            String result = this.helper.createStringFromDoc(doc);
            this.helper.logExiting("FontSelector", "getAvailableFonts", result);
            return result;
        }
        catch (Exception e) {
            this.helper.logThrowing("FontSelector", "getAvailableFonts", e);
            this.colorChoiceProperty.error.append("getAvailableFonts: " + e.toString() + ".\n");
            e.printStackTrace(System.err);
            this.helper.logExiting("FontSelector", "getAvailableFonts");
            return "";
        }
    }

    protected void appendAvailableFonts(Document doc) {
        try {
            GraphicsEnvironment graphics = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font[] fonts = graphics.getAllFonts();
            Element root = doc.createElement("FONTS");
            Node firstChild = doc.getFirstChild();
            if (firstChild != null) {
                firstChild.appendChild(root);
            } else {
                doc.appendChild(root);
            }
            if (fonts == null || fonts.length == 0) {
                return;
            }
            int i = fonts.length;
            int x = 0;
            while (x < i) {
                Element item = doc.createElement("A");
                root.appendChild(item);
                Element attrib = doc.createElement("NA");
                item.appendChild(attrib);
                attrib.appendChild(doc.createTextNode(fonts[x].getFontName()));
                ++x;
            }
        }
        catch (Exception ex) {
            this.helper.logThrowing("FontSelector", "appendAvailableFonts", ex);
            this.colorChoiceProperty.error.append("availableFonts_Get: " + ex.toString() + ".\n");
        }
    }

    @Override
    public String getVersionInfo(String s) {
        this.helper.logEntering("FontSelector", "getVersionInfo");
        this.helper.logExiting("FontSelector", "getVersionInfo", "7.2.1");
        return "7.2.1";
    }

    @Override
    public JComponent getControl() {
        return this;
    }

    @Override
    public Object getPrint() {
        return this;
    }

    @Override
    public void init(JCCFContext context) {
        this.context = context;
        if (context != null) {
            this.colorChoiceProperty.log = context.getLogger();
        }
    }
}

