/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler604.preview;

import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import at.tsa.ishmed.appmntmgmnt.scheduler604.preview.PreviewPrintAction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;

class Preview
extends JComponent {
    private static final long serialVersionUID = 8440763002889831165L;
    private static final int DEFAULT_PREVIEW_SIZE = 300;
    private static final double MINIMUM_ZOOM_FACTOR = 0.1;
    protected Pageable pageable;
    protected PreviewPrintAction previewPrintAction;
    protected int index = 0;
    protected double zoom = 0.0;
    protected Helper helper;

    public Preview(Pageable pageable, double zoom, PreviewPrintAction previewPrintAction, Helper theHelper) {
        this.pageable = pageable;
        this.previewPrintAction = previewPrintAction;
        this.helper = theHelper;
        PageFormat format = pageable.getPageFormat(this.index);
        this.zoom = zoom == 0.0 ? (format.getOrientation() == 1 ? 300.0 / format.getHeight() : 300.0 / format.getWidth()) : zoom;
        this.resize();
    }

    protected void paintPaper(Graphics g, PageFormat format) {
        g.setColor(Color.white);
        g.fillRect(0, 0, (int)format.getWidth(), (int)format.getHeight());
        g.setColor(Color.black);
        g.drawRect(0, 0, (int)format.getWidth() - 1, (int)format.getHeight() - 1);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.scale(this.zoom, this.zoom);
        try {
            PageFormat format = this.pageable.getPageFormat(this.index);
            double scal = this.zoom;
            int m_wPage = (int)(format.getWidth() * scal);
            int m_hPage = (int)(format.getHeight() * scal);
            BufferedImage img = new BufferedImage(m_wPage, m_hPage, 1);
            Graphics g1 = img.getGraphics();
            g1.fillRect(0, 0, m_wPage, m_hPage);
            g1.setColor(Color.white);
            Graphics2D g2d2 = (Graphics2D)g1;
            g2d2.scale(scal, scal);
            Printable printable = this.pageable.getPrintable(this.index);
            printable.print(g1, format, this.index);
            g2d.scale(1.0 / scal, 1.0 / scal);
            g.drawImage(img, 0, 0, this);
        }
        catch (PrinterException ex) {
            this.helper.logThrowing("Preview", "paintComponent", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
        catch (IndexOutOfBoundsException ex) {
            this.helper.logThrowing("Preview", "paintComponent", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
    }

    public void moveIndex(int indexStep) {
        int newIndex = this.index + indexStep;
        try {
            if (newIndex < 0) {
                newIndex = 0;
            }
            this.pageable.getPrintable(newIndex);
            this.resize();
            this.index = newIndex;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void changeZoom(double zoom) {
        this.zoom = Math.max(0.1, this.zoom + zoom);
        this.resize();
    }

    public void resize() {
        PageFormat format = this.pageable.getPageFormat(this.index);
        int size = (int)Math.max(format.getWidth() * this.zoom, format.getHeight() * this.zoom);
        this.setPreferredSize(new Dimension(size, size));
        this.revalidate();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean print() {
        if (this.previewPrintAction != null) {
            return this.previewPrintAction.print();
        }
        return false;
    }
}

