/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.system.gui;

import at.tsa.ishmed.appmntmgmnt.Flag;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JToolTip;

public class GroundLayeredPane
extends JLayeredPane {
    private static final long serialVersionUID = 1692956488411375322L;
    private JLabel toolTipLable = new JLabel();
    public boolean tipShowing = false;
    String oldToolTip = null;
    JToolTip tip;
    protected SchedulerProperty schedulerProperty = null;

    public GroundLayeredPane(SchedulerProperty theSchedulerProperty) {
        this.setOpaque(false);
        this.setDoubleBuffered(true);
        this.schedulerProperty = theSchedulerProperty;
        this.add((Component)this.toolTipLable, JLayeredPane.POPUP_LAYER);
        this.toolTipLable.setBorder(BorderFactory.createLineBorder(this.schedulerProperty.border));
        this.toolTipLable.setEnabled(false);
        this.toolTipLable.setOpaque(true);
        this.toolTipLable.setBackground(this.schedulerProperty.tooltipBackGround);
        this.toolTipLable.setFocusable(false);
        this.toolTipLable.setDoubleBuffered(true);
        this.toolTipLable.setRequestFocusEnabled(Flag.reFou);
        this.setFocusable(Flag.focus);
        this.setRequestFocusEnabled(Flag.reFou);
    }

    public void showTipWindow(String text, int x, int y) {
        int winX = x;
        Rectangle sBounds = this.getBounds();
        Rectangle view = this.getVisibleRect();
        if (text == null || text.equals("")) {
            this.hideTipWindow();
            return;
        }
        if (this.oldToolTip != null && this.oldToolTip.equals(text)) {
            Dimension size = this.toolTipLable.getSize();
            if (x + size.width > sBounds.width) {
                winX = x - size.width - 10;
                if (winX < 0) {
                    winX = x;
                }
            } else {
                int tipHeight = y + size.height;
                int groundHeight = view.y + view.height;
                if (tipHeight > groundHeight) {
                    y = y - size.height + (groundHeight - tipHeight);
                }
            }
            this.toolTipLable.setLocation(winX, y);
            this.toolTipLable.setVisible(true);
            this.tipShowing = true;
            return;
        }
        this.toolTipLable.setText(text);
        this.oldToolTip = text;
        this.tip = this.createToolTip();
        this.tip.setTipText(text);
        Dimension size = this.tip.getPreferredSize();
        if (x + size.width > sBounds.width && (winX = x - size.width - 11) < 0) {
            winX = x;
        }
        if (y < sBounds.y) {
            y = sBounds.y;
        } else {
            int tipHeight = y + size.height;
            int groundHeight = view.y + view.height;
            if (tipHeight > groundHeight) {
                y = y - size.height - (groundHeight - tipHeight);
            }
        }
        this.tipShowing = true;
        this.toolTipLable.setVisible(true);
        this.toolTipLable.setFont(this.tip.getFont());
        this.toolTipLable.setBounds(winX, y, size.width, size.height);
    }

    public void hideTipWindow() {
        if (this.tipShowing) {
            this.toolTipLable.setVisible(false);
        }
        this.tipShowing = false;
    }

    public void free() {
        this.toolTipLable = null;
        this.oldToolTip = null;
        this.tip = null;
        this.removeAll();
    }
}

