/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.system.gui;

import at.tsa.ishmed.appmntmgmnt.Flag;
import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.RegCard;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.base.Titel;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.DefaultPanel;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.ui.MyTabbedPaneUI;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.JToolTip;
import javax.swing.UIManager;

public class DefaultJTabbedPane
extends JTabbedPane
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private TreeMap<Integer, RegCard> regCards = null;
    private SchedulerProperty schedulerProperty;
    private Scheduler scheduler;

    public DefaultJTabbedPane(SchedulerProperty theSchedulerProperty, Scheduler theScheduler) {
        this.schedulerProperty = theSchedulerProperty;
        this.scheduler = theScheduler;
        this.init();
    }

    public DefaultJTabbedPane(SchedulerProperty theSchedulerProperty, TreeMap<Integer, RegCard> theRegCards, int width, Scheduler theScheduler) {
        this(theSchedulerProperty, theScheduler);
        this.regCards = theRegCards;
        this.addRegCrds(width);
    }

    private void init() {
        if (this.schedulerProperty.winGUI && this.schedulerProperty.colorBackgrTabNotSel != null && this.schedulerProperty.colorBackgrClose != null && this.schedulerProperty.colorBackgrTabSel != null) {
            this.setUI();
        }
        this.setDoubleBuffered(true);
        this.setFocusable(Flag.focus);
        this.setRequestFocusEnabled(Flag.reFou);
        this.setTabLayoutPolicy(1);
        this.regCards = new TreeMap();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip tt = super.createToolTip();
        tt.setEnabled(true);
        tt.setBackground(this.schedulerProperty.tooltipBackGround);
        return tt;
    }

    public void free() {
        this.setVisible(false);
        this.removeAll();
        this.regCards = null;
        this.setVisible(true);
    }

    public void addRegCard(int regCardInd, String regCardID, Titel inscription) {
        RegCard regCard = new RegCard(regCardInd, regCardID, inscription);
        this.regCards.put(regCardInd, regCard);
        regCard.setWidthOfBlank(this.getFontMetrics(inscription.getFont()).stringWidth(" ") + 1);
        regCard.setWidthOfDescription(this.getFontMetrics(inscription.getFont()).stringWidth(inscription.getDescription()));
    }

    public int addRegCrds(int width) {
        this.setVisible(false);
        this.removeAll();
        if (this.regCards == null || this.regCards.size() == 0) {
            return -1;
        }
        Iterator<RegCard> it = this.getRegCardIterator();
        int widthOfRegCard = 0;
        if (this.schedulerProperty.nrOfRegs > 0) {
            widthOfRegCard = width / this.schedulerProperty.nrOfRegs - this.schedulerProperty.nrOfRegs * 2;
        }
        StringBuffer filler = new StringBuffer();
        int selectedRegCard = -1;
        while (it.hasNext()) {
            RegCard regCard = it.next();
            DefaultPanel jPanel = new DefaultPanel();
            if (this.schedulerProperty.winGUI && this.schedulerProperty.colorBackgrTabNotSel != null) {
                jPanel.setBackground(this.schedulerProperty.colorBackgrTabNotSel);
            }
            filler.setLength(0);
            if (this.schedulerProperty.nrOfRegs > 0) {
                int widthOfDescription = regCard.getWidthOfDescription();
                int remainder = (widthOfRegCard - widthOfDescription - this.schedulerProperty.nrOfRegs * 0) / regCard.getWidthOfBlank();
                int i = 0;
                while (i < remainder) {
                    filler.append(" ");
                    ++i;
                }
            }
            if (widthOfRegCard < 1) {
                widthOfRegCard = 1;
            }
            this.setFont(regCard.getInscription().getFont());
            if (this.schedulerProperty.regIdent.equalsIgnoreCase(regCard.getRegCardID())) {
                selectedRegCard = regCard.getRegCardIndex() - 1;
                URL icon = this.getClass().getResource("/at/tsa/ishmed/appmntmgmnt/scheduler/images/pkt_gruen.gif");
                if (icon != null) {
                    this.addTab(regCard.getDescription() + filler.toString(), new ImageIcon(icon), jPanel, null);
                } else {
                    this.addTab(regCard.getDescription() + filler.toString(), null, jPanel, null);
                }
            } else {
                this.addTab(regCard.getDescription() + filler.toString(), null, jPanel, null);
            }
            this.setForegroundAt(regCard.getRegCardIndex() - 1, regCard.getInscription().getFontColor());
        }
        if (selectedRegCard > -1) {
            this.setSelectedIndex(selectedRegCard);
        }
        this.setMaximumSize(new Dimension(width, this.schedulerProperty.heightOfJTabbedPane));
        this.setPreferredSize(new Dimension(width, this.schedulerProperty.heightOfJTabbedPane));
        this.setVisible(true);
        return selectedRegCard;
    }

    public RegCard getRegCardAt(int index) {
        if (this.regCards != null) {
            return this.regCards.get(index);
        }
        return null;
    }

    public Iterator<RegCard> getRegCardIterator() {
        return this.regCards.values().iterator();
    }

    protected void setUI() {
        if (this.schedulerProperty.winGUI && !(UIManager.getUI(this) instanceof MyTabbedPaneUI)) {
            MyTabbedPaneUI mTPUI = new MyTabbedPaneUI(this.schedulerProperty);
            this.setUI(mTPUI);
            mTPUI.installUI(this);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int index = this.indexAtLocation(e.getX(), e.getY());
        if (index > -1 && index < this.getTabCount()) {
            RegCard regCard = this.getRegCardAt(++index);
            this.scheduler.ground.showTipWindow(this.scheduler.getHelper().buildTooltipText(regCard.getDescription(), false, regCard.getInscription().getFontName()), e.getX(), e.getY() + 20);
        } else {
            this.scheduler.ground.hideTipWindow();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.scheduler.ground.hideTipWindow();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

