/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.system.gui;

import at.tsa.ishmed.appmntmgmnt.Flag;
import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.JDefaultPopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import org.w3c.dom.NodeList;

public class BaseJArea
extends JTextArea
implements ActionListener,
MouseListener,
MouseMotionListener,
FocusListener {
    private static final long serialVersionUID = 470019979087061074L;
    protected SchedulerProperty schedulerProperty;
    protected Helper helper;
    protected JDefaultPopupMenu popup;
    protected int popupX = 0;
    protected int popupY = 0;
    protected Scheduler scheduler;
    protected MouseEvent mouseEvent;
    protected int mouseButton = -1;
    private NodeList nodeList;

    public BaseJArea(SchedulerProperty theSchedulerProperty, Helper theHelper, Scheduler theScheduler) {
        this.setName("BaseJArea");
        this.scheduler = theScheduler;
        this.schedulerProperty = theSchedulerProperty;
        this.helper = theHelper;
        if (!this.schedulerProperty.print && !this.schedulerProperty.printPreview) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setEditable(false);
        this.setDoubleBuffered(true);
        this.setLayout(null);
        this.setOpaque(false);
        this.setFocusable(Flag.focus);
        this.setRequestFocusEnabled(Flag.reFou);
        this.setKeymap(null);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.schedulerProperty.functionCode = ((JMenuItem)ae.getSource()).getActionCommand();
        this.helper.fireEvent(-2570);
        this.hidePopup();
    }

    public void createKontextMenu(NodeList nodeList) {
        this.helper.logEntering("BaseJArea", "createKontextMenu");
        if (nodeList == null) {
            return;
        }
        this.nodeList = nodeList;
        this.showPopupMenu(false);
        this.helper.logExiting("BaseJArea", "createKontextMenu");
    }

    protected void makePopupMenu() {
        this.helper.logEntering("BaseJArea", "makePopupMenu");
        int x = 0;
        while (x < this.nodeList.getLength()) {
            NodeList nodeList2 = this.nodeList.item(x).getChildNodes();
            String text = this.helper.getNodeValueS(nodeList2, "dc");
            String fCode = this.helper.getNodeValueS(nodeList2, "fc");
            if (text.trim().equals("-")) {
                this.popup.addSeparator();
            } else {
                JMenuItem menuItem = new JMenuItem(text);
                menuItem.setSize(20, 200);
                menuItem.setActionCommand(fCode);
                if (!this.schedulerProperty.print && !this.schedulerProperty.printPreview) {
                    menuItem.addActionListener(this);
                }
                menuItem.setEnabled(true);
                menuItem.setFocusable(true);
                this.popup.add(menuItem);
            }
            ++x;
        }
        this.helper.logExiting("BaseJArea", "makePopupMenu");
    }

    protected void showPopupMenu(boolean old) {
        this.helper.logEntering("BaseJArea", "showPopupMenu");
        if (!old) {
            if (this.popup != null && this.popup.isVisible()) {
                this.hidePopup();
            }
            this.popup = new JDefaultPopupMenu(this.schedulerProperty, this);
            this.makePopupMenu();
        }
        if (this.popup.getComponentCount() == 0) {
            this.popup = null;
            this.schedulerProperty.popupOn = false;
        } else {
            this.popup.show(this, this.popupX, this.popupY);
            this.popup.setVisible(true);
            this.popup.invalidate();
            this.popup.validate();
            this.popup.repaint();
            this.popup.requestFocus();
            this.popup.addFocusListener(this);
            if (this.schedulerProperty.winGUI) {
                this.scheduler.addFocusListener(this);
            }
            this.schedulerProperty.popupOn = true;
        }
        this.helper.logExiting("BaseJArea", "showPopupMenu");
    }

    protected void showPopupMenuAgan() {
        this.helper.logEntering("BaseJArea", "showPopupMenuAgan");
        this.popup.show(this, this.popupX, this.popupY);
        this.schedulerProperty.popupOn = true;
        this.popup.show(this, this.popupX, this.popupY);
        this.helper.logExiting("BaseJArea", "showPopupMenuAgan");
    }

    protected void mouseClickedRight(MouseEvent me) {
        this.popupX = me.getX();
        this.popupY = me.getY();
        if (this.schedulerProperty.newMenu) {
            this.setTargetArea();
            this.schedulerProperty.popupOn = true;
            this.helper.fireEvent(-2601);
        }
    }

    protected void setTargetArea() {
        this.schedulerProperty.functionRaistAt = 1;
    }

    public Helper getHelper() {
        return this.helper;
    }

    public void setHelper(Helper helper) {
        this.helper = helper;
    }

    public JDefaultPopupMenu getPopup() {
        return this.popup;
    }

    public void setPopup(JDefaultPopupMenu popup) {
        this.popup = popup;
    }

    public SchedulerProperty getSchedulerProperty() {
        return this.schedulerProperty;
    }

    public void setSchedulerProperty(SchedulerProperty schedulerProperty) {
        this.schedulerProperty = schedulerProperty;
    }

    protected void showTipWindow(String text) {
        if (text == null || text.equals("")) {
            this.hideTipWindow();
            return;
        }
        if (this.schedulerProperty.popupOn) {
            return;
        }
        int x = this.mouseEvent.getX() + 10;
        this.scheduler.getJLayeredPaneComment().showTipWindow(text, this.getXForTooltip(x), this.getYForTooltip());
        this.scheduler.getJLayeredPaneComment().tipShowing = true;
    }

    protected int getXForTooltip(int x) {
        return x + this.schedulerProperty.firstXOfResource + 4;
    }

    protected int getYForTooltip() {
        if (this.mouseEvent != null) {
            return this.mouseEvent.getY();
        }
        return 1;
    }

    protected void hideTipWindow() {
        this.scheduler.getJLayeredPaneComment().hideTipWindow();
    }

    protected int getYAbsoulut(int y) {
        return y;
    }

    @Override
    public void setToolTipText(String text) {
        this.showTipWindow(text);
    }

    public void hidePopup() {
        this.helper.logEntering("BaseJArea", "hidePopup");
        if (this.popup != null) {
            this.popup.removeFocusListener(this);
            this.scheduler.removeFocusListener(this);
            int i = 0;
            while (i < 10) {
                this.popup.setVisible(false);
                ++i;
            }
            this.helper.logInfo("BaseJArea hidePopup remove Popup from ground Panle");
            this.scheduler.ground.remove(this.popup);
            this.scheduler.ground.repaint();
            this.schedulerProperty.popupOn = false;
            this.popup = null;
        }
        this.helper.logExiting("BaseJArea", "hidePopup");
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.mouseEvent = me;
        this.mouseButton = me.getButton();
        if (!this.schedulerProperty.popupOn) {
            this.hideTipWindow();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.mouseEvent = me;
        this.scheduler.requestFocus();
        this.scheduler.requestFocusInWindow();
        if (!this.schedulerProperty.popupOn) {
            this.hideTipWindow();
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.mouseEvent = me;
        this.mouseButton = me.getButton();
        this.scheduler.requestFocus();
        this.scheduler.requestFocusInWindow();
        if (this.mouseButton == 3) {
            this.scheduler.setMouseRight(true);
        } else {
            this.scheduler.setMouseRight(false);
        }
        this.hideTipWindow();
        this.hidePopup();
        this.helper.removeSelectedComments();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.mouseEvent = me;
        if (!this.schedulerProperty.popupOn) {
            this.hideTipWindow();
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.mouseEvent = me;
        if (!this.schedulerProperty.popupOn) {
            this.hideTipWindow();
        }
        this.scheduler.ground.hideTipWindow();
        this.scheduler.mouseEnteredIfFireEvent();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.mouseEvent = me;
        this.scheduler.ground.hideTipWindow();
        if (!this.schedulerProperty.popupOn) {
            this.hideTipWindow();
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.mouseEvent = me;
        if (this.scheduler.isCtrlPressed() && !me.isControlDown()) {
            this.scheduler.setCtrlPressed(false);
            this.scheduler.prepareFireKeyEvent();
        }
    }

    public void free() {
        this.schedulerProperty = null;
        this.helper = null;
        if (this.popup != null) {
            this.popup.free();
        }
        this.popup = null;
        this.scheduler = null;
        this.mouseEvent = null;
        this.nodeList = null;
        this.removeAll();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.helper.logEntering("BaseJArea", "focusLost");
        if (e.getOppositeComponent() == null || !e.getOppositeComponent().getClass().getName().startsWith("at.tsa.ishmed.") && !e.getOppositeComponent().getClass().getName().startsWith("javax.swing.JRootPane")) {
            this.helper.logInfo("BaseJArea focusLost hidePopup");
            this.hidePopup();
        }
        this.helper.logExiting("BaseJArea", "focusLost");
    }
}

