/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.timePanel.time;

import at.tsa.ishmed.appmntmgmnt.Flag;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JLayeredPane;

public class TimeScaleTime
extends JLayeredPane {
    private static final long serialVersionUID = -1240469123037197866L;
    protected Font hourFont;
    protected Font minFont;
    protected SchedulerProperty schedulerProperty;
    protected Helper helper;
    protected Image i;
    protected BufferedImage bi;

    public TimeScaleTime(SchedulerProperty theSchedulerProperty, Helper theHelper) {
        this.schedulerProperty = theSchedulerProperty;
        this.helper = theHelper;
        this.hourFont = this.helper.getFont(null, 0, true, false, false);
        this.minFont = this.helper.getFont(null, 0, false, false, true);
        if (this.schedulerProperty.colorTimeScaleTime == null) {
            this.schedulerProperty.colorTimeScaleTime = this.helper.getColor("FFFFFF");
        }
        this.setOpaque(false);
        this.setFocusable(Flag.focus);
        this.setRequestFocusEnabled(Flag.reFou);
        this.setDoubleBuffered(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        Font saveFont = g.getFont();
        Color saveColor = g.getColor();
        int width = this.getSize().width;
        int height = this.getSize().height;
        g.setColor(this.schedulerProperty.colorTimeScaleTime);
        g.fillRect(0, 0, width, height);
        g.setColor(this.schedulerProperty.colorFontDefaultNoTimeObject);
        int heightForPainting = 0;
        int beginOfLineOfHour = 0;
        int beginOfLineOfMinute = 20;
        int beginOfHour = 2;
        int beginOfMinutes = 20;
        int distance = 2;
        int minuteInterval = this.helper.getMinuteInterval(this.schedulerProperty.timeIntervalScale);
        String minuteToPrint = "00";
        int minuteToCalculat = this.helper.getMinutesOfCurrentHour(this.schedulerProperty.limitStartTime);
        int minuMinuteInterval = 0;
        boolean first = true;
        minuMinuteInterval = minuteToCalculat / this.schedulerProperty.timeIntervalScale;
        minuteToPrint = Integer.toString(minuMinuteInterval * this.schedulerProperty.timeIntervalScale);
        if (minuteToPrint.equals("0")) {
            minuteToPrint = "00";
        }
        int i = this.helper.getHour(this.schedulerProperty.limitStartTime);
        while (i <= this.helper.getHour(this.schedulerProperty.limitEndTime)) {
            g.setColor(this.schedulerProperty.colorLine);
            g.drawLine(beginOfLineOfHour, heightForPainting, width, heightForPainting);
            g.setColor(this.schedulerProperty.colorFontDefaultNoTimeObject);
            g.setFont(this.hourFont);
            if (minuteToPrint.equals("00")) {
                g.drawString(this.helper.getTimeAsString(i), beginOfHour, heightForPainting + this.schedulerProperty.intervalHeight / 2 + distance);
            }
            g.setFont(this.minFont);
            g.drawString(" " + minuteToPrint, beginOfMinutes, heightForPainting + this.schedulerProperty.intervalHeight / 2 + distance);
            heightForPainting += this.schedulerProperty.intervalHeight;
            minuteInterval = first ? this.helper.getMinuteInterval(this.schedulerProperty.timeIntervalScale) - minuMinuteInterval : this.helper.getMinuteInterval(this.schedulerProperty.timeIntervalScale);
            int j = 0;
            while (j < minuteInterval - 1) {
                minuteToPrint = this.helper.calculateNextMinuteToPrint(minuteToPrint);
                g.setColor(this.schedulerProperty.colorLine);
                int l = beginOfLineOfMinute;
                while (l < width) {
                    g.drawLine(l, heightForPainting, l + distance, heightForPainting);
                    l += distance * 3;
                }
                g.setColor(this.schedulerProperty.colorFontDefaultNoTimeObject);
                g.drawString(" " + minuteToPrint, beginOfMinutes, heightForPainting + this.schedulerProperty.intervalHeight / 2 + distance);
                heightForPainting += this.schedulerProperty.intervalHeight;
                ++j;
            }
            first = false;
            minuteToPrint = "00";
            ++i;
        }
        g.setColor(this.schedulerProperty.colorLine);
        g.drawLine(this.schedulerProperty.firstXOfResource - 1, 0, this.schedulerProperty.firstXOfResource - 1, height);
        g.setColor(this.schedulerProperty.colorFontDefaultNoTimeObject);
        if (this.schedulerProperty.timeLines != null) {
            Rectangle recTimeLine = this.helper.getRecPoint(this.schedulerProperty.timeLines.getTimeInt(), this.schedulerProperty.timeLines.getTimeInt());
            g.setColor(this.schedulerProperty.timeLines.getLineColor());
            g.drawString(this.helper.getTimeForInfo(this.schedulerProperty.timeLines.getTimeString()), beginOfHour, recTimeLine.y - 5);
            g.fillRect(beginOfHour, recTimeLine.y, this.schedulerProperty.firstXOfResource - 2, this.schedulerProperty.timeLines.getThickness());
        }
        g.setFont(saveFont);
        g.setColor(saveColor);
    }

    public void paintVertical(Graphics g) {
        Font saveFont = g.getFont();
        Color saveColor = g.getColor();
        int width = this.getSize().width;
        int height = this.getSize().height;
        g.setColor(this.schedulerProperty.colorTimeScaleTime);
        g.fillRect(0, 0, width, height);
        g.setColor(saveColor);
        int heightForPainting = 0;
        int beginOfLineOfHour = 0;
        int beginOfLineOfMinute = 20;
        int beginOfHour = 2;
        int beginOfMinutes = 20;
        int distance = 2;
        int minuteInterval = this.helper.getMinuteInterval(this.schedulerProperty.timeIntervalScale);
        String minuteToPrint = "00";
        int minuteToCalculat = this.helper.getMinutesOfCurrentHour(this.schedulerProperty.limitStartTime);
        int minuMinuteInterval = 0;
        boolean first = true;
        minuMinuteInterval = minuteToCalculat / this.schedulerProperty.timeIntervalScale;
        minuteToPrint = Integer.toString(minuMinuteInterval * this.schedulerProperty.timeIntervalScale);
        if (minuteToPrint.equals("0")) {
            minuteToPrint = "00";
        }
        int i = this.helper.getHour(this.schedulerProperty.limitStartTime);
        while (i <= this.helper.getHour(this.schedulerProperty.limitEndTime)) {
            g.setColor(this.schedulerProperty.colorLine);
            g.drawLine(beginOfLineOfHour, heightForPainting, width, heightForPainting);
            g.setColor(saveColor);
            g.setFont(this.hourFont);
            if (minuteToPrint.equals("00")) {
                g.drawString(this.helper.getTimeAsString(i), beginOfHour, heightForPainting + this.schedulerProperty.intervalHeight / 2 + distance);
            }
            g.setFont(this.minFont);
            g.drawString(" " + minuteToPrint, beginOfMinutes, heightForPainting + this.schedulerProperty.intervalHeight / 2 + distance);
            heightForPainting += this.schedulerProperty.intervalHeight;
            minuteInterval = first ? this.helper.getMinuteInterval(this.schedulerProperty.timeIntervalScale) - minuMinuteInterval : this.helper.getMinuteInterval(this.schedulerProperty.timeIntervalScale);
            int j = 0;
            while (j < minuteInterval - 1) {
                minuteToPrint = this.helper.calculateNextMinuteToPrint(minuteToPrint);
                g.setColor(this.schedulerProperty.colorLine);
                int l = beginOfLineOfMinute;
                while (l < width) {
                    g.drawLine(l, heightForPainting, l + distance, heightForPainting);
                    l += distance * 3;
                }
                g.setColor(saveColor);
                g.drawString(" " + minuteToPrint, beginOfMinutes, heightForPainting + this.schedulerProperty.intervalHeight / 2 + distance);
                heightForPainting += this.schedulerProperty.intervalHeight;
                ++j;
            }
            first = false;
            minuteToPrint = "00";
            ++i;
        }
        g.setFont(saveFont);
    }

    public void paintHorizontal(Graphics g) {
        Font saveFont = g.getFont();
        Color saveColor = g.getColor();
        int width = this.getSize().width;
        int height = this.getSize().height;
        g.setColor(this.schedulerProperty.colorTimeScaleTime);
        g.fillRect(0, 0, width, height);
        g.setColor(saveColor);
        int heightForPainting = 0;
        int beginOfLineOfHour = 0;
        int beginOfLineOfMinute = 20;
        int beginOfHour = 2;
        int beginOfMinutes = 20;
        int distance = 2;
        int minuteInterval = this.helper.getMinuteInterval(this.schedulerProperty.timeIntervalScale);
        String minuteToPrint = "00";
        int minuteToCalculat = this.helper.getMinutesOfCurrentHour(this.schedulerProperty.limitStartTime);
        int minuMinuteInterval = 0;
        boolean first = true;
        minuMinuteInterval = minuteToCalculat / this.schedulerProperty.timeIntervalScale;
        minuteToPrint = Integer.toString(minuMinuteInterval * this.schedulerProperty.timeIntervalScale);
        if (minuteToPrint.equals("0")) {
            minuteToPrint = "00";
        }
        int i = this.helper.getHour(this.schedulerProperty.limitStartTime);
        while (i <= this.helper.getHour(this.schedulerProperty.limitEndTime)) {
            g.setColor(this.schedulerProperty.colorLine);
            g.drawLine(beginOfLineOfHour, heightForPainting, width, heightForPainting);
            g.setColor(saveColor);
            g.setFont(this.hourFont);
            if (minuteToPrint.equals("00")) {
                g.drawString(this.helper.getTimeAsString(i), beginOfHour, heightForPainting + this.schedulerProperty.intervalHeight / 2 + distance);
            }
            g.setFont(this.minFont);
            g.drawString(" " + minuteToPrint, beginOfMinutes, heightForPainting + this.schedulerProperty.intervalHeight / 2 + distance);
            heightForPainting += this.schedulerProperty.intervalHeight;
            minuteInterval = first ? this.helper.getMinuteInterval(this.schedulerProperty.timeIntervalScale) - minuMinuteInterval : this.helper.getMinuteInterval(this.schedulerProperty.timeIntervalScale);
            int j = 0;
            while (j < minuteInterval - 1) {
                minuteToPrint = this.helper.calculateNextMinuteToPrint(minuteToPrint);
                g.setColor(this.schedulerProperty.colorLine);
                int l = beginOfLineOfMinute;
                while (l < width) {
                    g.drawLine(l, heightForPainting, l + distance, heightForPainting);
                    l += distance * 3;
                }
                g.setColor(saveColor);
                g.drawString(" " + minuteToPrint, beginOfMinutes, heightForPainting + this.schedulerProperty.intervalHeight / 2 + distance);
                heightForPainting += this.schedulerProperty.intervalHeight;
                ++j;
            }
            first = false;
            minuteToPrint = "00";
            ++i;
        }
        g.setFont(saveFont);
    }

    public void free() {
        this.hourFont = null;
        this.minFont = null;
        this.schedulerProperty = null;
        this.helper = null;
        this.i = null;
        this.bi = null;
    }
}

