/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject;

import at.tsa.ishmed.appmntmgmnt.Flag;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import java.awt.Color;
import javax.swing.JLabel;

public class TimeObject
extends JLabel {
    private static final long serialVersionUID = -6264813265051389442L;
    protected String colID;
    protected String resID;
    protected String key;
    protected String timeFrom;
    protected String timeTo;
    protected int timeFromInt;
    protected int timeToInt;
    protected int timeScale;
    protected int timeFromPix;
    protected int timeToPix;
    protected int minTimeFromInt;
    protected int minTimeToInt;
    private String backGroundColorString;
    private Color backGround;
    protected Helper helper;
    private int duration;
    protected String menuID;
    protected String menuID2 = null;
    protected String menuID3 = null;

    public TimeObject(String theColID, String theResID, String theKey, String theTimeFrom, int theDuration, String theBackGroundColor, Helper theHelper) throws Exception {
        this(theColID, theResID, theKey, theTimeFrom, theDuration, theBackGroundColor, theHelper.getColor(theBackGroundColor), theHelper);
    }

    public TimeObject(String theColID, String theResID, String theKey, String theTimeFrom, String theTimeTo, String theBackGroundColor, Helper theHelper) throws Exception {
        this.colID = theColID;
        this.resID = theResID;
        this.key = theKey.trim();
        this.helper = theHelper;
        this.timeFrom = theTimeFrom.length() > 0 ? theTimeFrom.substring(0, 4) : "0";
        this.timeTo = theTimeTo.length() > 0 ? theTimeTo.substring(0, 4) : "0";
        this.timeFromInt = this.helper.getIntValue(this.timeFrom);
        this.timeToInt = this.helper.getIntValue(this.timeTo);
        if (this.timeFromInt > this.timeToInt) {
            throw new Exception("Beginnzeit " + this.timeFrom + " gr\ufffd\ufffder als Endzeit " + this.timeTo + " mit Key " + theKey + ", ColumnID: " + this.colID + ", ResourceID: " + this.resID);
        }
        this.setDuration(this.timeToInt - this.timeFromInt);
        this.minTimeFromInt = this.helper.getMinutesOfTime(this.timeFrom);
        this.minTimeToInt = this.helper.getMinutesOfTime(this.timeTo);
        this.backGroundColorString = theBackGroundColor;
        this.backGround = theHelper.getColor(this.backGroundColorString);
        this.initComponent();
    }

    public TimeObject(String theColID, String theResID, String theKey, String theTimeFrom, int theDuration, String theBackGroundColor, Color backGroundColor, Helper theHelper) throws Exception {
        this.colID = theColID;
        this.resID = theResID;
        this.key = theKey.trim();
        this.helper = theHelper;
        this.timeFrom = theTimeFrom.length() > 0 ? theTimeFrom.substring(0, 4) : "0";
        this.timeFromInt = this.helper.getIntValue(this.timeFrom);
        this.minTimeFromInt = this.getMinutesOfTime(this.timeFrom);
        this.minTimeToInt = this.minTimeFromInt + theDuration;
        if (this.minTimeToInt > 1440) {
            this.minTimeToInt = 1440;
        }
        this.timeTo = this.helper.getTimeOfMinutes(this.minTimeToInt);
        this.setDuration(theDuration);
        this.timeToInt = this.helper.getIntValue(this.timeTo);
        this.backGroundColorString = theBackGroundColor;
        this.backGround = backGroundColor;
        this.initComponent();
    }

    @Override
    public String toString() {
        return "\nTimeObject\ncolID: " + this.colID + "\nresID: " + this.resID + "\nkey: " + this.key + "\ntimeFrom: " + this.timeFrom + "\ntimeTo: " + this.timeTo + "\nduration: " + this.duration + "\nbackGroundColor: " + this.backGroundColorString;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public String getBackGroundColorString() {
        return this.backGroundColorString;
    }

    public void setBackGroundColorString(String backGroundColorString) {
        this.backGroundColorString = backGroundColorString;
        this.setBackGround(this.helper.getColor(backGroundColorString));
    }

    public String getColID() {
        return this.colID;
    }

    public void setColID(String colID) {
        this.colID = colID;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getResID() {
        return this.resID;
    }

    public void setResID(String resID) {
        this.resID = resID;
    }

    public String getTimeFrom() {
        return this.timeFrom;
    }

    public void setTimeFrom(String timeFrom) {
        this.timeFrom = timeFrom;
        this.minTimeFromInt = this.helper.getMinutesOfTime(timeFrom);
    }

    public int getTimeFromInt() {
        return this.timeFromInt;
    }

    public void setTimeFromInt(int timeFromInt) {
        this.timeFromInt = timeFromInt;
    }

    public int getTimeFromPix() {
        return this.timeFromPix;
    }

    public void setTimeFromPix(int timeFromPix) {
        this.timeFromPix = timeFromPix;
    }

    public int getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(int timeScale) {
        this.timeScale = timeScale;
    }

    public String getTimeTo() {
        return this.timeTo;
    }

    public void setTimeTo(String timeTo) {
        this.timeTo = timeTo;
        this.minTimeToInt = this.helper.getMinutesOfTime(timeTo);
    }

    public int getTimeToInt() {
        return this.timeToInt;
    }

    public void setTimeToInt(int timeToInt) {
        this.timeToInt = timeToInt;
    }

    public int getTimeToPix() {
        return this.timeToPix;
    }

    public void setTimeToPix(int timeToPix) {
        this.timeToPix = timeToPix;
    }

    public Color getBackGround() {
        return this.backGround;
    }

    public void setBackGround(Color backGround) {
        this.backGround = backGround;
    }

    public Helper getHelper() {
        return this.helper;
    }

    public void setHelper(Helper helper) {
        this.helper = helper;
    }

    private void initComponent() {
        this.setBackground(this.backGround);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.setFocusable(Flag.focus);
        this.setRequestFocusEnabled(Flag.reFou);
    }

    private int getMinutesOfTime(String theTime) {
        String hours = "0";
        String minutes = "0";
        if (theTime.length() >= 4) {
            hours = theTime.substring(0, 2);
            minutes = theTime.substring(2, 4);
        }
        return this.helper.getIntValue(hours) * 60 + this.helper.getIntValue(minutes);
    }

    public String getMenuID() {
        return this.menuID;
    }

    public void setMenuID(String menuID) {
        this.menuID = menuID;
    }

    public String getMenuID2() {
        return this.menuID2;
    }

    public void setMenuID2(String menuID2) {
        this.menuID2 = menuID2;
    }

    public String getMenuID3() {
        return this.menuID3;
    }

    public void setMenuID3(String menuID3) {
        this.menuID3 = menuID3;
    }

    public void free() {
        this.colID = null;
        this.resID = null;
        this.key = null;
        this.timeFrom = null;
        this.timeTo = null;
        this.backGroundColorString = null;
        this.backGround = null;
        this.helper = null;
        this.menuID = null;
        this.menuID2 = null;
        this.menuID3 = null;
    }

    public int getMinTimeFromInt() {
        return this.minTimeFromInt;
    }

    public int getMinTimeToInt() {
        return this.minTimeToInt;
    }
}

