/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.gui.header.column;

import at.tsa.ishmed.appmntmgmnt.Flag;
import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.header.column.TitleOfResource;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.resource.Resource;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.resource.time.TimeResource;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.SelArea;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.DefaultLabel;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.DefaultPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class Column
extends JPanel {
    private static final long serialVersionUID = -4427314781373196418L;
    protected ArrayList<Resource> resources;
    protected ArrayList<TitleOfResource> resourcesTitles;
    private float widthOfResource;
    private float countOfResources;
    private SchedulerProperty schedulerProperty;
    protected Font titleFont;
    protected Scheduler scheduler;
    protected String colID;
    protected String description;
    protected Font font;
    protected Color fontColor;
    protected String fontName;
    protected int fontSize;
    protected String fontBold;
    protected String fontItalic;
    protected String fontColorString;
    protected Helper helper;
    protected DefaultLabel titel;
    protected DefaultPanel jResourcesPanel;

    public Column(String theColID, String theDescription, String theFontName, int theFontSize, String theFontBold, String theFontItalic, String theFontColor, Scheduler theScheduler, SchedulerProperty theSchedulerProperty, Helper theHelper) {
        this.colID = theColID;
        this.description = theDescription;
        this.fontName = theFontName;
        this.fontSize = theFontSize;
        this.fontBold = theFontBold;
        this.fontItalic = theFontItalic;
        this.fontColorString = theFontColor;
        this.schedulerProperty = theSchedulerProperty;
        this.scheduler = theScheduler;
        this.helper = theHelper;
        this.font = this.helper.getFont(this.fontName, this.fontSize, this.helper.getBooleanValue(this.fontBold), this.helper.getBooleanValue(this.fontItalic), true);
        this.fontColor = this.helper.getFontColor(this.fontColorString, false);
        this.initComponents();
    }

    private void initComponents() {
        this.resourcesTitles = new ArrayList();
        this.resources = new ArrayList();
        this.jResourcesPanel = new DefaultPanel();
        this.titel = new DefaultLabel(this.scheduler);
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.schedulerProperty.colorLine));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        this.setMinimumSize(new Dimension(0, 40));
        this.setPreferredSize(new Dimension(20, 40));
        this.jResourcesPanel.setLayout(null);
        this.jResourcesPanel.setOpaque(false);
        this.jResourcesPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.jResourcesPanel.setMinimumSize(new Dimension(0, 20));
        this.jResourcesPanel.setPreferredSize(new Dimension(20, 20));
        this.add((Component)this.jResourcesPanel, "Center");
        this.titel.setHorizontalAlignment(0);
        this.titel.setMaximumSize(new Dimension(45555, 20));
        this.titel.setMinimumSize(new Dimension(0, 20));
        this.titel.setPreferredSize(new Dimension(20, 20));
        if (!this.schedulerProperty.print) {
            this.titel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    Column.this.mouseClickedColTitle(evt);
                }
            });
        }
        this.add((Component)this.titel, "North");
        this.titel.setOpaque(false);
        this.titel.setDoubleBuffered(true);
        this.setOpaque(false);
        this.setFocusable(Flag.focus);
        this.setRequestFocusEnabled(Flag.reFou);
        this.setDoubleBuffered(true);
        this.jResourcesPanel.setDoubleBuffered(true);
        this.titel.setDoubleBuffered(true);
        this.titel.setFont(this.font);
        this.titel.setForeground(this.fontColor);
        this.titel.setText(this.description);
    }

    public String getColID() {
        return this.colID;
    }

    public void setColID(String colID) {
        this.colID = colID;
    }

    public void setResources(ArrayList<Resource> theResources) {
        if (this.resourcesTitles != null) {
            int size = this.resourcesTitles.size();
            if (size > 0) {
                int i = 0;
                while (i < size) {
                    this.setVisible(false);
                    this.remove(this.resourcesTitles.get(i));
                    this.setVisible(true);
                    ++i;
                }
                this.resourcesTitles.clear();
            }
        } else {
            this.resourcesTitles = new ArrayList();
        }
        this.resources = theResources;
        this.countOfResources = 0.0f;
        this.jResourcesPanel.setVisible(false);
        this.jResourcesPanel.removeAll();
        this.jResourcesPanel.setVisible(true);
        if (this.resources != null) {
            this.countOfResources = this.resources.size();
            int width = this.getWidth();
            float restOfRes = this.countOfResources;
            Resource resource = null;
            TitleOfResource titleOfResource = null;
            int x = 0;
            boolean first = true;
            int i = 0;
            while ((float)i < this.countOfResources) {
                resource = this.resources.get(i);
                this.widthOfResource = restOfRes > 0.0f ? (float)width / restOfRes : (float)width;
                titleOfResource = new TitleOfResource(resource, this.scheduler, (int)this.widthOfResource, this);
                this.jResourcesPanel.add(titleOfResource);
                titleOfResource.setBounds(x, 0, (int)this.widthOfResource, 20);
                this.resourcesTitles.add(titleOfResource);
                x = (int)((float)x + this.widthOfResource);
                if (first) {
                    titleOfResource.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, this.schedulerProperty.colorLine));
                    first = false;
                }
                width -= (int)this.widthOfResource;
                restOfRes -= 1.0f;
                ++i;
            }
        }
    }

    public void removeRes() {
        this.setVisible(false);
        this.removeAll();
        this.setVisible(true);
        if (this.resourcesTitles != null) {
            this.resourcesTitles.clear();
        } else {
            this.resourcesTitles = new ArrayList();
        }
        this.resources = new ArrayList();
        this.jResourcesPanel.setVisible(false);
        this.jResourcesPanel.removeAll();
        this.jResourcesPanel.setVisible(true);
        this.add((Component)this.jResourcesPanel, "Center");
        this.add((Component)this.titel, "North");
    }

    public void setResource(TimeResource timeResource, int width, int x, boolean first) {
        if (this.resourcesTitles == null) {
            this.resourcesTitles = new ArrayList();
        }
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        this.resources.add(timeResource);
        this.countOfResources = 0.0f;
        TitleOfResource titleOfResource = null;
        titleOfResource = new TitleOfResource(timeResource, this.scheduler, width, this);
        this.jResourcesPanel.add(titleOfResource);
        titleOfResource.setBounds(x, 0, width, 20);
        titleOfResource.absolutX = x;
        this.resourcesTitles.add(titleOfResource);
    }

    public Rectangle getBoundOfResTitel(String resID) {
        for (TitleOfResource tor : this.resourcesTitles) {
            if (!resID.equals(tor.resource.getResID())) continue;
            return tor.getBounds();
        }
        return null;
    }

    private void mouseClickedColTitle(MouseEvent me) {
        int button = me.getButton();
        if (button == 1 && me.getClickCount() == 2) {
            if (!this.schedulerProperty.zoomMode) {
                this.scheduler.getColCon().setColInZoomMode(this.getColID());
                this.scheduler.getResCon().setResInZoomMode(this.getColID());
                if (this.scheduler.getSchedulerProperty().showDayBasedApp) {
                    this.scheduler.getResDayCon().setResInZoomMode(this.getColID());
                }
                this.schedulerProperty.saveColID = this.getColID();
                this.schedulerProperty.saveResID = null;
                this.schedulerProperty.zoomMode = true;
                this.schedulerProperty.zoomCollMode = true;
                if (this.isAreaToClear(this.getColID())) {
                    this.clearAreas();
                }
                this.helper.unselectIfNecessary(this.getColID());
                this.scheduler.update();
                return;
            }
            this.helper.closeZoomMode(true);
        }
    }

    @Override
    public String toString() {
        return "\ncolID: " + this.colID + "\ndescription: " + this.description + "\nX: " + this.getX() + "\nY: " + this.getY() + "\nheigth: " + this.getHeight() + "\nwidth: " + this.getWidth();
    }

    public Color getBackColorOfTitel() {
        if (this.resourcesTitles != null && !this.resourcesTitles.isEmpty()) {
            return this.resourcesTitles.get(0).getBackground();
        }
        return null;
    }

    protected void clearAreas() {
        if (this.scheduler.getSchedulerTimePanel() != null) {
            this.scheduler.getSchedulerTimePanel().removeTimeAreas();
        }
        if (this.scheduler.getSchedulerDayPanel() != null) {
            this.scheduler.getSchedulerDayPanel().removeDayAreas();
        }
        this.schedulerProperty.focusedAreas = null;
        this.schedulerProperty.startAreas = null;
    }

    protected boolean isAreaToClear(String colId, String resId) {
        boolean clear = false;
        if (this.schedulerProperty.focusedAreas == null) {
            return false;
        }
        Iterator<ArrayList<SelArea>> it = this.schedulerProperty.focusedAreas.values().iterator();
        while (it.hasNext() && !clear) {
            ArrayList<SelArea> v = it.next();
            for (SelArea sa : v) {
                if (sa.getResID().equalsIgnoreCase(resId)) continue;
                clear = true;
                return clear;
            }
        }
        return clear;
    }

    protected boolean isAreaToClear(String colId) {
        boolean clear = true;
        if (this.schedulerProperty.focusedAreas == null) {
            return false;
        }
        Iterator<ArrayList<SelArea>> it = this.schedulerProperty.focusedAreas.values().iterator();
        while (it.hasNext() && clear) {
            ArrayList<SelArea> v = it.next();
            for (SelArea sa : v) {
                Iterator<Resource> rIt = this.resources.iterator();
                clear = true;
                while (rIt.hasNext()) {
                    Resource res = rIt.next();
                    if (!res.getResID().equalsIgnoreCase(sa.getResID())) continue;
                    clear = false;
                    break;
                }
                if (!clear) continue;
                return clear;
            }
        }
        return clear;
    }

    public void setApsolutX(int x) {
        this.titel.setApsolutX(x);
        this.titel.setAbsolutY(60);
        if (this.resourcesTitles == null) {
            return;
        }
        for (TitleOfResource tOR : this.resourcesTitles) {
            tOR.setAbsolutY(80);
            tOR.setApsolutX(x + tOR.getX());
        }
    }

    public void setWidth(int theWidth) {
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public String getFontBold() {
        return this.fontBold;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public String getFontColorString() {
        return this.fontColorString;
    }

    public String getFontItalic() {
        return this.fontItalic;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public Helper getHelper() {
        return this.helper;
    }

    public JPanel getJResourcesPanel() {
        return this.jResourcesPanel;
    }

    public ArrayList<Resource> getResources() {
        return this.resources;
    }

    public ArrayList<TitleOfResource> getResourcesTitles() {
        return this.resourcesTitles;
    }

    public DefaultLabel getTitel() {
        return this.titel;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void free() {
        this.resources = null;
        if (this.resourcesTitles != null) {
            for (TitleOfResource tof : this.resourcesTitles) {
                if (tof == null) continue;
                tof.free();
            }
        }
        this.resourcesTitles = null;
        this.schedulerProperty = null;
        this.titleFont = null;
        this.scheduler = null;
        this.colID = null;
        this.description = null;
        this.font = null;
        this.fontColor = null;
        this.fontName = null;
        this.fontBold = null;
        this.fontItalic = null;
        this.fontColorString = null;
        this.helper = null;
        if (this.titel != null) {
            this.titel.free();
        }
        this.titel = null;
        this.jResourcesPanel = null;
    }
}

