/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.gui.comment;

import at.tsa.ishmed.appmntmgmnt.Flag;
import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.comment.Comment;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.BaseJArea;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.JDefaultPopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;

public class CommentResource
extends BaseJArea
implements ActionListener {
    private static final long serialVersionUID = 3875542710061817313L;
    private String resID;
    private int minHeight = 0;
    private String menuID;

    public CommentResource(String theResID, String theMenuID, SchedulerProperty theSchedulerProperty, Scheduler theScheduler) {
        super(theSchedulerProperty, theScheduler.getHelper(), theScheduler);
        this.setResID(theResID);
        this.menuID = theMenuID;
        this.setDoubleBuffered(true);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.schedulerProperty.colorLine));
        this.setFocusable(Flag.focus);
        this.setRequestFocusEnabled(Flag.reFou);
        this.setDoubleBuffered(true);
    }

    public void setComment(Comment theComment) {
        if (theComment == null) {
            return;
        }
        this.setVisible(false);
        this.setLayout(null);
        this.removeAll();
        this.setVisible(true);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)theComment, "Center");
        this.menuID = theComment.menuID;
        theComment.setCommentBorder(this);
    }

    public void setComments(ArrayList<Comment> theArrayListComment) {
        if (theArrayListComment == null || theArrayListComment.isEmpty()) {
            return;
        }
        this.setVisible(false);
        this.setLayout(null);
        this.removeAll();
        this.setVisible(true);
        Iterator<Comment> it = theArrayListComment.iterator();
        int iWidth = this.getWidth();
        this.minHeight = 0;
        while (it.hasNext()) {
            Comment comment = it.next();
            this.add(comment);
            comment.setCommentBorder(this);
            comment.setBounds(0, this.minHeight, iWidth - 1, comment.getComHeight());
            this.minHeight = this.minHeight + comment.getComHeight() - 1;
        }
    }

    public String getResID() {
        return this.resID;
    }

    public void setResID(String resID) {
        this.resID = resID;
    }

    @Override
    public SchedulerProperty getSchedulerProperty() {
        return this.schedulerProperty;
    }

    @Override
    public void setSchedulerProperty(SchedulerProperty schedulerProperty) {
        this.schedulerProperty = schedulerProperty;
    }

    @Override
    public void free() {
        this.resID = null;
        this.schedulerProperty = null;
        this.scheduler = null;
    }

    @Override
    protected void setTargetArea() {
        this.schedulerProperty.functionRaistAt = 3;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.schedulerProperty.popupOn = false;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        int button = me.getButton();
        int clickCount = me.getClickCount();
        this.setTargetArea();
        this.removeSelection();
        if (button == 1) {
            if (clickCount > 1) {
                this.schedulerProperty.selectedResIDForComment = this.resID;
                this.scheduler.getHelper().fireEvent(-2550);
                this.getParent().repaint();
            }
        } else if (button == 3) {
            this.schedulerProperty.selectedResIDForComment = this.resID;
            if (this.schedulerProperty.newMenu) {
                this.mouseClickedRight(me);
            } else {
                this.popupX = me.getX();
                this.popupY = me.getY();
                this.makePopupMenuOld();
            }
        }
    }

    protected void makePopupMenuOld() {
        if (this.schedulerProperty.menus == null || this.schedulerProperty.menus.isEmpty() || this.menuID == null || this.menuID.equalsIgnoreCase("")) {
            return;
        }
        this.popup = new JDefaultPopupMenu(this.schedulerProperty, this);
        if (this.helper.addMenuItem(this, this.popup, this.menuID, false)) {
            this.showPopupMenu(true);
        }
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    protected void removeSelection() {
        this.helper.removeAreas();
        this.helper.removeSelectedApps();
        this.helper.removeSelectedComments();
    }
}

