/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.gui.comment;

import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.comment.Comment;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.comment.CommentResource;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.w3c.dom.NodeList;

public class CommentController {
    private TreeMap<String, ArrayList<Comment>> tm;
    private TreeMap<String, CommentResource> tmr;
    private SchedulerProperty schedulerProperty;
    private Scheduler scheduler;
    private Helper helper;
    protected boolean newComment = false;
    protected String menuID = null;

    public CommentController(Scheduler theScheduler) {
        this.schedulerProperty = theScheduler.getSchedulerProperty();
        this.helper = theScheduler.getHelper();
        this.scheduler = theScheduler;
        this.tm = null;
        this.tmr = null;
        this.tm = new TreeMap();
        this.tmr = new TreeMap();
    }

    public CommentController(NodeList nodeList, SchedulerProperty schedulerProperty, Helper helper, Scheduler scheduler) {
        this.tm = null;
        this.schedulerProperty = schedulerProperty;
        this.helper = helper;
        helper.logEntering("CommentController", "Constuktor");
        this.tm = new TreeMap();
        this.scheduler = scheduler;
        NodeList nodeListeHeader = helper.getNodeList(nodeList, "head");
        if (nodeListeHeader != null) {
            this.newComment = true;
            int height = helper.getNodeValueI(nodeListeHeader, "h");
            height = height > 0 ? (height /= schedulerProperty.twipsPerPixel) : 15;
            this.menuID = helper.getNodeValueS(nodeListeHeader, "mi");
            NodeList nodeListeComments = helper.getNodeList(nodeList, "comments");
            try {
                int i = 0;
                while (i < nodeListeComments.getLength()) {
                    NodeList nodeList2 = nodeListeComments.item(i).getChildNodes();
                    this.addComments(helper.getNodeValueS(nodeList2, "ci"), helper.getNodeValueS(nodeList2, "ri"), helper.getNodeValueS(nodeList2, "dc"), helper.getNodeValueS(nodeList2, "tt"), helper.getNodeValueS(nodeList2, "mi"), height, helper.getNodeValueS(nodeList2, "bg"), helper.getNodeValueS(nodeList2, "fn"), helper.getNodeValueI(nodeList2, "fs"), helper.getNodeValueS(nodeList2, "fb"), helper.getNodeValueS(nodeList2, "fi"), helper.getNodeValueS(nodeList2, "fc"), helper.getNodeValueB(nodeList2, "TTD"), helper.getNodeValueB(nodeList2, "lt"));
                    ++i;
                }
            }
            catch (Exception ex) {
                helper.logThrowing("CommentController", "Constructor", ex);
                ex.printStackTrace(System.err);
                System.err.println(ex);
            }
        } else {
            this.newComment = false;
            try {
                int i = 0;
                while (i < nodeList.getLength()) {
                    NodeList nodeList2 = nodeList.item(i).getChildNodes();
                    this.addComments(helper.getNodeValueS(nodeList2, "ri"), helper.getNodeValueS(nodeList2, "dc"), helper.getNodeValueS(nodeList2, "bg"), helper.getNodeValueS(nodeList2, "fn"), helper.getNodeValueI(nodeList2, "fs"), helper.getNodeValueS(nodeList2, "fb"), helper.getNodeValueS(nodeList2, "fi"), helper.getNodeValueS(nodeList2, "fc"), helper.getNodeValueS(nodeList2, "mi"));
                    ++i;
                }
            }
            catch (Exception ex) {
                helper.logThrowing("CommentController", "Constructor", ex);
                ex.printStackTrace(System.err);
                System.err.println(ex);
            }
        }
        helper.logExiting("CommentController", "Constuktor");
    }

    public void put(String resID, Comment com) {
        StringBuffer sb = new StringBuffer();
        sb.append(resID);
        ArrayList<Comment> comList = this.tm.get(resID);
        if (comList != null) {
            if (comList.contains(com)) {
                comList.remove(com);
                comList.add(com);
            } else {
                comList.add(com);
            }
        } else {
            comList = new ArrayList();
            comList.add(com);
            this.tm.put(resID, comList);
        }
    }

    public TreeMap<String, ArrayList<Comment>> getAllComment() {
        return this.tm;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer(26);
        stringbuffer.append("output for class:\t");
        stringbuffer.append(this.getClass().getName());
        stringbuffer.append("TreeMap");
        stringbuffer.append(this.tm);
        return new String(stringbuffer);
    }

    public void removeAllComment() {
        this.tm = null;
        this.tm = new TreeMap();
    }

    public void addComment(String theCommentID, String theResID, String theDescription, String theTooltip, String theMenuID, int theHeight, String theBackGroundColor, String theFontName, int theFontSize, String theFontBold, String theFontItalic, String theFontColor, boolean theNoToolTip, boolean theHasLongText) {
        this.addComments(theCommentID, theResID, theDescription, theTooltip, theMenuID, theHeight, theBackGroundColor, theFontName, theFontSize, theFontBold, theFontItalic, theFontColor, theNoToolTip, theHasLongText);
    }

    private void addComments(String theCommentID, String theResID, String theDescription, String theTooltip, String theMenuID, int theHeight, String theBackGroundColor, String theFontName, int theFontSize, String theFontBold, String theFontItalic, String theFontColor, boolean theNoToolTip, boolean theHasLongText) {
        this.put(theResID, new Comment(theCommentID, theResID, theDescription, theTooltip, theMenuID, theBackGroundColor, theHeight, theFontName, theFontSize, theFontBold, theFontItalic, theFontColor, theNoToolTip, theHasLongText, this.schedulerProperty, this.scheduler, this.helper));
    }

    private void addComments(String theResID, String theDescription, String theBackGroundColor, String theFontName, int theFontSize, String theFontBold, String theFontItalic, String theFontColor, String theMenuID) {
        this.put(theResID, new Comment(theResID, theDescription, theBackGroundColor, theFontName, theFontSize, theFontBold, theFontItalic, theFontColor, theMenuID, this.schedulerProperty, this.scheduler, this.helper));
    }

    public int getSizeComment() {
        if (this.tm != null) {
            return this.tm.size();
        }
        return 0;
    }

    public boolean isCommentEmpty() {
        if (this.tm != null) {
            return this.tm.isEmpty();
        }
        return false;
    }

    public ArrayList<Comment> getCommentArray(String resID) {
        if (this.tm != null) {
            return this.tm.get(resID);
        }
        return null;
    }

    public Comment getComment(String resID, String commentID) {
        ArrayList<Comment> al = this.getCommentArray(resID);
        for (Comment comm : al) {
            if (!commentID.equalsIgnoreCase(comm.getCommentID())) continue;
            return comm;
        }
        return null;
    }

    public Comment getComment(String commentID) {
        if (commentID == null || commentID.equalsIgnoreCase("")) {
            return null;
        }
        for (ArrayList<Comment> al : this.tm.values()) {
            if (al == null) continue;
            for (Comment com : al) {
                if (!commentID.equalsIgnoreCase(com.commentID)) continue;
                return com;
            }
        }
        return null;
    }

    public CommentResource getCommentResource(String resID) {
        if (this.tmr != null) {
            return this.tmr.get(resID);
        }
        return null;
    }

    public CommentResource addCommentResource(String resID) {
        CommentResource cr = null;
        if (this.tmr == null) {
            this.tmr = new TreeMap();
        } else {
            cr = this.tmr.get(resID);
        }
        if (cr == null) {
            cr = new CommentResource(resID, this.menuID, this.schedulerProperty, this.scheduler);
            this.tmr.put(resID, cr);
        }
        return cr;
    }

    public void clearCommentResources() {
        this.tmr = null;
        this.tmr = new TreeMap();
    }

    public Iterator<CommentResource> getAllCommentResIterator() {
        if (this.tmr != null) {
            return this.tmr.values().iterator();
        }
        return null;
    }

    public boolean isCommentResourceEmpty() {
        if (this.tmr != null) {
            return this.tmr.isEmpty();
        }
        return true;
    }

    public void free() {
        this.tm = null;
        this.tmr = null;
        this.schedulerProperty = null;
        this.scheduler = null;
        this.helper = null;
    }

    public boolean isNewComment() {
        return this.newComment;
    }
}

