/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.gui.comment;

import at.tsa.ishmed.appmntmgmnt.Flag;
import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.comment.CommentResource;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.base.SelectedCommentController;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.BaseJArea;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.CommentScrollPane;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.DefaultLabel;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.DefaultPanel;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.JDefaultPopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;

public class Comment
extends BaseJArea {
    private static final long serialVersionUID = 470019979087061074L;
    protected String commentID;
    protected String resID;
    protected String description;
    protected String toolTip;
    protected String toolTipFontName = null;
    private String backGroundColorString;
    private String fontName;
    private int fontSize;
    private String fontBold;
    private String fontItalic;
    private String fontColor;
    private CommentResource commentBorder;
    protected String menuID;
    protected int cWidth;
    protected DefaultLabel label;
    protected int comHeight;
    protected boolean newComment;
    protected boolean selected = false;
    protected boolean noTooltip = false;
    protected boolean hasLongText = false;
    protected CommentScrollPane commentScrollPane;
    protected static final String LONGTEXTEXTANTION = "                                                                                                                                                                                                                                                                                                                                                                                                                               X";

    public Comment(String theCommentID, String theResID, String theDescription, String theTooltip, String theMenuID, String theBackGroundColor, int theHeight, String theFontName, int theFontSize, String theFontBold, String theFontItalic, String theFontColor, boolean theNoTooltip, boolean theHasLongText, SchedulerProperty theSchedulerProperty, Scheduler scheduler, Helper theHelper) {
        super(theSchedulerProperty, theHelper, scheduler);
        this.newComment = true;
        this.initComponent(theCommentID, theResID, theDescription, theTooltip, theMenuID, theBackGroundColor, theHeight, theFontName, theFontSize, theFontBold, theFontItalic, theFontColor, theNoTooltip, theHasLongText);
    }

    public Comment(String theResID, String theDescription, String theBackGroundColor, String theFontName, int theFontSize, String theFontBold, String theFontItalic, String theFontColor, String theMenuID, SchedulerProperty theSchedulerProperty, Scheduler scheduler, Helper theHelper) {
        super(theSchedulerProperty, theHelper, scheduler);
        this.newComment = false;
        this.initComponent(theResID, theResID, theDescription, theDescription, theMenuID, theBackGroundColor, 0, theFontName, theFontSize, theFontBold, theFontItalic, theFontColor, false, false);
    }

    private void initComponent(String theCommentID, String theResID, String theDescription, String theToolTip, String theMenuID, String theBackGroundColor, int theHeight, String theFontName, int theFontSize, String theFontBold, String theFontItalic, String theFontColor, boolean theNoTooltip, boolean theHasLongText) {
        this.setCommentID(theCommentID);
        this.setResID(theResID);
        this.setDescription(theDescription);
        this.setNoTooltip(theNoTooltip);
        this.setToolTip(theToolTip);
        this.setBackGroundColorString(theBackGroundColor);
        this.setFontName(theFontName);
        this.setFontSize(theFontSize);
        this.setFontBold(theFontBold);
        this.setFontItalic(theFontItalic);
        this.setFontColor(theFontColor);
        this.setMenuID(theMenuID);
        this.setComHeight(theHeight);
        this.setHasLongText(theHasLongText);
        this.setFont(this.helper.getFont(theFontName, theFontSize, this.helper.getBooleanValue(theFontBold), this.helper.getBooleanValue(theFontItalic), true));
        this.setForeground(this.helper.getFontColor(theFontColor, this.newComment));
        this.setBackground(this.helper.getColor(this.backGroundColorString));
        if (this.newComment) {
            BorderLayout bl = new BorderLayout(0, 0);
            this.setLayout(bl);
            this.label = this.hasLongText ? new DefaultLabel(this.description + LONGTEXTEXTANTION, this.scheduler, true) : new DefaultLabel(this.description, this.scheduler, true);
            this.label.setFont(this.getFont());
            this.label.setForeground(this.getForeground());
            this.label.setBackground(this.helper.getColor(this.backGroundColorString));
            this.label.setOpaque(false);
            this.label.setFocusable(Flag.focus);
            this.label.setRequestFocusEnabled(Flag.reFou);
            this.setAlignmentY(0.0f);
            DefaultPanel p = new DefaultPanel();
            p.setBackground(null);
            p.setBackground(this.helper.getColor(this.backGroundColorString));
            p.setForeground(this.getForeground());
            p.setPreferredSize(new Dimension(2, 2));
            p.setFocusable(Flag.focus);
            p.setRequestFocusEnabled(Flag.reFou);
            DefaultPanel p2 = new DefaultPanel();
            p2.setBackground(this.helper.getColor(this.backGroundColorString));
            p2.setForeground(this.getForeground());
            p2.setFocusable(Flag.focus);
            p2.setRequestFocusEnabled(Flag.reFou);
            this.add((Component)p, "West");
            this.add((Component)p2, "Center");
            p2.setLayout(new BorderLayout(0, 0));
            p2.add((Component)this.label, "Center");
            this.setBorderDefault();
        } else {
            this.setText(this.description);
        }
        if (this.getDescription() != null && !this.getDescription().equalsIgnoreCase("")) {
            this.setFont(this.helper.getFontForString(this.getFont(), this.getDescription()));
        }
        if (this.getToolTip() != null || this.getToolTip().equalsIgnoreCase("")) {
            Font font = this.helper.getFontForString(this.getFont(), this.getToolTip());
            this.toolTipFontName = font != null ? font.getName() : this.schedulerProperty.fontDefault;
        }
        this.setFocusable(Flag.focus);
        this.setRequestFocusEnabled(Flag.reFou);
    }

    protected void setBorderDefault() {
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.schedulerProperty.border));
    }

    @Override
    public String toString() {
        return "\nComment:\nCommentID: " + this.commentID + "\nresID: " + this.resID + "\ndescription: " + this.description + "\ntooltip: " + this.toolTip + "\nTooltip Disabled: " + this.noTooltip + "\nbackGroundColor: " + this.backGroundColorString + "\nfontName: " + this.fontName + "\nfontSize: " + this.fontSize + "\nfontBold: " + this.fontBold + "\nfontItalic: " + this.fontItalic + "\nfontColor: " + this.fontColor;
    }

    public void setSelected(boolean theSelected) {
        if (!this.newComment) {
            return;
        }
        if (theSelected) {
            this.selected = true;
            this.setBorder(BorderFactory.createLineBorder(this.schedulerProperty.border, 2));
        } else {
            this.setBorderDefault();
            this.selected = false;
        }
        this.invalidate();
        this.repaint();
    }

    protected void changeSelection(boolean selection) {
        this.setSelected(selection);
        if (selection) {
            this.removeSelectionOthers();
            this.addSelectedThis();
        } else {
            this.removeSelectThis();
        }
    }

    protected void removeSelectionOthers() {
        this.helper.removeSelectedApps();
        this.helper.removeAreas();
        SelectedCommentController scc = this.scheduler.getSelComCon();
        if (scc == null || scc.isEmpty()) {
            return;
        }
        scc.unselectAll();
    }

    protected void removeSelectThis() {
        SelectedCommentController scc = this.scheduler.getSelComCon();
        if (scc == null || scc.isEmpty()) {
            return;
        }
        scc.remove(this);
    }

    protected void addSelectedThis() {
        SelectedCommentController scc = this.scheduler.getSelComCon();
        if (scc == null) {
            return;
        }
        scc.addSelectedComment(this);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        int button = me.getButton();
        int clickCount = me.getClickCount();
        this.setTargetArea();
        this.removeSelectionOthers();
        if (button == 1) {
            if (clickCount > 1) {
                this.schedulerProperty.selectedResIDForComment = this.resID;
                if (this.newComment) {
                    this.changeSelection(true);
                } else {
                    this.changeSelection(false);
                }
                this.helper.fireEvent(-2550);
            } else {
                this.changeSelection(!this.selected);
                this.getParent().repaint();
            }
        } else if (button == 3) {
            this.schedulerProperty.selectedResIDForComment = this.resID;
            if (this.schedulerProperty.newMenu) {
                this.mouseClickedRight(me);
            } else {
                this.changeSelection(true);
                this.popupX = me.getX();
                this.popupY = me.getY();
                this.makePopupMenuOld();
            }
        }
    }

    @Override
    protected void setTargetArea() {
        this.schedulerProperty.functionRaistAt = 3;
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.mouseEvent = me;
        if (!this.toolTip.equals("") && !this.noTooltip) {
            String text = this.helper.buildTooltipText(this.getToolTip(), false, this.toolTipFontName);
            this.showTipWindow(text);
        }
    }

    @Override
    protected int getXForTooltip(int x) {
        int newX = this.commentBorder.getBounds().x;
        return x + newX;
    }

    @Override
    protected int getYForTooltip() {
        if (this.newComment) {
            return this.getY();
        }
        return super.getYForTooltip();
    }

    public void setCommentBorder(CommentResource commentBorder) {
        this.commentBorder = commentBorder;
    }

    protected void makePopupMenuOld() {
        if (this.schedulerProperty.menus == null || this.schedulerProperty.menus.isEmpty()) {
            return;
        }
        this.popup = new JDefaultPopupMenu(this.schedulerProperty, this);
        if (this.helper.addMenuItem(this, this.popup, this.menuID, false)) {
            this.showPopupMenu(true);
        }
    }

    public String getBackGroundColorString() {
        return this.backGroundColorString;
    }

    public CommentResource getCommentBorder() {
        return this.commentBorder;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFontBold() {
        return this.fontBold;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public String getFontItalic() {
        return this.fontItalic;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String getMenuID() {
        return this.menuID;
    }

    public String getResID() {
        return this.resID;
    }

    public int getCWidth() {
        return this.cWidth;
    }

    public void setCWidth(int width) {
        this.cWidth = width;
    }

    @Override
    public void free() {
        this.resID = null;
        this.description = null;
        this.backGroundColorString = null;
        this.fontName = null;
        this.fontBold = null;
        this.fontItalic = null;
        this.fontColor = null;
        if (this.commentBorder != null) {
            this.commentBorder.free();
        }
        this.commentBorder = null;
        this.menuID = null;
        this.commentScrollPane = null;
    }

    public String getCommentID() {
        return this.commentID;
    }

    public String getToolTip() {
        return this.toolTip;
    }

    protected void setCommentID(String commentID) {
        this.commentID = commentID;
    }

    protected void setResID(String resID) {
        this.resID = resID;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setToolTip(String theTooltip) {
        this.toolTip = (theTooltip == null || theTooltip.equalsIgnoreCase("")) && !this.noTooltip ? this.description : theTooltip;
    }

    protected void setBackGroundColorString(String backGroundColorString) {
        this.backGroundColorString = backGroundColorString;
    }

    protected void setFontName(String fontName) {
        this.fontName = fontName;
    }

    protected void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    protected void setFontBold(String fontBold) {
        this.fontBold = fontBold;
    }

    protected void setFontItalic(String fontItalic) {
        this.fontItalic = fontItalic;
    }

    protected void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    protected void setMenuID(String menuID) {
        this.menuID = menuID;
    }

    public int getComHeight() {
        return this.comHeight;
    }

    protected void setComHeight(int comHeight) {
        this.comHeight = comHeight;
    }

    public boolean isNewComment() {
        return this.newComment;
    }

    protected void setNoTooltip(boolean noTooltip) {
        this.noTooltip = noTooltip;
    }

    public boolean isHasLongText() {
        return this.hasLongText;
    }

    protected void setHasLongText(boolean hasLongText) {
        this.hasLongText = hasLongText;
    }

    public void setCommentScrollPane(CommentScrollPane commentScrollPane) {
        this.commentScrollPane = commentScrollPane;
    }
}

