/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler604;

import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import at.tsa.ishmed.appmntmgmnt.scheduler604.SchedulerPrint;
import java.util.ArrayList;
import java.util.Iterator;

public class PrintThreadCollection {
    private static ArrayList<SchedulerPrint> threads = new ArrayList();

    public static boolean isPrinting(String printID, Helper theHelper) {
        theHelper.logEntering("PrintThreadCollection", "isPrinting");
        if (threads != null && !threads.isEmpty()) {
            ArrayList<SchedulerPrint> off = new ArrayList<SchedulerPrint>();
            boolean isAlive = false;
            int count = 0;
            for (SchedulerPrint o : threads) {
                if (o == null) continue;
                SchedulerPrint sp = o;
                if (sp.getPrintID().equals(printID)) {
                    Thread thread = sp.printThread;
                    if (thread != null) {
                        if (thread.isAlive()) {
                            isAlive = true;
                        } else {
                            off.add(sp);
                        }
                    } else {
                        off.add(sp);
                    }
                }
                theHelper.logInfo("run in while" + ++count);
            }
            threads.removeAll(off);
            return isAlive;
        }
        return false;
    }

    public static void cancelPrinting(String printID, Helper theHelper) {
        theHelper.logEntering("PrintThreadCollection", "cancelPrinting");
        if (threads != null && !threads.isEmpty()) {
            ArrayList<SchedulerPrint> off = new ArrayList<SchedulerPrint>();
            Iterator<SchedulerPrint> it = threads.iterator();
            int count = 0;
            while (it.hasNext()) {
                SchedulerPrint o = it.next();
                if (o == null) continue;
                SchedulerPrint sp = o;
                if (sp.getPrintID().equals(printID)) {
                    Thread thread = sp.printThread;
                    if (thread != null) {
                        if (thread.isAlive()) {
                            sp.printerJ.cancel();
                        }
                        off.add(sp);
                    } else {
                        off.add(sp);
                    }
                }
                theHelper.logInfo("run in while" + ++count);
            }
            threads.removeAll(off);
        }
        theHelper.logExiting("PrintThreadCollection", "cancelPrinting");
    }

    public static void add(SchedulerPrint theSp, Helper theHelper) {
        theHelper.logEntering("PrintThreadCollection", "add");
        if (theSp == null) {
            return;
        }
        if (threads == null) {
            threads = new ArrayList();
        }
        ArrayList<SchedulerPrint> off = new ArrayList<SchedulerPrint>();
        Iterator<SchedulerPrint> it = threads.iterator();
        int count = 0;
        while (it.hasNext()) {
            SchedulerPrint o = it.next();
            if (o == null) continue;
            SchedulerPrint sp = o;
            Thread thread = sp.printThread;
            if (thread != null) {
                if (!thread.isAlive()) {
                    off.add(sp);
                }
            } else {
                off.add(sp);
            }
            theHelper.logInfo("run in while" + ++count);
        }
        threads.removeAll(off);
        threads.add(theSp);
        theHelper.logExiting("PrintThreadCollection", "add");
    }

    public static void remove(String printID, Helper theHelper) {
        theHelper.logEntering("PrintThreadCollection", "remove");
        if (threads != null && !threads.isEmpty()) {
            ArrayList<SchedulerPrint> off = new ArrayList<SchedulerPrint>();
            Iterator<SchedulerPrint> it = threads.iterator();
            int count = 0;
            while (it.hasNext()) {
                SchedulerPrint sp;
                SchedulerPrint o = it.next();
                if (o != null && (sp = o).getPrintID().equals(printID)) {
                    off.add(sp);
                }
                theHelper.logInfo("run in while" + ++count);
            }
            threads.removeAll(off);
        }
        theHelper.logExiting("PrintThreadCollection", "remove");
    }

    public static void destroy(String printID, Helper theHelper) {
        theHelper.logEntering("PrintThreadCollection", "destroy");
        if (threads != null && !threads.isEmpty()) {
            Iterator<SchedulerPrint> it = threads.iterator();
            boolean isBreak = false;
            boolean founded = false;
            int doCount = 0;
            do {
                boolean waitTo = false;
                int count = 0;
                while (it.hasNext()) {
                    SchedulerPrint sp;
                    SchedulerPrint o = it.next();
                    if (o != null && (sp = o).getPrintID().equals(printID)) {
                        founded = true;
                        Thread thread = sp.printThread;
                        if (thread != null) {
                            if (!thread.isAlive()) {
                                sp.destroyMe();
                                isBreak = true;
                            } else {
                                waitTo = true;
                            }
                        } else {
                            sp.destroyMe();
                            isBreak = true;
                        }
                    }
                    theHelper.logInfo("run in while" + ++count);
                }
                if (waitTo) {
                    theHelper.logInfo("Vor waitTo");
                    PrintThreadCollection.waitTo();
                    theHelper.logInfo("Nach waitTo");
                }
                theHelper.logInfo("run in do" + ++doCount);
                if (doCount != 10) continue;
                isBreak = true;
            } while (!isBreak);
            if (founded) {
                PrintThreadCollection.remove(printID, theHelper);
            }
        }
        theHelper.logExiting("PrintThreadCollection", "destroy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitTo() {
        long l = 1000L;
        try {
            Object o;
            Object object = o = new Object();
            synchronized (object) {
                o.wait(l);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

