/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.system.gui;

import at.tsa.ishmed.appmntmgmnt.Flag;
import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JLabel;

public class DefaultLabel
extends JLabel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 8798190150476848261L;
    protected MouseEvent mouseEvent;
    protected int mouseButton = -1;
    Point preferredLocation;
    protected Scheduler scheduler;
    protected int absolutX = 0;
    protected int absolutY = 0;
    protected Helper helper;
    protected boolean noMouseEvents = false;

    public DefaultLabel(Scheduler theScheduler) {
        this.scheduler = theScheduler;
        this.initComponent();
    }

    public DefaultLabel(String text, Scheduler theScheduler, boolean noMouseEventHandling) {
        super(text);
        this.scheduler = theScheduler;
        this.noMouseEvents = noMouseEventHandling;
        this.initComponent();
    }

    public DefaultLabel(String text, int horizontalAlignment, Scheduler theScheduler) {
        super(text, horizontalAlignment);
        this.scheduler = theScheduler;
        this.initComponent();
    }

    public DefaultLabel(Icon image, Scheduler theScheduler) {
        super(image);
        this.scheduler = theScheduler;
        this.initComponent();
    }

    public DefaultLabel(Icon image, int horizontalAlignment, Scheduler theScheduler) {
        super(image, horizontalAlignment);
        this.scheduler = theScheduler;
        this.initComponent();
    }

    public DefaultLabel(String text, Icon image, int horizontalAlignment, Scheduler theScheduler) {
        super(text, image, horizontalAlignment);
        this.scheduler = theScheduler;
        this.initComponent();
    }

    private void initComponent() {
        this.helper = this.scheduler.getHelper();
        this.setFocusable(Flag.focus);
        this.setRequestFocusEnabled(Flag.reFou);
        this.setOpaque(false);
        if (!(this.scheduler.getSchedulerProperty().print || this.scheduler.getSchedulerProperty().printPreview || this.noMouseEvents)) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
        this.setDoubleBuffered(true);
        this.setForeground(this.scheduler.getSchedulerProperty().colorFontDefaultNoTimeObject);
    }

    protected void showTipWindow(String text, String theFontName) {
        if (text == null || text.equals("")) {
            this.hideTipWindow();
            return;
        }
        if (this.mouseEvent == null) {
            return;
        }
        int x = this.mouseEvent.getX() + 20;
        int y = this.mouseEvent.getY();
        y = this.getYAbsoulut(y);
        String textHtml = this.helper.buildTooltipText(text, false, theFontName);
        this.scheduler.ground.showTipWindow(textHtml, this.getXForTooltip(x), y);
        this.scheduler.ground.tipShowing = true;
    }

    protected int getXForTooltip(int x) {
        return x + this.absolutX;
    }

    protected void hideTipWindow() {
        if (this.scheduler.ground.tipShowing) {
            this.scheduler.ground.hideTipWindow();
        }
    }

    protected int getYAbsoulut(int y) {
        return this.absolutY + y;
    }

    public void setToolTipText(String text, String theFontName) {
        this.showTipWindow(text, theFontName);
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.mouseEvent = me;
        this.scheduler.requestFocus();
        this.scheduler.requestFocusInWindow();
        this.hideTipWindow();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.mouseEvent = me;
        this.mouseButton = me.getButton();
        this.hideTipWindow();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.mouseEvent = me;
        this.hideTipWindow();
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.mouseEvent = me;
        this.hideTipWindow();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.mouseEvent = me;
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.mouseEvent = me;
        this.hideTipWindow();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.mouseEvent = me;
        this.showTipWindow(this.getText(), this.getFont().getName());
    }

    public void setApsolutX(int x) {
        this.absolutX = x;
    }

    public void setAbsolutY(int absolutY) {
        this.absolutY = absolutY;
    }

    public void free() {
        this.mouseEvent = null;
        this.preferredLocation = null;
        this.scheduler = null;
        this.removeAll();
    }
}

