/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.system;

import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.SchedulerListenerI;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.Menu;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.comment.Comment;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.resource.Resource;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.ResourceAllocation;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.ResourceAllocationSortProperty;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.SelArea;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.dayPanel.SchedulerDayPanel;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.timePanel.SchedulerTimePanel;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.base.SortSequence;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.JDefaultPopupMenu;
import com.ishmed.tech.client.jccf.JCCFLoggerI;
import com.ishmed.tech.client.jccf.util.Util;
import com.ishmed.tech.client.jccf.util.XMLUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Helper {
    protected SchedulerProperty schedulerProperty;
    protected Scheduler scheduler;
    public JCCFLoggerI log;
    protected boolean test = false;

    public Helper(SchedulerProperty theSchedulerProperty, Scheduler theScheduler) {
        this.schedulerProperty = theSchedulerProperty;
        this.scheduler = theScheduler;
    }

    public void free() {
        this.schedulerProperty = null;
        this.scheduler = null;
    }

    public int hex2Int(String theHexString) {
        return Integer.decode("0x" + theHexString);
    }

    public Color getColor(String theColor) {
        Color c = null;
        c = this.getColor(theColor, false);
        if (c == null) {
            return this.schedulerProperty.colorDefault;
        }
        return c;
    }

    public Color getFontColor(String theColor, boolean timeObj) {
        Color c = null;
        c = this.getColor(theColor, true);
        if (c == null) {
            return timeObj ? this.schedulerProperty.colorFontDefault : this.schedulerProperty.colorFontDefaultNoTimeObject;
        }
        return c;
    }

    protected Color getColor(String theColor, boolean font) {
        if (theColor == null || theColor.trim().isEmpty() || theColor.trim().length() < 2) {
            if ((this.schedulerProperty.print || this.schedulerProperty.printPreview) && !font) {
                return new Color(255, 255, 255);
            }
            return null;
        }
        try {
            int len = theColor.length();
            int[] color = new int[len / 2];
            int pos = 0;
            while (pos < len) {
                color[pos / 2] = this.hex2Int(theColor.substring(pos, pos + 2));
                pos += 2;
            }
            return len == 6 ? new Color(color[2], color[1], color[0]) : new Color(color[2], color[1], color[0], color[3]);
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getColor" + theColor, ex);
            ex.printStackTrace(System.err);
            System.err.println(String.valueOf(ex) + theColor);
            return null;
        }
    }

    public int getMinutesOfTime(String theTime) {
        String hours = "0";
        String minutes = "0";
        if (theTime.length() >= 4) {
            hours = theTime.substring(0, 2);
            minutes = theTime.substring(2, 4);
        }
        return this.getIntValue(hours) * 60 + this.getIntValue(minutes);
    }

    public String getTimeOfMinutes(int theMinutes) {
        int hour = this.getHour(theMinutes);
        int minutes = this.getMinutesOfCurrentHour(theMinutes, hour);
        return this.getTimeAsString(hour) + this.getTimeAsString(minutes);
    }

    public String getTimeForInfo(int theMinutes) {
        int hour = theMinutes / 60;
        int minutes = theMinutes;
        if (theMinutes >= 60) {
            minutes -= hour * 60;
        }
        StringBuffer sb = new StringBuffer();
        if (hour > 24) {
            hour -= 24;
        }
        if (hour == 24 && minutes > 0) {
            hour = 0;
        }
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        sb.append(":");
        if (minutes < 10) {
            sb.append("0");
        }
        sb.append(minutes);
        return new String(sb);
    }

    public String getTimeForInfo(String theTime) {
        if (theTime.length() < 4) {
            return "n/a";
        }
        return theTime.substring(0, 2) + ":" + theTime.substring(2, 4);
    }

    public String getTimeAsString(int theTime) {
        return theTime < 10 ? "0" + theTime : String.valueOf(theTime);
    }

    public int getHour(int theTime) {
        return theTime / 60;
    }

    public int getMinutesOfCurrentHour(int theTime) {
        return this.getMinutesOfCurrentHour(theTime, this.getHour(theTime));
    }

    private int getMinutesOfCurrentHour(int theMinute, int theHour) {
        if (theMinute < 60) {
            return theMinute;
        }
        return theMinute - theHour * 60;
    }

    public int getMinuteInterval(int theTimeInterval) {
        return 60 / theTimeInterval;
    }

    public String calculateNextMinuteToPrint(String theMinuteToPrint) {
        int result = Integer.valueOf(theMinuteToPrint) + this.schedulerProperty.timeIntervalScale;
        return this.getTimeAsString(result);
    }

    public boolean getBooleanValue(String theBooleanString) {
        if (theBooleanString == null) {
            return false;
        }
        return theBooleanString.trim().equalsIgnoreCase("X") || theBooleanString.trim().equals("1");
    }

    public Font getFont(String theFontname, int theFontSize, boolean theFontBold, boolean theFontItalic, boolean theUseDefaultStyle) {
        int style = 0;
        String fontName = null;
        fontName = theFontname == null || theFontname.trim().isEmpty() ? this.schedulerProperty.fontDefault : theFontname;
        style = theUseDefaultStyle && (theFontname == null || theFontname.trim().isEmpty()) && !theFontBold && !theFontItalic ? this.schedulerProperty.fontDefaultStyle : 0 + (theFontBold ? 1 : 0) + (theFontItalic ? 2 : 0);
        int fontSize = theFontSize > 0 ? theFontSize : this.schedulerProperty.fontDefaultSize;
        return new Font(fontName, style, fontSize);
    }

    public int getFontStyle(String theFontBold, String theFontItalic) {
        return 0 + (this.getBooleanValue(theFontBold) ? 1 : 0) + (this.getBooleanValue(theFontItalic) ? 2 : 0);
    }

    private String getFontFaceForTooltip(String htmlText, String theFontName) {
        String text = "<html><head><style type=\"text/css\">body {font-size: " + this.schedulerProperty.fontDefaultSize + "; font-family: " + theFontName + ";color: rgb(" + this.schedulerProperty.colorFontDefaultNoTimeObject.getRed() + "," + this.schedulerProperty.colorFontDefaultNoTimeObject.getGreen() + "," + this.schedulerProperty.colorFontDefaultNoTimeObject.getBlue() + ");}</style></head><body>" + htmlText + "</body></html>";
        return text;
    }

    public String buildTooltipText(String text, boolean textIsHtml, String theFontName) {
        if (text == null) {
            return "";
        }
        String htmlText = "";
        if (!textIsHtml) {
            StringTokenizer stLineFeed = new StringTokenizer(text, "\n");
            StringBuffer descBuffer = new StringBuffer();
            int count = stLineFeed.countTokens();
            int i = 0;
            while (stLineFeed.hasMoreTokens()) {
                if (i + 1 == count) {
                    descBuffer.append(stLineFeed.nextToken());
                } else {
                    descBuffer.append(stLineFeed.nextToken() + "<br>");
                }
                ++i;
            }
            htmlText = descBuffer.toString();
        } else {
            htmlText = text;
        }
        return this.getFontFaceForTooltip(htmlText, theFontName);
    }

    public String getDefaultTitelFontName() {
        return this.schedulerProperty.fontDefault;
    }

    public void calcMinuteToPixel() {
        if (this.schedulerProperty.minuteToPixel == null) {
            this.schedulerProperty.minuteToPixel = new TreeMap();
        } else {
            this.schedulerProperty.minuteToPixel.clear();
        }
        float time = this.schedulerProperty.limitEndTime - this.schedulerProperty.limitStartTime;
        float interval = this.schedulerProperty.currentHeightOfTimeScale / time;
        float value = 0.0f;
        int i = this.schedulerProperty.limitStartTime;
        while (i <= this.schedulerProperty.limitEndTime) {
            this.schedulerProperty.minuteToPixel.put(i, Float.valueOf(value));
            value += interval;
            ++i;
        }
        this.calcPixelToMinute();
    }

    public void calcPixelToMinute() {
        if (this.schedulerProperty.pixelToMinute == null) {
            this.schedulerProperty.pixelToMinute = new HashMap();
        } else {
            this.schedulerProperty.pixelToMinute.clear();
        }
        Iterator<Map.Entry<Integer, Float>> iterator = this.schedulerProperty.minuteToPixel.entrySet().iterator();
        int oldValue = 0;
        Integer oldKey = null;
        while (iterator.hasNext()) {
            Map.Entry<Integer, Float> entryColumn = iterator.next();
            int value = entryColumn.getValue().intValue();
            Integer key = entryColumn.getKey();
            if (oldValue == value) {
                this.schedulerProperty.pixelToMinute.put(value, key);
                oldKey = key;
                oldValue = value + 1 - 1 + 1;
                continue;
            }
            int i = oldValue;
            while (i < value) {
                this.schedulerProperty.pixelToMinute.put(i, oldKey);
                ++i;
            }
            this.schedulerProperty.pixelToMinute.put(value, key);
            oldKey = key;
            oldValue = value + 1;
        }
    }

    public void fireEvent(int theEvent) {
        switch (theEvent) {
            case -2555: {
                this.fireEvent("handleRegcardChanged", this.getDataForRegcardChanged());
                break;
            }
            case -2552: {
                this.fireEvent("handleScrollBack", this.getDataScroll("ScrollBack"));
                break;
            }
            case -2551: {
                this.fireEvent("handleScrollForward", this.getDataScroll("ScrollForward"));
                break;
            }
            case -2558: {
                this.fireEvent("handleGotFocus", this.getDataForGotFocus());
                break;
            }
            case -2550: {
                this.fireEvent("handleTimeSelect", this.getDataForTimeSelect());
                break;
            }
            case -2554: {
                this.fireEvent("handleTimeChange", this.getDataForTimeChange());
                break;
            }
            case -2570: {
                this.fireEvent("handleFunctionSelected", this.getDataForFunctionSelected());
                break;
            }
            case -2601: {
                if (!this.schedulerProperty.newMenu) break;
                this.fireEvent("handleContextMenu", this.getDataForContextMenu());
                break;
            }
            case -2602: {
                this.fireEvent("controlReady", "ready");
                break;
            }
            case -2553: {
                break;
            }
        }
    }

    protected void fireEvent(String eventName, String data) {
        this.fireEventInt(eventName, data);
    }

    protected void fireEventInt(String eventName, String data) {
        int size = this.schedulerProperty.schedulerListeners.size();
        int i = 0;
        while (i < size) {
            SchedulerListenerI schedulerListener = this.schedulerProperty.schedulerListeners.get(i);
            if (eventName.equalsIgnoreCase("controlReady")) {
                schedulerListener.controlReady(data);
            } else if (eventName.equalsIgnoreCase("handleContextMenu")) {
                schedulerListener.handleContextMenu(data);
            } else if (eventName.equalsIgnoreCase("handleFunctionSelected")) {
                schedulerListener.handleFunctionSelected(data);
            } else if (eventName.equalsIgnoreCase("handleGotFocus")) {
                schedulerListener.handleGotFocus(data);
            } else if (eventName.equalsIgnoreCase("handleRegcardChanged")) {
                schedulerListener.handleRegcardChanged(data);
            } else if (eventName.equalsIgnoreCase("handleScrollBack")) {
                schedulerListener.handleScrollBack(data);
            } else if (eventName.equalsIgnoreCase("handleScrollForward")) {
                schedulerListener.handleScrollForward(data);
            } else if (eventName.equalsIgnoreCase("handleTimeChange")) {
                schedulerListener.handleTimeChange(data);
            } else if (eventName.equalsIgnoreCase("handleTimeSelect")) {
                schedulerListener.handleTimeSelect(data);
            }
            ++i;
        }
    }

    public static String getTimeStamp() {
        Calendar cal = Calendar.getInstance();
        return String.valueOf(String.valueOf(cal.get(5)).length() < 2 ? "0" + cal.get(5) : Integer.valueOf(cal.get(5))) + "." + String.valueOf(String.valueOf(cal.get(2) + 1).length() < 2 ? "0" + cal.get(2) + "1" : Integer.valueOf(cal.get(2) + 1)) + "." + cal.get(1) + ", " + String.valueOf(String.valueOf(cal.get(11)).length() < 2 ? "0" + cal.get(11) : Integer.valueOf(cal.get(11))) + ":" + String.valueOf(String.valueOf(cal.get(12)).length() < 2 ? "0" + cal.get(12) : Integer.valueOf(cal.get(12))) + ":" + String.valueOf(String.valueOf(cal.get(13)).length() < 2 ? "0" + cal.get(13) : Integer.valueOf(cal.get(13))) + "  ";
    }

    public void timeTrace(String theText, long duration) {
        File logFile = null;
        try {
            logFile = new File(this.schedulerProperty.timeLogFileNameComplete);
            BufferedWriter out = new BufferedWriter(new FileWriter(logFile, true));
            out.write("[" + Helper.getTimeStamp() + "][" + theText + "]<" + duration + ">");
            out.newLine();
            out.close();
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "timeTrace", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
            JOptionPane jOptionPane = new JOptionPane("writeTimeLogFile, FileName: " + this.schedulerProperty.logFileNameComplete + "  => " + ex.toString(), 0, -1);
            JDialog jDialog = jOptionPane.createDialog(null, "Error");
            jDialog.setVisible(true);
        }
    }

    public String calculateTimeToTimeScale(int theTime, int theTimeScale, boolean forInfo) {
        this.logEntering("Helper", "calculateTimeToTimeScale " + theTime + " " + theTimeScale + " " + forInfo);
        int newTime = theTime;
        newTime = this.calculateTimeToTimeScaleInt(theTime, theTimeScale);
        this.logExiting("Helper", "calculateTimeToTimeScale " + newTime + " " + forInfo);
        return forInfo ? this.getTimeForInfo(newTime) : this.getTimeOfMinutes(newTime);
    }

    public int calculateTimeToTimeScaleInt(int theTime, int theTimeScale) {
        this.logEntering("Helper", "calculateTimeToTimeScaleInt " + theTime + " " + theTimeScale);
        int er = theTime / theTimeScale;
        this.logExiting("Helper", "calculateTimeToTimeScaleInt " + theTimeScale + " " + er);
        return theTimeScale * er;
    }

    public int calculateTimeToToTimeScaleInt(int theTime, int theTimeScale) {
        int er = theTime / theTimeScale;
        int newTime = theTimeScale * (er + 1);
        if (this.schedulerProperty.limitEndTime < newTime) {
            newTime = this.schedulerProperty.limitEndTime;
        }
        return newTime;
    }

    public long getTime() {
        return System.currentTimeMillis();
    }

    public void closeZoomMode(boolean update) {
        if (this.schedulerProperty.zoomCollMode || this.schedulerProperty.zoomMode) {
            this.scheduler.getColCon().setColseZoomMode();
            this.scheduler.getResCon().setColseZoomMode();
            if (this.schedulerProperty.showDayBasedApp) {
                this.scheduler.getResDayCon().setColseZoomMode();
            }
        }
        this.schedulerProperty.saveColID = null;
        this.schedulerProperty.saveResID = null;
        this.schedulerProperty.zoomMode = false;
        this.schedulerProperty.zoomCollMode = false;
        if (update) {
            this.scheduler.update();
        }
    }

    public String getNodeValueS(NodeList theNodeList, String theName) {
        Node node = null;
        try {
            int x = 0;
            while (x < theNodeList.getLength()) {
                Node nodeV;
                node = theNodeList.item(x);
                if (node.getNodeName().equalsIgnoreCase(theName) && (nodeV = node.getFirstChild()) != null) {
                    String retString = nodeV.getNodeValue().trim();
                    return retString;
                }
                ++x;
            }
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getNodeValuseS", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
        return "";
    }

    public String getNodeAttributeS(NodeList theNodeList, String theNodeName, String theAttributeName) {
        Node node = null;
        try {
            int x = 0;
            while (x < theNodeList.getLength()) {
                node = theNodeList.item(x);
                if (node.getNodeName().equalsIgnoreCase(theNodeName)) {
                    short type = node.getNodeType();
                    switch (type) {
                        case 1: {
                            String retString = null;
                            NamedNodeMap attrs = node.getAttributes();
                            if (attrs == null || (node = attrs.getNamedItem(theAttributeName)) == null) break;
                            retString = node.getNodeValue();
                            return retString;
                        }
                    }
                }
                ++x;
            }
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getNodeAttributeS", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
        return "";
    }

    public int getNodeValueI(NodeList theNodeList, String theName) {
        String lVal = this.getNodeValueS(theNodeList, theName);
        return this.getIntValue(lVal);
    }

    public boolean getNodeValueB(NodeList theNodeList, String theName) {
        return this.getBooleanValue(this.getNodeValueS(theNodeList, theName));
    }

    public int getIntValue(String theValue) {
        if (theValue != null && !theValue.trim().isEmpty()) {
            theValue.trim();
            return Integer.parseInt(theValue.trim());
        }
        return 0;
    }

    public String getNodeValue(NodeList theNodeList, int idx) {
        String retString = "";
        try {
            Node node = theNodeList.item(idx).getFirstChild();
            if (node != null) {
                retString = node.getNodeValue();
                return retString;
            }
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getNodeValue", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
        if (retString == null) {
            retString = "";
        }
        return retString.trim();
    }

    public Node getNode(NodeList theNodeList, String theName) {
        Node node = null;
        try {
            int x = 0;
            while (x < theNodeList.getLength()) {
                node = theNodeList.item(x);
                if (node.getNodeName().equalsIgnoreCase(theName)) {
                    return node;
                }
                ++x;
            }
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getNode", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
        return null;
    }

    public NodeList getNodeList(NodeList theNodeList, String theName) {
        try {
            int x = 0;
            while (x < theNodeList.getLength()) {
                if (theNodeList.item(x).getNodeName().equalsIgnoreCase(theName)) {
                    return theNodeList.item(x).getChildNodes();
                }
                ++x;
            }
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getNodeList", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
        return null;
    }

    public String getDayDate(String colID, String resID) {
        Resource res = this.scheduler.getResDayCon().getResource(colID, resID);
        if (res != null) {
            return res.getToolTipText();
        }
        return null;
    }

    public String formatDuration(int duration) {
        int lenOfDuration = 0;
        Object sDuration = String.valueOf(duration);
        lenOfDuration = ((String)sDuration).length();
        switch (lenOfDuration) {
            case 0: {
                sDuration = "0000";
                break;
            }
            case 1: {
                sDuration = "000" + (String)sDuration;
                break;
            }
            case 2: {
                sDuration = "00" + (String)sDuration;
                break;
            }
            case 3: {
                sDuration = "0" + (String)sDuration;
            }
        }
        return sDuration;
    }

    public int getHeight(int duration) {
        int startTime = this.schedulerProperty.limitStartTime;
        this.getTimeOfMinutes(startTime);
        float timeFromFloat = this.schedulerProperty.minuteToPixel.get(this.schedulerProperty.limitStartTime).floatValue();
        Number o = this.schedulerProperty.minuteToPixel.get(this.schedulerProperty.limitStartTime + duration);
        if (o == null) {
            o = this.schedulerProperty.minuteToPixel.lastKey();
            o = this.schedulerProperty.minuteToPixel.get(o);
        }
        float timeToFloat = o.floatValue();
        return (int)timeToFloat - (int)timeFromFloat;
    }

    public ArrayList<ResourceAllocationSortProperty> getNodeValueArrayList(NodeList theNodeList, String theName) {
        ArrayList<ResourceAllocationSortProperty> retArrayList = new ArrayList<ResourceAllocationSortProperty>();
        try {
            int lenght = theNodeList.getLength();
            int x = 0;
            while (x < lenght) {
                if (theNodeList.item(x).getNodeName().equalsIgnoreCase(theName)) {
                    NodeList nodeList = theNodeList.item(x).getChildNodes();
                    int langht = nodeList.getLength();
                    int i = 0;
                    while (i < langht) {
                        NodeList nodeList2 = nodeList.item(i).getChildNodes();
                        ResourceAllocationSortProperty aSP = new ResourceAllocationSortProperty();
                        aSP.setValue(this.getNodeValueS(nodeList2, "sv"));
                        aSP.setField(this.getNodeValueS(nodeList2, "sf"));
                        SortSequence sS = this.schedulerProperty.appSortSequence.get(i);
                        aSP.setSortMode(sS.getMode());
                        retArrayList.add(aSP);
                        ++i;
                    }
                }
                ++x;
            }
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getNodeValueArrayList", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
        if (retArrayList.isEmpty()) {
            return null;
        }
        return retArrayList;
    }

    public String getDataForTimeSelect() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("TimeSelect");
            doc.appendChild(root);
            this.makeSelResAlls(doc);
            this.makeElementTargetArea(doc);
            this.makeElementSelTime(doc);
            this.makeSelSptKey(doc);
            this.makeElementSelResidForComment(doc);
            this.getHeightOfCommentDay(doc);
            this.makeSelComments(doc);
            String s = this.createStringFromDoc(doc);
            return s;
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getDataForTimeSelect", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
            return "";
        }
    }

    public String getDataForTimeChange() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("TimeChange");
            doc.appendChild(root);
            this.makeElementTargetArea(doc);
            this.makeSelResAlls(doc);
            this.makeElementSelTime(doc);
            this.makeElementEndTime(doc);
            this.makeSelSptKey(doc);
            this.getHeightOfCommentDay(doc);
            this.makeSelComments(doc);
            return this.createStringFromDoc(doc);
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getDataForTimeChange", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
            return "";
        }
    }

    public String getDataForGotFocus() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("GotFocus");
            doc.appendChild(root);
            this.makeElementTargetArea(doc);
            this.makeSelResAlls(doc);
            this.makeSelAreas(doc);
            this.getHeightOfCommentDay(doc);
            this.makeSelComments(doc);
            return this.createStringFromDoc(doc);
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getDataForGotFocus", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
            return "";
        }
    }

    public String getDataForRegcardChanged() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("RegcardChanged");
            doc.appendChild(root);
            this.makeElementRegID(doc);
            this.getHeightOfCommentDay(doc);
            return this.createStringFromDoc(doc);
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getDataForRegcardChanged", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
            return "";
        }
    }

    public String getDataScroll(String scroll) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("scroll");
            doc.appendChild(root);
            this.makeSelResAlls(doc);
            this.makeSelAreas(doc);
            this.makeSelComments(doc);
            this.getHeightOfCommentDay(doc);
            return this.createStringFromDoc(doc);
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getDataScroll", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
            return "";
        }
    }

    public String getDataForFunctionSelected() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("FunctionSelected");
            doc.appendChild(root);
            Element item = doc.createElement("functionCode");
            root.appendChild(item);
            item.appendChild(doc.createTextNode(this.scheduler.getFunctionCode()));
            if (this.schedulerProperty.functionRaistAt == 1) {
                this.makeSelResAlls(doc);
                this.makeSelAreas(doc);
                this.makeSptKeyTimeFromTo(doc);
            } else if (this.schedulerProperty.functionRaistAt == 2) {
                this.makeSelResAlls(doc);
                this.makeSelAreas(doc);
                this.makeSptKeyTimeFromTo(doc);
            } else if (this.schedulerProperty.functionRaistAt == 3) {
                this.makeElementSelResidForComment(doc);
                this.makeSelComments(doc);
            }
            this.getHeightOfCommentDay(doc);
            this.makeSelMakKey(doc);
            this.makeElementTargetArea(doc);
            return this.createStringFromDoc(doc);
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getDataForFunctionSelected", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
            return "";
        }
    }

    public String getDataForContextMenu() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("ContextMenu");
            doc.appendChild(root);
            this.makeElementTargetArea(doc);
            this.makeSelResAlls(doc);
            this.makeSelAreas(doc);
            this.makeSptKeyTimeFromTo(doc);
            this.makeElementSelResidForComment(doc);
            this.getHeightOfCommentDay(doc);
            this.makeSelMakKey(doc);
            this.makeSelComments(doc);
            return this.createStringFromDoc(doc);
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getDataForContextMenu", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
            return "";
        }
    }

    private void makeElementSelResidForComment(Document doc) {
        Element item = doc.createElement("selResidForComment");
        Node root = doc.getFirstChild();
        root.appendChild(item);
        String s = this.scheduler.getSelResidForComment();
        if (s == null) {
            s = "";
        }
        item.appendChild(doc.createTextNode(s));
    }

    private void makeSptKeyTimeFromTo(Document doc) {
        this.makeElementSelTime(doc);
        this.makeElementEndTime(doc);
        this.makeSelSptKey(doc);
    }

    private void getHeightOfCommentDay(Document doc) {
        Element item = doc.createElement("commentHeight");
        Node root = doc.getFirstChild();
        root.appendChild(item);
        if (this.schedulerProperty.showComment) {
            item.appendChild(doc.createTextNode(Integer.toString(this.scheduler.getCommentHeight())));
        } else {
            item.appendChild(doc.createTextNode("0"));
        }
        item = doc.createElement("dbaHeight");
        root.appendChild(item);
        if (this.schedulerProperty.showDayBasedApp) {
            item.appendChild(doc.createTextNode(Integer.toString(this.scheduler.getDBAHeight())));
        } else {
            item.appendChild(doc.createTextNode("0"));
        }
    }

    private void makeElementTargetArea(Document doc) {
        Node root = doc.getFirstChild();
        Element item = doc.createElement("targetArea");
        item.appendChild(doc.createTextNode(this.scheduler.getTargetArea()));
        root.appendChild(item);
    }

    private void makeElementSelTime(Document doc) {
        Node root = doc.getFirstChild();
        Element item = doc.createElement("selTime");
        item.appendChild(doc.createTextNode(this.scheduler.getSelTime()));
        root.appendChild(item);
    }

    private void makeElementEndTime(Document doc) {
        Node root = doc.getFirstChild();
        Element item = doc.createElement("endTime");
        item.appendChild(doc.createTextNode(this.scheduler.getEndTime()));
        root.appendChild(item);
    }

    private void makeSelSptKey(Document doc) {
        Node root = doc.getFirstChild();
        Element item = doc.createElement("selSptKey");
        root.appendChild(item);
        String s = this.scheduler.getSelSptKey();
        if (s == null) {
            s = "";
        }
        item.appendChild(doc.createTextNode(s));
    }

    private void makeElementRegID(Document doc) {
        Node root = doc.getFirstChild();
        Element item = doc.createElement("regident");
        item.appendChild(doc.createTextNode(this.scheduler.getRegident()));
        root.appendChild(item);
    }

    private void makeSelMakKey(Document doc) {
        Node root = doc.getFirstChild();
        Element item = doc.createElement("selMarkKey");
        root.appendChild(item);
        String s = this.scheduler.getSelMarkKey();
        if (s == null) {
            s = "";
        }
        item.appendChild(doc.createTextNode(s));
    }

    private void makeSelAreas(Document doc) {
        this.appendSelFocusAreasElement(doc);
        this.appendSelStartAreasElement(doc);
    }

    protected void makeSelResAlls(Document doc) {
        this.appendSelAppmntsElement(doc);
    }

    public void appendSelAppmntsElement(Document doc) {
        try {
            Element root = doc.createElement("selAppmnts");
            Node firstChild = doc.getFirstChild();
            if (firstChild != null) {
                firstChild.appendChild(root);
            } else {
                doc.appendChild(root);
            }
            if (this.scheduler.getFoResAllKCon() == null) {
                return;
            }
            ArrayList<String> selApps = this.scheduler.getFoResAllKCon().getAllApp();
            if (selApps == null || selApps.isEmpty()) {
                return;
            }
            Iterator<String> it = selApps.iterator();
            while (it.hasNext()) {
                Element item = doc.createElement("a");
                root.appendChild(item);
                Element attrib = doc.createElement("tk");
                item.appendChild(attrib);
                String tk = it.next();
                attrib.appendChild(doc.createTextNode(tk));
            }
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "appendSelAppmntsElement", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
    }

    public String createStringFromDoc(Document doc) {
        return XMLUtil.createStringFromDoc((Document)doc);
    }

    public static String toHexString(byte[] bytes) {
        return Util.toHexString((byte[])bytes);
    }

    public void unselectIfNecessary(String colId, String resId) {
        boolean unselect = false;
        for (String s : this.scheduler.getFoResAllKCon().getAllResAll()) {
            ResourceAllocation resAll = this.scheduler.getResAllCon().getResourceAllocation(s);
            if (resAll == null || resAll.getColID().equalsIgnoreCase(colId) && resAll.getResID().equalsIgnoreCase(resId)) continue;
            unselect = true;
            break;
        }
        if (unselect) {
            this.scheduler.unselectAll();
        }
    }

    public void unselectIfNecessary(String colId) {
        boolean unselect = false;
        for (String s : this.scheduler.getFoResAllKCon().getAllResAll()) {
            ResourceAllocation resAll = this.scheduler.getResAllCon().getResourceAllocation(s);
            if (resAll == null || resAll.getColID().equalsIgnoreCase(colId)) continue;
            unselect = true;
            break;
        }
        if (unselect) {
            this.scheduler.unselectAll();
        }
    }

    public int calcDuratrton(int to, int from, boolean old) {
        int ret = 0;
        if (from > to) {
            ret = 0;
        } else {
            ret = to - from;
            if (old) {
                ret /= 100;
            }
        }
        return ret;
    }

    public String getData() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("getData");
            doc.appendChild(root);
            Element item = doc.createElement("functionCode");
            root.appendChild(item);
            item.appendChild(doc.createTextNode(this.scheduler.getFunctionCode()));
            this.makeElementTargetArea(doc);
            this.makeSelResAlls(doc);
            this.makeSelAreas(doc);
            this.makeElementSelTime(doc);
            this.makeSelSptKey(doc);
            this.makeElementSelResidForComment(doc);
            this.getHeightOfCommentDay(doc);
            this.makeElementRegID(doc);
            this.makeSelMakKey(doc);
            this.makeSptKeyTimeFromTo(doc);
            this.makeSelComments(doc);
            String s = this.createStringFromDoc(doc);
            return s;
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getData", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
            return "";
        }
    }

    public ArrayList<ResourceAllocation> sortAllCorrespondingArrayLists(ArrayList<ResourceAllocation> allAppointments) {
        ArrayList<ResourceAllocation> sortedArrayList = new ArrayList<ResourceAllocation>();
        if (allAppointments == null || allAppointments.isEmpty()) {
            return null;
        }
        int size = allAppointments.size();
        TreeMap prioMap = new TreeMap();
        int i = 0;
        while (i < size) {
            int sizeArrayList;
            ResourceAllocation resAll = allAppointments.get(i);
            ArrayList<ResourceAllocation> appIDArrayList = (ArrayList<ResourceAllocation>)prioMap.get(resAll.getPrio());
            if (appIDArrayList == null) {
                appIDArrayList = new ArrayList<ResourceAllocation>();
                prioMap.put(resAll.getPrio(), appIDArrayList);
            }
            if ((sizeArrayList = appIDArrayList.size()) == 0) {
                appIDArrayList.add(resAll);
            } else {
                double appID1Dou = Double.parseDouble(resAll.getKey());
                int j = 0;
                while (j < sizeArrayList) {
                    ResourceAllocation resAll1 = (ResourceAllocation)appIDArrayList.get(j);
                    double appID2Dou = Double.parseDouble(resAll1.getKey());
                    if (appID1Dou < appID2Dou) break;
                    ++j;
                }
                appIDArrayList.add(j, resAll);
            }
            ++i;
        }
        for (Map.Entry entry : prioMap.entrySet()) {
            ArrayList theArrayList = (ArrayList)entry.getValue();
            if (theArrayList == null) continue;
            int len = theArrayList.size();
            int i2 = 0;
            while (i2 < len) {
                sortedArrayList.add((ResourceAllocation)theArrayList.get(i2));
                ++i2;
            }
        }
        return sortedArrayList;
    }

    public Rectangle getRecPoint(int timeFromTemp, int timeToTemp) {
        Float timeFromFloatO = null;
        Float timeToFloatO = null;
        if (timeFromTemp < this.schedulerProperty.limitStartTime && timeToTemp > this.schedulerProperty.limitEndTime) {
            timeFromFloatO = this.schedulerProperty.minuteToPixel.get(this.schedulerProperty.limitStartTime);
            timeToFloatO = this.schedulerProperty.minuteToPixel.get(this.schedulerProperty.limitEndTime);
        } else if (timeFromTemp < this.schedulerProperty.limitStartTime && timeToTemp < this.schedulerProperty.limitStartTime) {
            timeFromFloatO = this.schedulerProperty.minuteToPixel.get(this.schedulerProperty.limitStartTime);
            timeToFloatO = this.schedulerProperty.minuteToPixel.get(this.schedulerProperty.limitStartTime);
        } else if (timeFromTemp > this.schedulerProperty.limitEndTime && timeToTemp > this.schedulerProperty.limitEndTime) {
            timeFromFloatO = this.schedulerProperty.minuteToPixel.get(this.schedulerProperty.limitEndTime);
            timeToFloatO = this.schedulerProperty.minuteToPixel.get(this.schedulerProperty.limitEndTime);
        } else {
            Integer inte;
            if (timeFromTemp < this.schedulerProperty.limitStartTime) {
                timeFromFloatO = this.schedulerProperty.minuteToPixel.get(this.schedulerProperty.limitStartTime);
            } else {
                timeFromFloatO = this.schedulerProperty.minuteToPixel.get(timeFromTemp);
                if (timeFromFloatO == null) {
                    inte = this.schedulerProperty.minuteToPixel.firstKey();
                    timeFromFloatO = this.schedulerProperty.minuteToPixel.get(inte);
                }
            }
            if (timeToTemp > this.schedulerProperty.limitEndTime) {
                timeToFloatO = this.schedulerProperty.minuteToPixel.get(this.schedulerProperty.limitEndTime);
            } else {
                timeToFloatO = this.schedulerProperty.minuteToPixel.get(timeToTemp);
                if (timeToFloatO == null) {
                    inte = this.schedulerProperty.minuteToPixel.lastKey();
                    timeToFloatO = this.schedulerProperty.minuteToPixel.get(inte);
                }
            }
        }
        float timeFromFloat = 0.0f;
        float timeToFloat = 0.0f;
        if (timeToFloatO != null) {
            timeToFloat = timeToFloatO.floatValue();
        }
        if (timeFromFloatO != null) {
            timeFromFloat = timeFromFloatO.floatValue();
        }
        int timeFromRemainder = (int)((timeFromFloat - (float)((int)timeFromFloat)) * 100.0f);
        int timeToRemainder = (int)((timeToFloat - (float)((int)timeToFloat)) * 100.0f);
        int y1 = timeFromRemainder > 50 ? (int)timeFromFloat + 1 : (int)timeFromFloat;
        int y2 = timeToRemainder > 50 ? (int)timeToFloat + 1 : (int)timeToFloat;
        return new Rectangle(y1, y2, 0, y2 - y1);
    }

    public void logInfo(String msg) {
        if (this.log != null && this.log.isInfo()) {
            this.log.info(msg);
        }
    }

    public void logEntering(String className, String methodName) {
        if (this.log != null && this.log.isTrace()) {
            this.log.trace(className, methodName, "START ");
        }
    }

    public void logEntering(String className, String methodName, String msg) {
        if (this.log != null && this.log.isTrace()) {
            this.log.trace(className, "START " + methodName, msg);
        }
    }

    public void logExiting(String className, String methodName) {
        if (this.log != null && this.log.isTrace()) {
            this.log.trace(className, methodName, "END ");
        }
    }

    public void logExiting(String className, String methodName, String msg) {
        if (this.log != null && this.log.isTrace()) {
            this.log.trace(className, "END " + methodName, msg);
        }
    }

    public void logThrowing(String classname, String methodname, Throwable throwable) {
        if (this.log != null && this.log.isWarn()) {
            this.log.warn(classname, methodname, "ERROR", throwable);
        }
    }

    public void logError(String classname, String methodname, String msg, Throwable throwable) {
        if (this.log != null && this.log.isError()) {
            this.log.error(classname, methodname, msg, throwable);
        }
    }

    public void appendSelProgressesElement(Document doc) {
        try {
            Element root = doc.createElement("selProgresses");
            Node firstChild = doc.getFirstChild();
            if (firstChild != null) {
                firstChild.appendChild(root);
            } else {
                doc.appendChild(root);
            }
            if (this.scheduler.getFoResAllKCon() == null) {
                return;
            }
            ArrayList<String> selProgs = this.scheduler.getFoResAllKCon().getAllProgress();
            if (selProgs == null || selProgs.isEmpty()) {
                return;
            }
            Iterator<String> it = selProgs.iterator();
            while (it.hasNext()) {
                Element item = doc.createElement("a");
                root.appendChild(item);
                Element attrib = doc.createElement("pk");
                item.appendChild(attrib);
                attrib.appendChild(doc.createTextNode(it.next()));
            }
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "appendSelProgressesElement", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
    }

    public String getDataForSpliterChange() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("SpliterChanged");
            doc.appendChild(root);
            this.getHeightOfCommentDay(doc);
            return this.createStringFromDoc(doc);
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getDataForSpliterChange", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
            return "";
        }
    }

    public String getDataForSelectionChange() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("SelectionChange");
            doc.appendChild(root);
            this.makeElementTargetArea(doc);
            this.makeSelResAlls(doc);
            this.makeElementSelTime(doc);
            this.makeElementEndTime(doc);
            this.makeSelSptKey(doc);
            this.getHeightOfCommentDay(doc);
            this.makeSelComments(doc);
            return this.createStringFromDoc(doc);
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "getDataForSelectionChange", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
            return "";
        }
    }

    public boolean isTest() {
        return this.test;
    }

    protected void makeSelComments(Document doc) {
        this.appendSelCommentsElement(doc);
    }

    public void appendSelCommentsElement(Document doc) {
        try {
            Element root = doc.createElement("selComments");
            Node firstChild = doc.getFirstChild();
            if (firstChild != null) {
                firstChild.appendChild(root);
            } else {
                doc.appendChild(root);
            }
            if (this.scheduler.getSelComCon() == null) {
                return;
            }
            ArrayList<Comment> selComments = this.scheduler.getSelComCon().getAll();
            if (selComments == null || selComments.isEmpty()) {
                return;
            }
            Iterator<Comment> it = selComments.iterator();
            while (it.hasNext()) {
                Element item = doc.createElement("a");
                root.appendChild(item);
                Element attrib = doc.createElement("ci");
                item.appendChild(attrib);
                Comment com = it.next();
                attrib.appendChild(doc.createTextNode(com.getCommentID()));
            }
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "appendSelCommentsElement", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
    }

    public void setTest(boolean test) {
        this.logEntering("Helper", "setTest", Boolean.toString(test));
        this.test = test;
        this.logExiting("Helper", "setTest", Boolean.toString(test));
    }

    public boolean addMenuItem(ActionListener theActionListener, JDefaultPopupMenu thePopup, String theMenuID, boolean addSepperator) {
        if (this.schedulerProperty.menus == null || this.schedulerProperty.menus.isEmpty() || theMenuID == null || theMenuID.equalsIgnoreCase("")) {
            return false;
        }
        Vector<Menu> vectorMenus = this.schedulerProperty.menus.get(theMenuID);
        if (vectorMenus == null || vectorMenus.size() == 0) {
            return false;
        }
        if (addSepperator) {
            thePopup.addSeparator();
        }
        int size = vectorMenus.size();
        Menu menu = null;
        int i = 0;
        while (i < size) {
            menu = vectorMenus.get(i);
            if (menu != null) {
                if (menu.getDesc().trim().equals("-")) {
                    thePopup.addSeparator();
                } else {
                    JMenuItem menuItem = new JMenuItem(menu.getDesc());
                    menuItem.setFont(this.getFont("", 0, false, false, true));
                    menuItem.setActionCommand(menu.getFCode());
                    if (this.schedulerProperty.winGUI && this.schedulerProperty.colorBackgrPopupMenu != null) {
                        menuItem.setBackground(this.schedulerProperty.colorBackgrPopupMenu);
                    }
                    if (!this.schedulerProperty.print) {
                        menuItem.addActionListener(theActionListener);
                    }
                    thePopup.add(menuItem);
                }
            }
            ++i;
        }
        return true;
    }

    public void appendSelFocusAreasElement(Document doc) {
        try {
            Element root = doc.createElement("selFocusAreas");
            Node firstChild = doc.getFirstChild();
            if (firstChild != null) {
                firstChild.appendChild(root);
            } else {
                doc.appendChild(root);
            }
            TreeMap<String, ArrayList<SelArea>> theTreeMap = this.schedulerProperty.focusedAreas;
            if (theTreeMap == null || theTreeMap.isEmpty()) {
                return;
            }
            this.appendAreasToDoc(doc, root, theTreeMap);
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "appendSelFocusAreasElement", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
    }

    public void appendSelStartAreasElement(Document doc) {
        Element root = doc.createElement("selStartAreas");
        Node firstChild = doc.getFirstChild();
        if (firstChild != null) {
            firstChild.appendChild(root);
        } else {
            doc.appendChild(root);
        }
        TreeMap<String, ArrayList<SelArea>> theTreeMap = this.schedulerProperty.startAreas;
        if (theTreeMap == null || theTreeMap.isEmpty()) {
            return;
        }
        this.appendAreasToDoc(doc, root, theTreeMap);
    }

    protected void appendAreasToDoc(Document doc, Element root, TreeMap<String, ArrayList<SelArea>> map) {
        try {
            if (map == null || map.isEmpty()) {
                return;
            }
            Iterator<ArrayList<SelArea>> it = map.values().iterator();
            StringBuffer filler = new StringBuffer();
            int maxSize = 30;
            while (it.hasNext()) {
                ArrayList<SelArea> vectorSelAreasForResource = it.next();
                if (vectorSelAreasForResource == null || vectorSelAreasForResource.isEmpty()) continue;
                int size = vectorSelAreasForResource.size();
                int i = 0;
                while (i < size) {
                    filler.setLength(0);
                    Element item = doc.createElement("a");
                    root.appendChild(item);
                    SelArea selArea = vectorSelAreasForResource.get(i);
                    int lenOfResID = selArea.getResID().length();
                    if (lenOfResID < maxSize) {
                        int j = lenOfResID;
                        while (j < maxSize) {
                            filler.append(" ");
                            ++j;
                        }
                    }
                    Element attrib = doc.createElement("ri");
                    item.appendChild(attrib);
                    attrib.appendChild(doc.createTextNode(selArea.getResID() + filler.toString()));
                    attrib = doc.createElement("tf");
                    item.appendChild(attrib);
                    attrib.appendChild(doc.createTextNode(selArea.getTimeFrom() + "00"));
                    String duration = this.formatDuration(selArea.getDuration());
                    attrib = doc.createElement("du");
                    item.appendChild(attrib);
                    attrib.appendChild(doc.createTextNode(duration));
                    String area = Integer.toString(selArea.getArea());
                    attrib = doc.createElement("ar");
                    item.appendChild(attrib);
                    attrib.appendChild(doc.createTextNode(area));
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            this.logThrowing("Helper", "appendAreasToDoc", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
    }

    public void removeSelectedApps() {
        this.logEntering("Helper", "removeSelectedApps");
        if (this.scheduler.getResAllBorderCon() != null) {
            if (this.schedulerProperty.showDayBasedApp) {
                this.scheduler.getSchedulerDayPanel().unselectAllResAlls(true);
            }
            if (this.scheduler.getSchedulerTimePanel() != null) {
                this.scheduler.getSchedulerTimePanel().unselectAllResAlls(true);
            }
        }
        this.scheduler.getResAllBorderCon().removeAll();
        this.scheduler.getFoResAllKCon().removeAll();
        this.logExiting("Helper", "removeSelectedApps");
    }

    public void removeAreas() {
        SchedulerDayPanel sDP;
        SchedulerTimePanel sTP = this.scheduler.getSchedulerTimePanel();
        if (sTP != null) {
            sTP.removeTimeAreas();
        }
        if ((sDP = this.scheduler.getSchedulerDayPanel()) != null) {
            sDP.removeDayAreas();
        }
    }

    public void removeSelectedComments() {
        this.logEntering("Helper", "removeSelectedComments");
        if (this.scheduler.getSelComCon() != null) {
            this.scheduler.getSelComCon().unselectAll();
        }
        this.logExiting("Helper", "removeSelectedComments");
    }

    public Font getFontForString(Font theFont, String s) {
        int index;
        Font font = null;
        if (s == null || s.equals("")) {
            return null;
        }
        if (this.schedulerProperty.uniFont == null) {
            this.schedulerProperty.uniFont = this.getFont("", 0, false, false, true);
        }
        if (theFont == null) {
            font = this.schedulerProperty.uniFont;
        }
        font = (index = theFont.canDisplayUpTo(s)) == -1 ? theFont : ((index = this.schedulerProperty.uniFont.canDisplayUpTo(s)) == -1 ? this.schedulerProperty.uniFont : new Font("SansSerif", this.schedulerProperty.fontDefaultStyle, this.schedulerProperty.fontDefaultSize));
        return font;
    }
}

