/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.dayPanel;

import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.resource.Resource;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.resource.day.DayResource;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.avaliability.Availability;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.ResourceAllocation;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.ResourceAllocationController;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.appointment.Appointment;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.progress.Progress;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.SchedulerTopPanel;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.SelArea;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.TopArea;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.resourceAllocationBorder.ResourceAllocationBorder;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.resourceAllocationBorder.ResourceAllocationBorderController;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.timePanel.SchedulerTimePanel;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.base.FocusedResourceAllocatonsController;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.DefaultJScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JViewport;

public class SchedulerDayPanel
extends SchedulerTopPanel {
    private static final long serialVersionUID = 318021959114414013L;

    public SchedulerDayPanel(Scheduler theScheduler, SchedulerProperty theSchedulerProperty, Helper theHelper) {
        super(theScheduler, theSchedulerProperty, theHelper);
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        try {
            super.mouseMoved(me);
            this.setCursor(this.cursorDefault);
            int x = me.getX();
            int y = me.getY();
            if (this.schedulerProperty.popupOn) {
                this.setToolTipText(null);
            } else {
                DayResource resource = this.getResource(x);
                if (resource == null) {
                    return;
                }
                int newX = x - resource.getX();
                ResourceAllocation resAll = resource.getResourceAllocationAt(newX, y);
                if (resAll != null && resAll.isVisible()) {
                    this.mouseMovedOnResAll(resAll, me);
                } else {
                    Availability availability = resource.getAvailabilityDay();
                    if (availability != null) {
                        this.mouseMovedOnAvailability(availability, me, resource);
                    } else {
                        this.setToolTipText(null);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.helper.logThrowing("SchedulerDayPanel", "mouseMoved", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
    }

    private void mousePressedOnAppointment(DayResource theResource, Appointment theAppointment, MouseEvent me) {
        this.setMouseClicked(true);
        this.xSave = me.getX();
        this.ySave = me.getY();
        ResourceAllocationBorderController aBC = this.scheduler.getResAllBorderCon();
        if (aBC.getAppBorder() == null || this.isCtrlPressed()) {
            FocusedResourceAllocatonsController fAC = this.scheduler.getFoResAllCon();
            if (!this.isCtrlPressed() && fAC.getSize() <= 1) {
                this.removeAllAppointmentBorder();
                fAC.clear();
            }
            ResourceAllocationBorder appBor = theAppointment.getResourceAllocationBorder();
            if (theAppointment.getHasBorder() && appBor != null && this.isCtrlPressed()) {
                this.removeResAllBorderForResAll(theAppointment);
                this.removeEntryFromFocusedResAllIDs(theAppointment.getKey());
                fAC.remove(theAppointment);
                this.removeResAllSelectionFocus(theAppointment);
                if (this.scheduler.getFoResAllKCon().getSize() < 2) {
                    this.setInMulitAppMode(false);
                }
            } else {
                this.setResourceAllocationBorder((ResourceAllocation)theAppointment, (Resource)theResource, this.xSave, this.ySave, true);
            }
        } else if (aBC.getAppBorder() != null) {
            this.setSelectedAppBorder(theAppointment.getResourceAllocationBorder(), me);
        }
    }

    private void mousePressedOnProgress(DayResource theResource, Progress progress, MouseEvent me) {
        this.setMouseClicked(true);
        this.xSave = me.getX();
        this.ySave = me.getY();
        ResourceAllocationBorderController aBC = this.scheduler.getResAllBorderCon();
        if (aBC.getAppBorder() == null || this.isCtrlPressed()) {
            FocusedResourceAllocatonsController fAC = this.scheduler.getFoResAllCon();
            if (!this.isCtrlPressed() && fAC.getSize() <= 1) {
                this.removeAllAppointmentBorder();
                fAC.clear();
            }
            ResourceAllocationBorder appBor = progress.getResourceAllocationBorder();
            if (progress.getHasBorder() && appBor != null && this.isCtrlPressed()) {
                this.removeResAllBorderForResAll(progress);
                this.removeEntryFromFocusedResAllIDs(progress.getKey());
                fAC.remove(progress);
                this.removeResAllSelectionFocus(progress);
                if (this.scheduler.getFoResAllKCon().getSize() < 2) {
                    this.setInMulitAppMode(false);
                }
            } else {
                this.setResourceAllocationBorder((ResourceAllocation)progress, (Resource)theResource, this.xSave, this.ySave, true);
            }
        } else if (aBC.getAppBorder() != null) {
            this.setSelectedAppBorder(progress.getResourceAllocationBorder(), me);
        }
    }

    private void mouseReleasedInMoveMode(DayResource theResource, MouseEvent me) {
        int checkY;
        int x = me.getX();
        int y = me.getY();
        SchedulerTimePanel sTP = this.scheduler.getSchedulerTimePanel();
        ResourceAllocationBorderController aBC = this.scheduler.getResAllBorderCon();
        ResourceAllocationBorder appointmentBorder = aBC.getAppBorder();
        if (this.isMouseOnTimeArea(y) && appointmentBorder != null) {
            sTP.setResourceAllocationToTimeArea(this.calculateXForTimePanel(x), this.calculateYForTimePanle(y));
            this.removeEntryFrom = false;
            this.removeAllAppointmentBorder();
            sTP.setRemoveEntryFrom(false);
            sTP.removeAllResAllBorder();
            sTP.resetResourceBackGround(x);
            if (this.schedulerProperty.resourceAtAppDayMovement != null) {
                this.schedulerProperty.resourceAtAppDayMovement.setSelected(false);
            }
            return;
        }
        if (theResource == null || this.isResourceMarked()) {
            if (this.isResourceMarked()) {
                this.currentMarkedResource.setSelected(false);
                this.setResourceMarked(false);
            }
            this.scheduler.getTimeScale().repaint();
        }
        if (theResource == null || this.isMouseClicked() && x == this.xSave && y == this.ySave) {
            this.setMouseClicked(false);
            return;
        }
        if (theResource.getBackground() != theResource.getOriginalBackColor()) {
            theResource.setSelected(false);
            this.setResourceMarked(false);
            this.scheduler.getDayScale().repaint();
        }
        if ((checkY = y - this.schedulerProperty.resourceAllocationForManipulation.getBounds().height / 2 + 1) < 1) {
            y += (checkY *= -1);
        }
        if (!this.isAvailable(theResource)) {
            if (appointmentBorder != null) {
                this.removeAllAppointmentBorder();
            }
            return;
        }
        Object newDay = this.getDayObjectAtX(x);
        if (newDay != null && theResource != this.getResourceForAppointmetnSelected()) {
            this.setAppToDayResource(theResource);
            this.fireTimeChangeEvent(theResource, me, -1, this.schedulerProperty.resourceAllocationForManipulation.getBounds().y);
            int oldFisY = this.scheduler.getJScrollPaneDayBased().getViewport().getViewPosition().y;
            int oldFisHiht = this.scheduler.getJScrollPaneDayBased().getViewport().getViewRect().height;
            int newFisY = theResource.getYOfFirstNewResAll();
            int newFisH = theResource.getFirstNewResAll().getHeight() + newFisY;
            if (oldFisHiht < newFisH) {
                this.scheduler.getJScrollPaneDayBased().getViewport().scrollRectToVisible(new Rectangle(0, newFisY -= oldFisY, 0, 0));
            } else {
                this.schedulerProperty.beginShowDay = 0;
            }
        }
        if (appointmentBorder != null && !this.isCtrlPressed()) {
            this.removeEntryFrom = false;
            this.removeAllAppointmentBorder();
        }
        this.removeResAllSelection();
    }

    @Override
    public void removeResAllBorderForResAll(ResourceAllocation resAll) {
        ResourceAllocationBorder appBorder = resAll.getResourceAllocationBorder();
        resAll.setHasBorder(false);
        resAll.setSelected(false);
        this.remove(appBorder);
        this.scheduler.getResAllBorderCon().removeAppBorder(appBorder);
        this.removeEntryFromFocusedResAllIDs(appBorder.getAppKey());
        this.invalidate();
        this.repaint();
        if (!resAll.isDayBased()) {
            this.scheduler.getSchedulerTimePanel().remove(appBorder);
        }
        appBorder = null;
    }

    private Object getDayObjectAtX(int x) {
        String colId;
        DayResource res;
        String day = null;
        int ind = x;
        if (ind < 1) {
            ind = 3;
        }
        if ((res = this.getResource(x, colId = this.getColumnID(ind))) != null) {
            day = this.helper.getDayDate(colId, res.getResID());
        }
        return day;
    }

    private void setBoundsImmediatelyForTimeArea(int x) {
        DayResource resourceAtBegin = this.getResource(this.sArea.getXAtConstruction() + 5);
        DayResource resourceAtEnd = this.getResource(x);
        if (resourceAtBegin != null && resourceAtEnd != null) {
            if (resourceAtBegin == resourceAtEnd) {
                this.sArea.setResource(resourceAtBegin);
                int x2 = resourceAtBegin.getBounds().x;
                int widht2 = resourceAtBegin.getBounds().width;
                int height2 = resourceAtBegin.getBounds().height;
                this.sArea.setBounds(x2, 0, widht2, height2);
            } else {
                if (resourceAtBegin.getBounds().x > resourceAtEnd.getBounds().x) {
                    DayResource resourceToChange = resourceAtBegin;
                    resourceAtBegin = resourceAtEnd;
                    resourceAtEnd = resourceToChange;
                }
                this.sArea.setResource(null);
                int x2 = resourceAtBegin.getBounds().x;
                int widht2 = resourceAtEnd.getBounds().x + resourceAtEnd.getBounds().width - resourceAtBegin.getBounds().x;
                int height2 = resourceAtBegin.getBounds().height;
                this.sArea.setBounds(x2, 0, widht2, height2);
            }
        }
    }

    private void moveAppointment(DayResource theResource, MouseEvent me) {
        ResourceAllocationBorder appointmentBorder = this.scheduler.getResAllBorderCon().getAppBorder();
        if (theResource == null || appointmentBorder == null || this.isCtrlPressed()) {
            return;
        }
        SchedulerTimePanel sTP = this.scheduler.getSchedulerTimePanel();
        if (this.scheduler.getResAllBorderCon().hasNoMovableResAll()) {
            this.setCursor(this.cursorNot);
            if (this.schedulerProperty.showDayBasedApp) {
                sTP.setCursor(this.cursorNot);
            }
            return;
        }
        this.setCursor(this.cursorMove);
        sTP.setCursor(this.cursorMove);
        int x = me.getX();
        int y = me.getY();
        if (appointmentBorder != null) {
            int appBordery = appointmentBorder.getBounds().y;
            int appBorderWidht = appointmentBorder.getBounds().width;
            int top = appBordery - 1;
            int appBorderHeight = appointmentBorder.getBounds().height;
            int bottom = top + appBorderHeight + 1;
            if (bottom > (int)this.schedulerProperty.currentHeightOfTimeScale) {
                return;
            }
            int yAtTime = this.calculateYForTimePanle(y);
            int leftBorder = x - appointmentBorder.getXRelativ();
            int xOfTimeScale = this.schedulerProperty.widthOfControl - this.schedulerProperty.widthOfScrollBar;
            int newY = yAtTime - 15;
            if (leftBorder + appBorderWidht > xOfTimeScale) {
                leftBorder = xOfTimeScale - appBorderWidht;
            }
            if (leftBorder < 0) {
                leftBorder = 1;
            }
            if (leftBorder + appBorderWidht <= xOfTimeScale && appointmentBorder != null) {
                ResourceAllocationBorder timeBorder = this.scheduler.getSchedulerTimePanel().getAppointmentBorder();
                if (this.isMouseOnTimeArea(y) && y != this.oldDragY) {
                    this.scrollTimePanle(timeBorder.getBounds(), newY);
                }
                ResourceAllocationBorderController aBC = this.scheduler.getResAllBorderCon();
                aBC.newBorderFromDay(x, y);
                if (!this.isMouseOnTimeArea(y)) {
                    aBC.setDayVisible(true);
                    if (aBC.getAppBorderDays().size() > 1) {
                        int difX = x - this.xOld;
                        int difY = y - this.yOld;
                        this.changeLocalistion(x, y, difX, difY);
                        this.xOld = x;
                        this.yOld = y;
                    } else {
                        newY = y - appointmentBorder.getYRelativ();
                        appointmentBorder.setBounds(leftBorder, newY, appBorderWidht, appBorderHeight);
                        appointmentBorder.setBorderRed();
                    }
                } else {
                    aBC.setDayVisible(false);
                }
            }
            if (this.isMouseOnTimeArea(y)) {
                int vieY = this.scheduler.getJScrollPaneScheduler().getViewport().getViewRect().y;
                if (yAtTime - 15 < vieY) {
                    this.setCursor(this.cursorNot);
                    sTP.setCursor(this.cursorMove);
                    this.setDayAppointmentInfo(x, theResource, false);
                    return;
                }
                sTP.changeResourceBackGround(this.calculateXForTimePanel(x));
                sTP.setTimeAppointmentInfo(this.calculateXForTimePanel(x), this.calculateYForTimePanle(y));
                theResource.setSelected(false);
            } else {
                this.setDayAppointmentInfo(x, theResource, true);
                sTP.resetResourceBackGround();
                this.changeResourceBackGround(theResource);
            }
        }
    }

    private void mouseMovedOnAvailability(Availability theAvailability, MouseEvent me, DayResource theResource) {
        String toolTip = this.helper.getDayDate(theAvailability.getColID(), theAvailability.getResID());
        if (toolTip != null) {
            this.showFollowingToolTip(toolTip, true, theAvailability.getToolTipFontName());
        }
    }

    private DayResource getResource(int x) {
        int x2 = x + 1;
        return this.getResource(x, this.getColumnID(x2));
    }

    public DayResource getResource(int x, String theColID) {
        if (this.scheduler.getResDayCon() == null || this.scheduler.getResDayCon().isEmpty()) {
            return null;
        }
        ArrayList<Resource> resources = this.scheduler.getResDayCon().getAllResource(theColID);
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        int theWidth = this.getBounds().width;
        if (x > theWidth) {
            x = theWidth - 2;
        }
        if (x < 1) {
            x = 2;
        }
        int size = resources.size();
        int i = 0;
        while (i < size) {
            DayResource resource = (DayResource)resources.get(i);
            int resX = resource.getBounds().x;
            if (x >= resX && x <= resX + resource.getBounds().width) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    protected void showFollowingToolTipForAppointment(String dayDate, DayResource resource) {
        StringBuffer descBuffer = new StringBuffer();
        Iterator<ResourceAllocation> it = this.scheduler.getResAllCon().getDayBasedResourceAllocation(resource.getResID(), resource.getColID()).iterator();
        descBuffer.append(dayDate);
        boolean first = true;
        while (it.hasNext()) {
            ResourceAllocation app = it.next();
            if (!first) {
                descBuffer.append("<br>");
            } else {
                first = false;
            }
            descBuffer.append(app.getToolTip());
        }
        descBuffer.append("<hr>");
        String htmlText = descBuffer.toString();
        this.scheduler.ground.showTipWindow(this.helper.buildTooltipText(htmlText, true, resource.getFontName()), this.getXForTooltip(this.mouseEvent.getX() + 10), this.getYForTooltip());
    }

    @Override
    protected void showTipWindow(String text) {
        this.scheduler.ground.showTipWindow(text, this.getXForTooltip(this.mouseEvent.getX() + 10), this.getYForTooltip());
    }

    @Override
    protected int getYForTooltip() {
        if (this.mouseEvent != null) {
            Rectangle rec = this.scheduler.getJScrollPaneDayBased().getViewport().getViewRect();
            return this.mouseEvent.getY() + 90 - rec.y;
        }
        return 81;
    }

    @Override
    public void hideTipWindow() {
        this.scheduler.ground.hideTipWindow();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        block20: {
            try {
                int x;
                super.mouseClicked(me);
                int newX = x = me.getX();
                int y = me.getY();
                if (!(this.getAreas() == null || this.getAreas().isEmpty() || this.isShiftPressed() || this.isMouseOverTimeArea(x, 5, this.getAreas()))) {
                    this.removeAreas(this.getAreas());
                    return;
                }
                if (this.scheduler.getSchedulerTimePanel() != null) {
                    this.scheduler.getSchedulerTimePanel().removeTimeAreas();
                }
                this.setMouseDragged(false);
                int button = me.getButton();
                int theWidth = this.getWidth();
                if (x > theWidth) {
                    newX = theWidth - 2;
                }
                DayResource resource = this.getResource(newX);
                int Xnew = newX - resource.getX();
                ResourceAllocation appointmentTemp = resource.getResourceAllocationAt(Xnew, y);
                if (!this.isCtrlPressed() && button != 3) {
                    if (this.scheduler.getResAllBorderCon().getAppBorder() != null && appointmentTemp == null) {
                        this.removeAllAppointmentBorder();
                    }
                    if (appointmentTemp == null) {
                        this.removeResAllSelection();
                        this.scheduler.getFoResAllCon().clear();
                        this.scheduler.getFoResAllKCon().clear();
                    }
                }
                if (button == 1) {
                    if (!this.myTimer.isRunning()) {
                        this.myTimer.start();
                    }
                    if (!this.isCtrlPressed()) {
                        ++this.clickCount;
                    }
                    Availability availabilty = resource.getAvailabilityDay();
                    if (this.clickCount > 1 && availabilty != null && !this.isCtrlPressed() && !this.isShiftPressed()) {
                        this.schedulerProperty.selectedSpecialTimeKey = availabilty.getKey();
                        this.doFireEvent = true;
                        this.schedulerProperty.xxTime = "0000";
                    } else {
                        this.currCursor = this.cursorWait;
                        this.ownCursor = true;
                        ResourceAllocation resAll = resource.getResourceAllocationAt(Xnew, y);
                        if (resAll != null && resAll.isSelectable() && !this.isCtrlPressed() && !this.isShiftPressed()) {
                            this.doFireEvent = true;
                            this.clickCount = 1;
                            this.unSelectAllResAllAndSelectTheResAll(resAll, resource, me);
                            this.schedulerProperty.focusedResouceAllocationKey = resAll.getKey();
                            this.schedulerProperty.xxTime = "0000";
                        }
                    }
                    break block20;
                }
                this.clickCount = 0;
                if (button != 3) break block20;
                if (!this.schedulerProperty.newMenu) {
                    this.mouseClicktRight(me);
                    break block20;
                }
                if (this.getAreas() != null && !this.getAreas().isEmpty() && this.isMouseOverTimeArea(x, 5, this.getAreas())) {
                    this.removeResAllSelectionFocus(appointmentTemp);
                    this.mouseClickedRight(me);
                    return;
                }
                ResourceAllocation appointment = resource.getResourceAllocationAt(Xnew, y);
                Availability availabilty = resource.getAvailabilityDay();
                if (appointment != null) {
                    if (this.scheduler.getFoResAllCon().getSize() > 1 && this.isResAllFocused(appointment)) {
                        this.mouseClickedRight(me);
                        return;
                    }
                    if (availabilty != null) {
                        this.schedulerProperty.selectedSpecialTimeKey = availabilty.getKey();
                    }
                    this.clearFocusedResAlls();
                    this.removeResAllSelectionFocus(appointmentTemp);
                    this.mouseClickedRightOnResAll(appointment, resource, me);
                    return;
                }
                if (availabilty != null) {
                    this.clearFocusedResAlls();
                    this.removeResAllSelectionFocus(appointmentTemp);
                    this.mouseClickedRightOnAvailability(availabilty, me);
                    break block20;
                }
                this.clearFocusedResAlls();
                this.removeResAllSelectionFocus(appointmentTemp);
                return;
            }
            catch (Exception ex) {
                this.helper.logThrowing("SchedulerDayPanel", "mouseClicked", ex);
                ex.printStackTrace(System.err);
                System.err.println(ex);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        try {
            SchedulerTimePanel sTP;
            super.mousePressed(me);
            this.schedulerProperty.popupOn = false;
            this.setCtrlPressed(me.isControlDown());
            this.setShiftPressed(me.isShiftDown());
            this.setTargetArea();
            int meX = me.getX();
            int meY = me.getY();
            if (this.getAreas() != null && !this.getAreas().isEmpty() && (!this.isMouseOverTimeArea(meX, 5, this.getAreas()) && me.getButton() == 3 || !this.isMouseOverTimeArea(meX, 5, this.getAreas()) && !this.isShiftPressed())) {
                this.removeAreas(this.getAreas());
            }
            if ((sTP = this.scheduler.getSchedulerTimePanel()) != null) {
                sTP.removeTimeAreas();
            }
            this.setMouseDragged(false);
            if (this.mouseButton == 3 || this.mouseButton == 2) {
                return;
            }
            this.mousePressedOnResAllFlag = false;
            DayResource resource = this.getResource(meX);
            if (this.isMouseOverTimeArea(meX, 5, this.getAreas())) {
                if (resource == null || this.sArea == null) {
                    return;
                }
                this.setInMulitAppMode(false);
                if (this.isShiftPressed()) {
                    this.mousePressedOnTimeArea(resource, this.sArea, me);
                    this.resizeDayArea(meX, meY, resource, false);
                }
                return;
            }
            ResourceAllocationBorderController aBC = this.scheduler.getResAllBorderCon();
            if (this.isShiftPressed()) {
                if (resource == null) {
                    return;
                }
                if (aBC != null) {
                    this.removeAllAppointmentBorder();
                }
                this.clearFocusedResAlls();
                if (this.sArea == null) {
                    int y1 = meY;
                    if (sTP != null) {
                        sTP.removeTimeAreas();
                    }
                    int areaX = resource.getX();
                    int areaWidth = resource.getWidth();
                    this.sArea = new TopArea(areaX, y1, areaWidth, this.schedulerProperty, 2);
                    this.sArea.setOpaque(true);
                    this.sArea.setBounds(areaX, y1, areaWidth, resource.getHeight());
                    this.add(this.sArea);
                    if (this.areas == null) {
                        this.areas = new ArrayList();
                    }
                    this.areas.add(this.sArea);
                    this.area = true;
                }
                this.resizeDayArea(meX, meY, resource, this.area);
                this.setCursor(this.cursorMove);
                this.area = false;
                return;
            }
            if (resource == null) {
                return;
            }
            int newX = meX - resource.getX();
            ResourceAllocation resAll = resource.getResourceAllocationAt(newX, meY);
            if (resAll != null && resAll.isSelectable()) {
                if (aBC.getResAllBorders() != null && aBC.getResAllBorders().size() > 0 && !this.isCtrlPressed() && !this.isInMulitAppMode() || !resAll.getHasBorder() && !this.isCtrlPressed()) {
                    this.removeAllAppointmentBorder();
                }
                if (me.getClickCount() == 1) {
                    FocusedResourceAllocatonsController fAC = this.scheduler.getFoResAllCon();
                    if (!this.isResAllFocused(resAll) && !this.isCtrlPressed() && fAC != null) {
                        int size = fAC.getSize();
                        int i = 0;
                        while (i < size) {
                            fAC.get(i).setSelected(false);
                            ++i;
                        }
                        fAC.clear();
                    }
                    if (fAC != null && !this.isCtrlPressed() && !this.isInMulitAppMode()) {
                        fAC.clear();
                    }
                    this.mousePressedOnAppointment(resource, (Appointment)resAll, me);
                } else if (aBC.getAppBorder() != null && !this.isCtrlPressed()) {
                    this.removeAllAppointmentBorder();
                }
            } else if (!(resAll == null || resAll.isSelectable() || this.isInMulitAppMode() || this.isCtrlPressed())) {
                this.removeAllAppointmentBorder();
                this.removeResAllSelectionFocus(null);
            } else if (resAll == null && !this.isInMulitAppMode() && !this.isCtrlPressed()) {
                this.removeAllAppointmentBorder();
                this.removeResAllSelectionFocus(null);
            }
        }
        catch (Exception ex) {
            this.helper.logThrowing("SchedulerDayPanel", "mousePressed", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        try {
            super.mouseReleased(me);
            int x = me.getX();
            int y = me.getY();
            this.setCursor(this.cursorDefault);
            this.scheduler.getSchedulerTimePanel().setCursor(this.cursorDefault);
            this.mousePressedOnResAllFlag = false;
            if (this.sArea != null && this.isMouseOverTimeArea(x, 5, this.getAreas()) || this.sArea != null && this.moveAreaMode) {
                if ((this.isShiftPressed() || this.resizeAreaMode) && me.getButton() != 3 && !this.moveAreaMode) {
                    this.mouseReleasedInDayAreaResize(me);
                    this.setSelAreas();
                    this.setBoundsImmediatelyForTimeArea(x);
                } else if (this.moveAreaMode) {
                    this.mouseReleasedOnDayAreaAtMoving(this.sArea, x, y);
                }
                this.resizeAreaMode = false;
                this.scheduler.getHeaderScheduler().showAppointmentInfo(false);
                return;
            }
            if (this.sArea != null && (this.isShiftPressed() || this.resizeAreaMode)) {
                this.setSelAreas();
            }
            if (this.scheduler.getResAllBorderCon().getAppBorder() != null) {
                if (this.isMouseDragged()) {
                    DayResource resource = this.getResource(x);
                    this.mouseReleasedInMoveMode(resource, me);
                    this.scheduler.getHeaderScheduler().showAppointmentInfo(false);
                } else {
                    this.setMouseDragged(false);
                }
            }
            if (this.resizeAreaMode) {
                this.resizeAreaMode = false;
            }
            if (this.moveAreaMode) {
                this.moveAreaMode = false;
            }
            this.scheduler.requestFocus();
            this.scheduler.requestFocusInWindow();
        }
        catch (Exception ex) {
            this.helper.logThrowing("SchedulerDayPanel", "mouseReleased", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        try {
            super.mouseDragged(me);
            int x = me.getX();
            int y = me.getY();
            if (x == this.oldDragX && y == this.oldDragY) {
                return;
            }
            if (this.mouseButton == 3 || this.mouseButton == 0 || this.mouseButton == 2) {
                return;
            }
            super.mouseDragged(me);
            if (this.isCtrlPressed()) {
                return;
            }
            DayResource resource = this.getResource(x);
            if (this.isShiftPressed() && this.sArea != null) {
                int widht = this.getSize().width;
                int count = 0;
                if (widht <= x) {
                    x = widht - 1;
                    count = -1;
                } else {
                    count = 1;
                }
                while (resource == null && x <= widht) {
                    resource = this.getResource(x);
                    x += count;
                }
                this.resizeDayArea(x, y, resource, false);
                this.setCursor(this.cursorDefault);
                return;
            }
            if (this.sArea != null && this.sArea.getResource() != null) {
                this.moveDayArea(resource, x, y, false);
                this.oldDragX = x;
                this.oldDragY = y;
                return;
            }
            this.setMouseDragged(true);
            if (this.mousePressedOnResAllFlag && !me.isControlDown()) {
                this.moveAppointment(resource, me);
            }
            this.oldDragX = x;
            this.oldDragY = y;
        }
        catch (Exception ex) {
            this.helper.logThrowing("SchedulerDayPanel", "mouseDragged", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
    }

    public void unselectAllAreas() {
        this.removeAreas(this.getAreas());
    }

    private void unSelectAllResAllAndSelectTheResAll(ResourceAllocation resAll, DayResource resource, MouseEvent me) {
        this.removeAllAppointmentBorder();
        if (!this.scheduler.getFoResAllCon().isEmpty()) {
            this.scheduler.getFoResAllCon().clear();
        }
        this.scheduler.getFoResAllKCon().clear();
        this.setInMulitAppMode(false);
        if (resAll instanceof Appointment) {
            this.mousePressedOnAppointment(resource, (Appointment)resAll, me);
        } else if (resAll instanceof Progress) {
            this.mousePressedOnProgress(resource, (Progress)resAll, me);
        }
    }

    protected void setSinglSelected(ResourceAllocation resAll, boolean showInfo) {
        if (!this.scheduler.getFoResAllCon().isEmpty()) {
            this.scheduler.getFoResAllCon().clear();
        }
        this.scheduler.getFoResAllCon().addfocusedResAll(resAll);
        this.mousePressedOnResAllFlag = true;
        this.schedulerProperty.resourceAllocationForManipulation = resAll;
        this.schedulerProperty.resourceAtAppDayMovement = (DayResource)this.getResourceForAppointmetnSelected();
        ResourceAllocationBorder appointmentBorder = new ResourceAllocationBorder(this.schedulerProperty, resAll);
        resAll.setSelected(true);
        this.add(appointmentBorder);
        this.xOld = appointmentBorder.getBounds().x;
        this.yOld = appointmentBorder.getBounds().y;
        this.scheduler.getResAllBorderCon().setOldXOldyFromDay(this.xOld, this.yOld);
        this.addEntryToFocusedResAllIDs(resAll);
        this.scheduler.getResAllBorderCon().addResAllBorderFromDay(appointmentBorder, appointmentBorder.getBounds(), this.xOld, this.yOld);
        resAll.setHasBorder(true);
        resAll.setResourceAllocationBorder(appointmentBorder);
        this.repaint();
        if (showInfo) {
            this.setDayAppointmentInfo(appointmentBorder.getBounds().x);
        }
    }

    private void resizeDayArea(int x, int y, DayResource theResource, boolean isClick) {
        this.resizeAreaMode = true;
        this.schedulerProperty.selectedMarkKey = "";
        this.schedulerProperty.selectedSpecialTimeKey = "";
        this.setBoundsImmediatelyForTimeArea(x);
        this.invalidate();
        this.repaint();
        if (theResource != null) {
            this.setHeaderInfoForArea(x, this.sArea.getXAtConstruction());
        } else {
            this.scheduler.getHeaderScheduler().showAppointmentInfo(false);
        }
    }

    private void mouseReleasedInDayAreaResize(MouseEvent me) {
        int x = this.sArea.getBounds().x + 2;
        int widht = x + this.sArea.getBounds().width;
        DayResource resource = null;
        while (x <= widht) {
            resource = this.getResource(x);
            if (resource != null) {
                x += resource.getBounds().width;
            }
            ++x;
        }
    }

    public void setCurrentMarkedResource(DayResource currentMarkedResource) {
        this.currentMarkedResource = currentMarkedResource;
    }

    private void changeResourceBackGround(DayResource theResource) {
        if (theResource != null && theResource.getBackground() != this.schedulerProperty.colorOfResourceAtAppmntMovement) {
            this.schedulerProperty.resourceAtAppDayMovement.setSelected(false);
            theResource.setSelected(true);
            this.currentMarkedResource = theResource;
            this.setResourceMarked(true);
            this.schedulerProperty.resourceAtAppDayMovement = theResource;
            this.scheduler.getDayScale().repaint();
        }
    }

    public void changResourceBackGround(int x) {
        this.changeResourceBackGround(this.getResourceForTimeX(x));
    }

    @Override
    public void resetResourceBackGround() {
        if (this.schedulerProperty.resourceAtAppDayMovement != null) {
            this.schedulerProperty.resourceAtAppDayMovement.setSelected(false);
        }
    }

    private void setDayAppointmentInfo(int x, DayResource theResource, boolean not) {
        Object day = this.getDayObjectAtX(x);
        if (this.isAvailable(theResource) && not) {
            if (day != null) {
                this.setHeaderInfo(day.toString(), day.toString(), this.schedulerProperty.resourceAllocationForManipulation.getBackGround());
            }
        } else if (day != null) {
            this.setHeaderInfo(day.toString(), day.toString(), this.schedulerProperty.colorBackgrClose);
            this.setCursor(this.cursorNot);
            this.scheduler.getSchedulerTimePanel().setCursor(this.cursorNot);
        }
        this.scheduler.getHeaderScheduler().repaint();
    }

    private void setHeaderInfo(String from, String to, Color color) {
        this.scheduler.getHeaderScheduler().setAppointmentInfo(from, to, color);
        this.scheduler.getHeaderScheduler().showAppointmentInfo(true);
    }

    private void setHeaderInfoForArea(int first, int last) {
        if (first > last) {
            int copy = first;
            first = last;
            last = copy;
        }
        Object day = this.getDayObjectAtX(first);
        Object day2 = this.getDayObjectAtX(last);
        if (day != null && day2 != null) {
            this.setHeaderInfo(day.toString(), day2.toString(), this.schedulerProperty.colorBackgrClose);
        } else {
            this.scheduler.getHeaderScheduler().showAppointmentInfo(false);
        }
    }

    public void setDayAppointmentInfo(int x) {
        int x2 = x - 1;
        this.setDayAppointmentInfo(x2, this.getResourceForTimeX(x), true);
    }

    private void setAppToDayResource(DayResource dayResource) {
        if (dayResource == null || !dayResource.isAvailabilities()) {
            return;
        }
        dayResource.clearNewApps();
        for (ResourceAllocationBorder appBo : this.scheduler.getResAllBorderCon().getResAllBorders()) {
            ResourceAllocation resAll = appBo.getResourceAllocation();
            String colID = resAll.getColID();
            String resID = resAll.getResID();
            boolean dayBased = resAll.isDayBased();
            resAll.setTimeFrom("");
            resAll.setTimeTo("");
            resAll.setTimeFromInt(0);
            resAll.setTimeToInt(0);
            resAll.setDayBased(true);
            resAll.setReallyOrVirtualAdded(false);
            resAll.setColID(dayResource.getColID());
            resAll.setResID(dayResource.getResID());
            Resource res = dayBased ? this.scheduler.getResDayCon().getResource(colID, resID) : this.scheduler.getResCon().getResource(colID, resID);
            this.scheduler.removeResourceAllocation(res, resAll);
            this.scheduler.addResourceAllocation(dayResource, resAll);
            dayResource.addNewAppsForControl(resAll);
            ResourceAllocationController appCon = this.scheduler.getResAllCon();
            if (dayBased) {
                res.setResourceAllocations(appCon.getDayBasedResourceAllocation(res.getResID(), res.getColID()));
            } else {
                res.setResourceAllocations(appCon.getTimeBasedResourceAllocation(res.getResID(), res.getColID()));
            }
            res.setSelected(false);
            this.scheduler.getCorrespondingResourceAllocations(res.getResourceAllocations());
            res.setResourceAllocations();
            dayResource.setResourceAllocations(appCon.getDayBasedAppointments(dayResource.getResID(), dayResource.getColID()));
            this.scheduler.getCorrespondingResourceAllocations(dayResource.getResourceAllocations());
            dayResource.setResourceAllocations();
        }
        dayResource.setSelected(false);
        this.setTargetArea();
        JViewport vP = this.scheduler.getJScrollPaneDayBased().getViewport();
        int oldFisY = vP.getViewPosition().y;
        int oldFisH = vP.getVisibleRect().height;
        int newFisY = dayResource.getYOfFirstNewResAll();
        int newFisH = dayResource.getHeightOfFirstNewResAll() + newFisY;
        newFisY -= oldFisY;
        if (newFisH < oldFisH) {
            newFisY = 0;
        }
        vP.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        if (oldFisY < newFisY) {
            vP.scrollRectToVisible(new Rectangle(0, newFisY += this.schedulerProperty.heightOfAppDayBased, 0, 0));
        } else {
            vP.scrollRectToVisible(new Rectangle(0, newFisY, 0, 0));
        }
        this.fireTimeChangeEvent(dayResource, null, 5, 5);
    }

    public void setAppToDayResource(int x) {
        this.setAppToDayResource(this.getResourceForTimeX(x));
    }

    private DayResource getResourceForTimeX(int x) {
        int x2 = x - 1;
        return this.getResource(x2);
    }

    private int calculateYForTimePanle(int y) {
        int viewY = 0;
        JViewport vP = this.scheduler.getJScrollPaneDayBased().getViewport();
        if (this.schedulerProperty.dayBasedMode.equals("2")) {
            viewY = vP.getViewPosition().y;
        }
        int viewYTime = vP.getViewPosition().y;
        return y - this.schedulerProperty.heightOfDayBased + viewYTime - viewY + this.scheduler.getJScrollPaneScheduler().getViewport().getViewRect().y;
    }

    private int calculateXForTimePanel(int x) {
        return x;
    }

    @Override
    protected void setSelectedAppBorder(ResourceAllocationBorder appointmentBorder, MouseEvent me) {
        this.mousePressedOnResAllFlag = true;
        ResourceAllocationBorderController aBC = this.scheduler.getResAllBorderCon();
        aBC.setAppBorder(appointmentBorder);
        this.xOld = me.getX();
        this.yOld = me.getY();
        aBC.setOldXOldyFromDay(this.xOld, this.yOld);
    }

    @Override
    public void addBorder(ResourceAllocationBorder appBorder, Rectangle rec) {
        if (appBorder == null) {
            return;
        }
        this.add(appBorder);
        appBorder.setBounds(rec);
        appBorder.setVisible(true);
    }

    private boolean isMouseOnTimeArea(int y) {
        int visibleHeight = 0;
        visibleHeight = this.schedulerProperty.dayBasedMode.equalsIgnoreCase("2") ? this.schedulerProperty.heightOfDayBased + this.scheduler.getJScrollPaneDayBased().getViewport().getViewPosition().y : this.schedulerProperty.heightOfDayBased;
        return y > visibleHeight;
    }

    private void scrollTimePanle(Rectangle rec, int newY) {
        if (this.scheduler.getJScrollPaneScheduler() != null) {
            DefaultJScrollPane sp = this.scheduler.getJScrollPaneScheduler();
            int spY = sp.getViewport().getViewRect().y;
            int y = newY;
            int spHeight = sp.getViewport().getHeight();
            int y2 = newY + rec.height;
            int a = spY - 10;
            int b = spY + 10;
            if (y > a && y < b) {
                this.scheduler.getJScrollPaneScheduler().getViewport().scrollRectToVisible(new Rectangle(0, -100, 0, 0));
                return;
            }
            int spY2 = sp.getHeight() + spY;
            if (rec.height > spHeight) {
                y2 = newY + 15;
            }
            if (y2 > spY2) {
                int increment = sp.getVerticalScrollBar().getBlockIncrement() + spHeight;
                sp.getViewport().scrollRectToVisible(new Rectangle(0, increment, 0, 0));
            }
        }
    }

    @Override
    protected String getSpTKeyAt(int x, int y, Resource resource) {
        if (resource.getAvailability() != null && !resource.getAvailability().isEmpty()) {
            Availability ava = resource.getAvailability().get(0);
            return ava != null ? ava.getKey() : "";
        }
        return "";
    }

    @Override
    protected void setTargetArea() {
        this.schedulerProperty.functionRaistAt = 2;
    }

    public void setNewHeightToDayBorder(int height) {
        Component[] comp = this.getComponents();
        int size = this.getComponentCount();
        int i = 0;
        while (i < size) {
            Rectangle rec;
            Component compSing = comp[i];
            if (this.schedulerProperty.dayBasedMode.equalsIgnoreCase("1") && compSing instanceof ResourceAllocationBorder) {
                ResourceAllocationBorder appBorder = (ResourceAllocationBorder)compSing;
                rec = appBorder.getBounds();
                appBorder.setBounds(rec.x, rec.y, rec.width, height - 5);
            }
            if (compSing instanceof TopArea) {
                TopArea ta = (TopArea)compSing;
                rec = ta.getBounds();
                if (this.schedulerProperty.dayBasedMode.equalsIgnoreCase("1")) {
                    ta.setBounds(rec.x, rec.y, rec.width, height - 5);
                } else if (rec.height < height - 5) {
                    ta.setBounds(rec.x, rec.y, rec.width, height - 5);
                }
            }
            ++i;
        }
    }

    private void moveDayArea(DayResource theResource, int x, int y, boolean isFromTime) {
        if (theResource == null) {
            this.scheduler.getHeaderScheduler().showAppointmentInfo(false);
            return;
        }
        this.setCursor(this.cursorMove);
        if (this.schedulerProperty.showDayBasedApp) {
            this.scheduler.getSchedulerDayPanel().setCursor(this.cursorMove);
        }
        if (this.isMouseOnTimeArea(y)) {
            return;
        }
        int leftBorder = theResource.getBounds().x;
        int xOfTimeScale = this.schedulerProperty.widthOfControl - this.schedulerProperty.widthOfScrollBar;
        if (leftBorder < 1) {
            leftBorder = 1;
        }
        if (leftBorder + this.sArea.getBounds().width > xOfTimeScale) {
            leftBorder = xOfTimeScale - this.sArea.getBounds().width;
        }
        if (leftBorder >= 0 && leftBorder + this.sArea.getBounds().width <= xOfTimeScale) {
            this.sArea.setBounds(leftBorder, 0, theResource.getBounds().width, this.sArea.getBounds().height);
            this.moveAreaMode = true;
            if (this.sArea.getSelArea() != null || isFromTime) {
                this.setHeaderInfoForArea(x, x);
                this.scheduler.getHeaderScheduler().showAppointmentInfo(true);
            }
        }
    }

    @Override
    protected SelArea getSelArea(Resource theResource, TopArea dayArea, boolean decrement) {
        if (theResource == null) {
            return null;
        }
        SelArea selArea = null;
        int timeFromInt = 0;
        String timeFromString = this.helper.getTimeOfMinutes(timeFromInt);
        selArea = new SelArea(theResource.getResID(), timeFromString, 0, 2, this.helper);
        return selArea;
    }

    @Override
    protected ArrayList<SelArea> getSelAreas(TopArea dayArea, boolean decrement) {
        ArrayList<SelArea> selAreas = new ArrayList<SelArea>();
        SelArea selArea = null;
        int x1 = dayArea.getBounds().x + 2;
        int x2 = x1 + dayArea.getBounds().width - 4;
        DayResource resource = null;
        DayResource resourceSave = null;
        int i = x1;
        while (i <= x2) {
            resource = this.getResource(i);
            i += resource.getWidth();
            if (resource != resourceSave) {
                selArea = new SelArea(resource.getResID(), "0000", 0, 2, this.helper);
                selAreas.add(selArea);
                resourceSave = resource;
            }
            ++i;
        }
        if (selAreas.isEmpty()) {
            selAreas = null;
        }
        return selAreas;
    }

    private void mouseReleasedOnDayAreaAtMoving(TopArea theDayArea, int x, int y) {
        DayResource resource = this.getResource(x);
        if (resource == null) {
            this.scheduler.getHeaderScheduler().showAppointmentInfo(false);
            return;
        }
        if (this.isMouseOnTimeArea(y)) {
            this.removeAreas(this.getAreas());
            return;
        }
        theDayArea.setResource(resource);
        this.sArea.setBounds(resource.getBounds().x, 0, resource.getBounds().width, this.sArea.getBounds().height);
        SelArea selArea = this.getSelArea(this.sArea.getResource(), theDayArea, false);
        if (selArea != null) {
            if (this.schedulerProperty.focusedAreas == null) {
                this.schedulerProperty.focusedAreas = new TreeMap();
            }
            if (!this.schedulerProperty.focusedAreas.isEmpty()) {
                this.schedulerProperty.focusedAreas.clear();
            }
            this.addSelArea(this.schedulerProperty.focusedAreas, selArea, this.sArea.getResource().getResID());
            this.schedulerProperty.functionCode = this.schedulerProperty.functionCodeForMovingTimeArea;
            this.setTargetArea();
            this.helper.fireEvent(-2570);
        }
    }

    public void removeDayAreas() {
        this.removeAreas(this.getAreas());
    }

    public void setVisibleAreas(boolean is) {
        if (this.sArea != null) {
            this.sArea.setVisible(is);
        }
    }

    private void removeAllAppointmentBorder() {
        this.scheduler.getResAllBorderCon().removeAll();
    }

    protected void setResourceAllocationBorder(ResourceAllocation resAll, Resource resource, int x, int y, boolean noClear) {
        this.setResourceAllocationBorder(resAll, resource, false, x, y);
        if (this.scheduler.getResAllBorderCon().getAppBorder() != null) {
            this.scheduler.getResAllBorderCon().getAppBorder().setRelativ(x, y);
        }
        FocusedResourceAllocatonsController fAC = this.scheduler.getFoResAllCon();
        if (!this.isCtrlPressed() && noClear) {
            fAC.clear();
        }
        if (fAC.contains(resAll)) {
            fAC.remove(resAll);
        }
        fAC.addfocusedResAll(resAll);
        if (this.isCtrlPressed() && this.scheduler.getFoResAllKCon().getSize() > 1) {
            this.setInMulitAppMode(true);
        }
        this.mousePressedOnResAllFlag = true;
        this.schedulerProperty.resourceAllocationForManipulation = resAll;
        this.schedulerProperty.resourceAtAppDayMovement = this.getResource(x);
    }

    public void setResourceAllocationBorder(ResourceAllocation resAll, boolean noClear) {
        Resource resource = this.scheduler.getResDayCon().getResource(resAll.getColID(), resAll.getResID());
        int x = resource.getX() + resAll.getX();
        int y = resAll.getY();
        this.setResourceAllocationBorder(resAll, resource, x, y, noClear);
    }

    @Override
    protected void changeLocalistionOfAppointmentBorder(ResourceAllocationBorder appBorder, int x, int y, int difX, int difY) {
        int height = 10;
        height = this.schedulerProperty.dayBasedMode.equals("2") ? this.schedulerProperty.heightOfAppDayBased : this.schedulerProperty.heightOfDayBased;
        appBorder.setBorderRed();
        Rectangle rec = appBorder.getBounds();
        rec.y = y - 20;
        rec.x += difX;
        appBorder.setBounds(rec.x, rec.y, rec.width, height);
    }

    public void resetResourceBackGround(int x) {
        DayResource res = this.getResource(x);
        if (res != null) {
            res.setSelected(false);
        }
    }

    public void moveTimeAreaInDayArea(int x) {
        DayResource res = this.getResource(x);
        if (res != null) {
            if (this.sArea == null) {
                this.sArea = new TopArea(0, x, res.getWidth(), this.schedulerProperty, 1);
                this.sArea.setOpaque(true);
                this.sArea.setBounds(this.sArea.getXAtConstruction(), this.sArea.getYAtConstruction(), res.getWidth(), res.getHeight());
                this.area = true;
                this.add(this.sArea);
            }
            this.sArea.setVisible(true);
            this.moveDayArea(res, x, 0, true);
        }
    }

    public void mouseReleasedOnTimeAreaMovingInDayArea(int x) {
        DayResource resource = this.getResource(x);
        if (resource == null) {
            this.scheduler.getHeaderScheduler().showAppointmentInfo(false);
            return;
        }
        this.sArea.setResource(resource);
        this.sArea.setBounds(resource.getBounds().x, 0, resource.getBounds().width, this.sArea.getBounds().height);
        SelArea selArea = new SelArea(resource.getResID(), "0000", 0, 2, this.helper);
        if (this.schedulerProperty.focusedAreas == null) {
            this.schedulerProperty.focusedAreas = new TreeMap();
        } else if (!this.schedulerProperty.focusedAreas.isEmpty()) {
            this.schedulerProperty.focusedAreas.clear();
        }
        this.addSelArea(this.schedulerProperty.focusedAreas, selArea, resource.getResID());
        this.schedulerProperty.functionCode = this.schedulerProperty.functionCodeForMovingTimeArea;
        this.setTargetArea();
        this.helper.fireEvent(-2570);
    }

    @Override
    protected int getYAbsoulut(int y) {
        Rectangle rec = this.scheduler.getJScrollPaneDayBased().getViewport().getViewRect();
        y = y - rec.y + 80;
        return y;
    }

    private void mouseClicktRight(MouseEvent me) {
        this.moveAreaMode = false;
        int x = me.getX();
        int y = me.getY();
        DayResource resource = this.getResource(x);
        this.setTargetArea();
        int Xnew = x - resource.getX();
        ResourceAllocation resAllTemp = resource.getResourceAllocationAt(Xnew, y);
        if (this.getAreas() != null && !this.getAreas().isEmpty() && this.isMouseOverTimeArea(x, 5, this.getAreas())) {
            this.removeResAllSelectionFocus(resAllTemp);
            this.createPopupMenu(this.schedulerProperty.functionCodeForDayArea, null, null, me);
            return;
        }
        ResourceAllocation resAll = resource.getResourceAllocationAt(Xnew, y);
        Availability availabilty = resource.getAvailabilityDay();
        if (resAll != null) {
            if (this.scheduler.getFoResAllCon() != null && this.scheduler.getFoResAllCon().getSize() > 1 && this.isResAllFocused(resAll)) {
                this.moreAppMenuMode = true;
                if (this.scheduler.getFoResAllCon().isATimeBasedAppIn()) {
                    this.createPopupMenu(this.schedulerProperty.functionCodeForMoreFocusedAppointmentsTimeDay, null, null, me);
                } else {
                    this.createPopupMenu(this.schedulerProperty.functionCodeForMoreFocusedAppointmentsDay, null, null, me);
                }
                return;
            }
            resAll.setMenuID2(null);
            resAll.setMenuID3(null);
            if (availabilty != null) {
                this.schedulerProperty.selectedSpecialTimeKey = availabilty.getKey();
                resAll.setMenuID2(availabilty.getMenuID());
            }
            this.clearFocusedResAlls();
            this.removeResAllSelectionFocus(resAllTemp);
            this.mouseClickedRightOnResAll(resAll, resource, me);
            return;
        }
        if (availabilty == null) {
            this.clearFocusedResAlls();
            this.removeResAllSelectionFocus(resAllTemp);
            return;
        }
        availabilty.setMenuID2(null);
        availabilty.setMenuID3(null);
        this.clearFocusedResAlls();
        this.removeResAllSelectionFocus(resAllTemp);
        this.mouseClickedRightOnAvailability(availabilty, me);
    }
}

