/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.lines;

import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.TimeObject;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

public class LinePanel
extends TimeObject {
    private static final long serialVersionUID = 9180664245843010369L;
    protected Color lineColor = Color.GREEN;
    private SchedulerProperty schedulerProperty;
    protected ArrayList<Line> lines = null;

    public LinePanel(String theColID, String theResID, String theKey, String theTimeFrom, int theDuration, String theLineColor, SchedulerProperty theSchedulerProperty, Helper theHelper) throws Exception {
        super(theColID, theResID, theKey, theTimeFrom, theDuration, theLineColor, theHelper);
        this.setOpaque(false);
        this.lineColor = this.getBackGround();
        this.setDoubleBuffered(true);
        this.schedulerProperty = theSchedulerProperty;
        int i = this.schedulerProperty.beginShowDay;
        ++i;
    }

    public LinePanel(String theColID, String theResID, String theKey, String theTimeFrom, int theDuration, String theLineColorString, Color theLineColor, SchedulerProperty theSchedulerProperty, Helper theHelper) throws Exception {
        super(theColID, theResID, theKey, theTimeFrom, theDuration, theLineColorString, theLineColor, theHelper);
        this.setOpaque(false);
        this.lineColor = theLineColor;
        this.setDoubleBuffered(true);
        this.schedulerProperty = theSchedulerProperty;
        int i = this.schedulerProperty.beginShowDay;
        ++i;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.lines == null || this.lines.size() == 0) {
            return;
        }
        Color saveCol = g.getColor();
        g.setColor(this.lineColor);
        for (Line l : this.lines) {
            g.drawLine(l.x1, l.y1, l.x2, l.y2);
        }
        g.setColor(saveCol);
    }

    public void setLines() {
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        if (width > 0 && height > 0) {
            if (this.lines != null) {
                this.lines.clear();
            }
            this.lines = new ArrayList();
            int distance = height / 5;
            int neigung = width / 3;
            if (distance < 5) {
                distance = 5;
            } else if (distance > 20) {
                distance = 20;
            }
            int heightForPainting = -neigung;
            if (height < width) {
                height = width;
            }
            int j = 0;
            while (j < height) {
                Line line = new Line(0, heightForPainting + neigung, width, heightForPainting);
                this.lines.add(line);
                heightForPainting += distance;
                ++j;
            }
        }
    }

    @Override
    public void free() {
        super.free();
        this.lineColor = null;
        this.schedulerProperty = null;
        this.lines = null;
    }

    class Line {
        protected int x1;
        protected int x2;
        protected int y1;
        protected int y2;

        public Line(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
        }
    }
}

