/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.gui.resource.time;

import at.tsa.ishmed.appmntmgmnt.Flag;
import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.resource.Resource;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.TimeObject;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.avaliability.Availability;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.lines.LinePanel;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.SpecialTime;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.appointmentOffer.AppointmentOffer;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.CorrespondigResourceAllocations;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.ResourceAllocation;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.ResourceAllocationController;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.topPanel.timePanel.MarkSlot;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.DefaultPanel;
import at.tsa.ishmed.appmntmgmnt.scheduler605.gui.timeLine.TimeLine;
import at.tsa.ishmed.appmntmgmnt.scheduler605.gui.timeLine.TimeLines;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JLabel;

public class TimeResource
extends Resource {
    private static final long serialVersionUID = -726639721969087150L;
    protected ArrayList<Availability> availabilities;
    protected ArrayList<SpecialTime> specialTimes;
    protected ArrayList<SpecialTime> specialTimesForMark;
    protected ArrayList<AppointmentOffer> appointmentOffers;
    private ArrayList<JLabel> allTimeSlots = new ArrayList();
    protected MarkSlot markSlot;
    protected boolean markSlotSetted;
    private DefaultPanel avalPanel = null;
    private DefaultPanel spezPanel = null;
    private DefaultPanel offerPanel = null;
    boolean ok = true;
    String url = "/at/tsa/ishmed/appmntmgmnt/scheduler/images/";

    public TimeResource(String theColID, String theResID, String theOrgID, String theDescription, int theTimeScale, String theBackGroundColor, String theFontName, int theFontSize, String theFontBold, String theFontItalic, String theFontColor, String theToolTipText, Scheduler scheduler) {
        super(theColID, theResID, theOrgID, theDescription, theTimeScale, theBackGroundColor, theFontName, theFontSize, theFontBold, theFontItalic, theFontColor, theToolTipText, scheduler);
        this.initComponents();
    }

    public TimeResource(TimeResource timeResource) {
        this(timeResource.getColID(), timeResource.getResID(), timeResource.getOrgID(), timeResource.getDescription(), timeResource.getTimeScale(), timeResource.getBackGroundColorString(), timeResource.getFontName(), timeResource.getFontSize(), timeResource.getFontBold(), timeResource.getFontItalic(), timeResource.getFontColorString(), timeResource.getToolTipText(), timeResource.scheduler);
    }

    public void removeTimeSlots() {
        this.getHelper().logEntering("TimeResource", "removeTimeSolts");
        if (this.allTimeSlots == null || this.allTimeSlots.isEmpty()) {
            this.getHelper().logInfo("TimeResource: end removeTimeSlots, allTimeSlots is null or empty");
            return;
        }
        if (this.markSlot == null) {
            return;
        }
        int size = this.allTimeSlots.size();
        int i = 0;
        while (i < size) {
            this.markSlot.remove(this.allTimeSlots.get(i));
            ++i;
        }
        this.getHelper().logExiting("TimeResource", "removeTimeSlots");
    }

    public void setTimeSlotBar() {
        this.helper.logEntering("TimeResource", "setTimeSlotBar");
        if (this.markSlot == null) {
            return;
        }
        this.allTimeSlots.clear();
        int size = this.appointmentOffers.size();
        int j = 0;
        while (j < size) {
            SpecialTime specialTime = this.appointmentOffers.get(j);
            JLabel timeSlot = new JLabel();
            timeSlot.setBackground(specialTime.getBackground());
            timeSlot.setOpaque(true);
            timeSlot.setFocusable(Flag.focus);
            timeSlot.setRequestFocusEnabled(Flag.reFou);
            timeSlot.setBounds(0, specialTime.getTimeFromPix(), this.markSlot.getBounds().width, specialTime.getTimeToPix() - specialTime.getTimeFromPix() + 1);
            this.markSlot.add(timeSlot);
            this.allTimeSlots.add(timeSlot);
            ++j;
        }
        this.helper.logEntering("TimeResource", "setTimeSlotBar");
    }

    public void setAvailabilities() {
        this.getHelper().logEntering("TimeResource", "setAvailabilities");
        this.setObjects(this.availabilities, 1);
        this.getHelper().logExiting("TimeResource", "setAvailabilities");
    }

    public void setSpecialTimes() {
        this.helper.logEntering("TimeResource", "setSpecialTimes");
        this.setObjects(this.specialTimes, 2);
        this.helper.logExiting("TimeResource", "setSpecialTimes");
    }

    public void setAppointmentOffers() {
        this.helper.logEntering("TimeResource", "setAppointmentOffers");
        this.setObjects(this.appointmentOffers, 3);
        this.helper.logExiting("TimeResource", "setAppointmentOffers");
    }

    public void setMarkSlot() {
        this.helper.logEntering("TimeResource", "setMarkSlot");
        this.markSlot = new MarkSlot(this.resID);
        int widthOfMarkSlot = (int)((double)this.getBounds().width * 0.1);
        int maxWidth = 200 / this.schedulerProperty.twipsPerPixel;
        if (widthOfMarkSlot > maxWidth) {
            widthOfMarkSlot = maxWidth;
        }
        this.markSlot.setBounds(0, 0, widthOfMarkSlot, this.getBounds().height);
        this.add((Component)this.markSlot, Resource.MARKS_LAYER);
        this.markSlotSetted = true;
        this.selectPane.setBounds(widthOfMarkSlot, 0, this.getBounds().width, this.getBounds().height);
        this.helper.logExiting("TimeResource", "setMarkSlot");
    }

    public void setSpecialTimesForMark() {
        this.helper.logEntering("TimeResource", "setSpecialTimesForMark");
        if (this.markSlot == null) {
            return;
        }
        this.setObjects(this.specialTimesForMark, 5);
        this.helper.logExiting("TimeResource", "setSpecialTimesForMark");
    }

    @Override
    protected void setObjects(ArrayList theArrayList, int theType) {
        try {
            this.helper.logEntering("TimeResource", "setObjects");
            if (theArrayList == null) {
                this.helper.logInfo("TimeResource: setObjects, theArrayList is null");
                return;
            }
            try {
                int size = theArrayList.size();
                this.helper.logInfo("TimeResource: setObjects theArrayList has size=" + size);
                int i = 0;
                while (i < size) {
                    TimeObject timeBaseObject = (TimeObject)theArrayList.get(i);
                    int timeFromTemp = timeBaseObject.getMinTimeFromInt();
                    int timeToTemp = timeBaseObject.getMinTimeToInt();
                    boolean decrementOne = false;
                    if (timeToTemp >= this.schedulerProperty.limitEndTime) {
                        decrementOne = true;
                    }
                    Rectangle y1Y2 = this.helper.getRecPoint(timeFromTemp, timeToTemp);
                    int y1 = y1Y2.x;
                    int y2 = y1Y2.y;
                    int timeHeight = y1Y2.height;
                    timeBaseObject.setTimeScale(this.timeScale);
                    timeBaseObject.setTimeFromPix(y1);
                    timeBaseObject.setTimeToPix(y2);
                    if (theType == 4) {
                        if (!((ResourceAllocation)timeBaseObject).isDayBased()) {
                            this.setObjectAvailability((ResourceAllocation)timeBaseObject);
                            if (!((ResourceAllocation)timeBaseObject).isReallyOrVirtualAdded()) {
                                ArrayList<ResourceAllocation> correspondingAppointments = ((ResourceAllocation)timeBaseObject).getCorrespondigAllocations();
                                if (correspondingAppointments != null && !correspondingAppointments.isEmpty()) {
                                    int sizeApp = correspondingAppointments.size();
                                    if (sizeApp > 1) {
                                        this.allResAlls.clear();
                                        this.getAllCorrespondingArrayLists(correspondingAppointments);
                                        this.allResAlls = this.sortAllCorrespondingArrayLists();
                                        correspondingAppointments = this.allResAlls;
                                        ((ResourceAllocation)timeBaseObject).setCorrespondigAllocations(new ArrayList<ResourceAllocation>(this.allResAlls));
                                    }
                                    Collections.sort(correspondingAppointments);
                                    int x = 0;
                                    if (this.markSlotSetted && this.markSlot != null) {
                                        x = this.markSlot.getBounds().width + 1;
                                    }
                                    this.calculateCorrespApp(correspondingAppointments, x, this.getBounds().width - x + 1);
                                } else {
                                    int x = 0;
                                    if (this.markSlotSetted && this.markSlot != null) {
                                        x = this.markSlot.getBounds().width + 1;
                                    }
                                    correspondingAppointments = new ArrayList();
                                    correspondingAppointments.add((ResourceAllocation)timeBaseObject);
                                    this.calculateCorrespApp(correspondingAppointments, x, this.getBounds().width - x + 1);
                                }
                            }
                        }
                    } else {
                        int x = 0;
                        int widhtToUse = this.getWidth() + 1;
                        if (theType == 5) {
                            timeBaseObject.setBorder(null);
                            if (timeBaseObject instanceof SpecialTime) {
                                SpecialTime sTime = (SpecialTime)timeBaseObject;
                                sTime.setShowDescription(false);
                                sTime.setPaintBorderLine(true);
                            }
                            --x;
                            if (decrementOne) {
                                timeBaseObject.setBounds(x, y1, this.markSlot.getBounds().width + 2, timeHeight);
                            } else {
                                timeBaseObject.setBounds(x, y1, this.markSlot.getBounds().width + 2, timeHeight + 1);
                            }
                            this.markSlot.add(timeBaseObject);
                        } else {
                            --x;
                        }
                        if (theType == 3) {
                            if (timeBaseObject instanceof AppointmentOffer) {
                                AppointmentOffer appOffer = (AppointmentOffer)timeBaseObject;
                                if (this.markSlotSetted && this.markSlot != null) {
                                    appOffer.setDescriptionStartAt(this.markSlot.getBounds().width);
                                }
                            }
                            if (decrementOne) {
                                this.offerPanel.add(timeBaseObject);
                                timeBaseObject.setBounds(x, y1, widhtToUse, timeHeight);
                            } else {
                                this.offerPanel.add(timeBaseObject);
                                timeBaseObject.setBounds(x, y1, widhtToUse, timeHeight + 1);
                            }
                        } else {
                            if (this.markSlotSetted && this.markSlot != null) {
                                x = this.markSlot.getBounds().width;
                                widhtToUse = widhtToUse - x - 1;
                            }
                            --x;
                            if (theType == 2) {
                                if (decrementOne) {
                                    this.spezPanel.add(timeBaseObject);
                                    timeBaseObject.setBounds(x, y1, widhtToUse + 1, timeHeight);
                                } else {
                                    this.spezPanel.add(timeBaseObject);
                                    timeBaseObject.setBounds(x, y1, widhtToUse + 1, timeHeight + 1);
                                }
                            } else if (theType == 1) {
                                if (decrementOne) {
                                    this.avalPanel.add(timeBaseObject);
                                    timeBaseObject.setBounds(x, y1, widhtToUse, timeHeight);
                                } else {
                                    this.avalPanel.add(timeBaseObject);
                                    timeBaseObject.setBounds(x, y1, widhtToUse, timeHeight + 1);
                                }
                            } else if (theType == 6) {
                                timeBaseObject.setBounds(x, y1, widhtToUse + 1, timeHeight);
                                ((LinePanel)timeBaseObject).setLines();
                                this.add((Component)timeBaseObject, Resource.LINEPANE_LAYER);
                            } else if (theType == 8) {
                                TimeLine tl = (TimeLine)timeBaseObject;
                                tl.setBounds(0, y1, this.getWidth() + 1, tl.getThickness());
                                this.add((Component)tl, Resource.TIMELINEPANE_LAYER);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                this.helper.logThrowing("TimeResource", "setObjects", ex);
                ex.printStackTrace(System.err);
                System.err.println(ex);
            }
        }
        finally {
            this.helper.logExiting("TimeResource", "setObjects");
        }
    }

    @Override
    protected void setObjectAvailability(ResourceAllocation theResAll) {
        theResAll.setAvailable(false);
        if (this.availabilities == null || this.availabilities.isEmpty()) {
            return;
        }
        int size = this.availabilities.size();
        int appointmentStartTime = theResAll.getMinTimeFromInt();
        int i = 0;
        while (i < size) {
            Availability availability = this.availabilities.get(i);
            int availabilityStartTime = availability.getMinTimeFromInt();
            int availabilityEndTime = availability.getMinTimeToInt();
            if (appointmentStartTime >= availabilityStartTime && appointmentStartTime <= availabilityEndTime) {
                theResAll.setAvailable(true);
                theResAll.setAvailableTimeFrom(availabilityStartTime);
                if (i < size) {
                    int j = i + 1;
                    while (j < size) {
                        availability = this.availabilities.get(j);
                        availabilityStartTime = availability.getMinTimeFromInt();
                        if (availabilityStartTime != availabilityEndTime && availabilityStartTime >= availabilityEndTime) break;
                        availabilityEndTime = availability.getMinTimeToInt();
                        availabilityStartTime = availability.getMinTimeFromInt();
                        ++j;
                    }
                }
                theResAll.setAvailableTimeTo(availabilityEndTime);
                break;
            }
            ++i;
        }
    }

    public boolean isResAllInOffer() {
        if (this.appointmentOffers != null) {
            for (SpecialTime specialTime : this.appointmentOffers) {
                if (this.resAlls == null) continue;
                for (ResourceAllocation resAll : this.resAlls) {
                    if (!(resAll.getTimeFromInt() >= specialTime.getTimeFromInt() && resAll.getTimeFromInt() < specialTime.getTimeToInt() || resAll.getTimeToInt() > specialTime.getTimeFromInt() && resAll.getTimeToInt() < specialTime.getTimeToInt()) && (specialTime.getTimeFromInt() <= resAll.getTimeFromInt() || specialTime.getTimeToInt() > resAll.getTimeToInt())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ArrayList<JLabel> getAllTimeSlots() {
        return this.allTimeSlots;
    }

    public void setAllTimeSlots(ArrayList<JLabel> allTimeSlots) {
        this.allTimeSlots = allTimeSlots;
    }

    public ArrayList<AppointmentOffer> getAppointmentOffers() {
        return this.appointmentOffers;
    }

    public void setAppointmentOffers(ArrayList<AppointmentOffer> appointmentOffers) {
        this.appointmentOffers = appointmentOffers;
    }

    public ArrayList<Availability> getAvailabilities() {
        return this.availabilities;
    }

    public void setAvailabilities(ArrayList<Availability> availabilities) {
        this.availabilities = availabilities;
        if (availabilities != null) {
            if (availabilities.size() <= 1) {
                return;
            }
            Collections.sort(availabilities);
        }
    }

    public MarkSlot getMarkSlot() {
        return this.markSlot;
    }

    public void setMarkSlot(MarkSlot markSlot) {
        this.markSlot = markSlot;
    }

    public boolean isMarkSlotSetted() {
        return this.markSlotSetted;
    }

    public void setMarkSlotSetted(boolean markSlotSetted) {
        this.markSlotSetted = markSlotSetted;
    }

    public ArrayList<SpecialTime> getSpecialTimes() {
        return this.specialTimes;
    }

    public void setSpecialTimes(ArrayList<SpecialTime> specialTimes) {
        this.specialTimes = specialTimes;
    }

    public ArrayList<SpecialTime> getSpecialTimesForMark() {
        return this.specialTimesForMark;
    }

    public void setSpecialTimesForMark(ArrayList<SpecialTime> specialTimesForMark) {
        this.specialTimesForMark = specialTimesForMark;
    }

    @Override
    public void setResourceAllocations(ResourceAllocationController appCon) {
        this.resAlls = appCon.getTimeBasedAppointments(this.getResID(), this.getColID());
    }

    @Override
    public String toString() {
        return "\nTime Resource:" + super.toString();
    }

    private void calculateCorrespApp(ArrayList<ResourceAllocation> correspondigAppointments, int x, int width) {
        Iterator<ResourceAllocation> it = correspondigAppointments.iterator();
        CorrespondigResourceAllocations corrResAlls = new CorrespondigResourceAllocations(this.scheduler);
        while (it.hasNext()) {
            ResourceAllocation resAll = it.next();
            corrResAlls.addResourceAllocation(resAll);
        }
        int colums = corrResAlls.getDeepness();
        int newWidth = width / colums;
        corrResAlls.calculateXAndWidth(x, newWidth, --colums, width -= newWidth);
        corrResAlls.addResourceAllocationToResource(this);
    }

    public SpecialTime getSpezialTimeAt(int x, int y) {
        Component comp = this.spezPanel.getComponentAt(x, y);
        if (comp != null && comp instanceof SpecialTime) {
            return (SpecialTime)comp;
        }
        return null;
    }

    public Availability getAvailabilityAt(int x, int y) {
        Component comp = this.avalPanel.getComponentAt(x, y);
        if (comp != null && comp instanceof Availability) {
            return (Availability)comp;
        }
        return null;
    }

    public SpecialTime getMarkAt(int y) {
        Component comp = this.getComponentAt(0, y);
        if (comp != null && comp instanceof MarkSlot) {
            comp.getComponentAt(0, y);
            if (comp != null && comp instanceof SpecialTime) {
                return (SpecialTime)comp;
            }
        }
        return null;
    }

    public AppointmentOffer getAppointmentOfferAt(int x, int y) {
        Component comp = this.offerPanel.getComponentAt(x, y);
        if (comp != null && comp instanceof AppointmentOffer) {
            return (AppointmentOffer)comp;
        }
        return null;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.avalPanel.setBounds(0, 0, width, height);
        this.spezPanel.setBounds(0, 0, width, height);
        this.offerPanel.setBounds(0, 0, width, height);
    }

    @Override
    public void add(Component comp, Object o) {
        super.add(comp, o);
    }

    @Override
    public void removeAll() {
        this.setVisible(false);
        super.removeAll();
        this.setVisible(true);
        this.initComponents();
    }

    private void initComponents() {
        this.avalPanel = new DefaultPanel();
        this.avalPanel.setLayout(null);
        this.add((Component)this.avalPanel, Resource.AVALIBILITY_LAYER);
        this.spezPanel = new DefaultPanel();
        this.spezPanel.setLayout(null);
        this.add((Component)this.spezPanel, Resource.SPEZIALTIME_LAYER);
        this.offerPanel = new DefaultPanel();
        this.offerPanel.setLayout(null);
        this.add((Component)this.offerPanel, Resource.APPOINTMENTOFFER_LAYER);
        this.setMarkSlotSetted(false);
        this.avalPanel.setOpaque(false);
        this.offerPanel.setOpaque(false);
        this.spezPanel.setOpaque(false);
    }

    public void setTimeLines(TimeLines timeLines) {
        if (timeLines == null) {
            return;
        }
        TimeLine tL = timeLines.getTimeLine(this.getColID(), this.resID);
        if (tL != null) {
            ArrayList<TimeLine> al = new ArrayList<TimeLine>();
            al.add(tL);
            this.setObjects(al, 8);
        }
    }

    public void setLinePanels(ArrayList<LinePanel> lines) {
        this.setObjects(lines, 6);
    }

    @Override
    public void free() {
        super.free();
        if (this.availabilities != null) {
            this.availabilities.clear();
        }
        this.availabilities = null;
        if (this.specialTimes != null) {
            this.specialTimes.clear();
        }
        this.specialTimes = null;
        if (this.specialTimesForMark != null) {
            this.specialTimesForMark.clear();
        }
        this.specialTimesForMark = null;
        if (this.appointmentOffers != null) {
            this.appointmentOffers.clear();
        }
        this.appointmentOffers = null;
        if (this.allTimeSlots != null) {
            this.allTimeSlots.clear();
        }
        this.allTimeSlots = null;
        if (this.markSlot != null) {
            this.markSlot.free();
        }
        this.markSlot = null;
        if (this.avalPanel != null) {
            this.avalPanel.free();
        }
        this.avalPanel = null;
        if (this.spezPanel != null) {
            this.spezPanel.free();
        }
        this.spezPanel = null;
        if (this.offerPanel != null) {
            this.offerPanel.free();
        }
        this.offerPanel = null;
    }
}

