/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.gui.resource;

import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.resource.Resource;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ResourceController {
    protected TreeMap<String, ArrayList<Resource>> tm = null;
    protected TreeMap<String, ArrayList<Resource>> saveTm = null;
    protected SchedulerProperty schedulerProperty;
    protected Helper helper;
    protected Scheduler scheduler;
    protected String className;

    public ResourceController(Node pNode, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.schedulerProperty = scheduler.getSchedulerProperty();
        this.helper = scheduler.getHelper();
        this.tm = new TreeMap();
        this.className = "ResourceController";
        try {
            NodeList nodeList = pNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                NodeList nodeList2 = nodeList.item(i).getChildNodes();
                this.addResource(this.helper.getNodeValueS(nodeList2, "ci"), this.helper.getNodeValueS(nodeList2, "ri"), this.helper.getNodeValueS(nodeList2, "oi"), this.helper.getNodeValueS(nodeList2, "dc"), this.helper.getNodeValueI(nodeList2, "ts"), this.helper.getNodeValueS(nodeList2, "bg"), this.helper.getNodeValueS(nodeList2, "fn"), this.helper.getNodeValueI(nodeList2, "fs"), this.helper.getNodeValueS(nodeList2, "fb"), this.helper.getNodeValueS(nodeList2, "fi"), this.helper.getNodeValueS(nodeList2, "fc"), this.helper.getNodeValueS(nodeList2, "tp"));
                ++i;
            }
        }
        catch (Exception ex) {
            this.helper.logThrowing("ResourceController", "Constructor", ex);
            ex.printStackTrace(System.err);
            System.err.println(ex);
        }
    }

    public ResourceController(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.schedulerProperty = scheduler.getSchedulerProperty();
        this.helper = scheduler.getHelper();
        this.tm = new TreeMap();
    }

    public void putResource(String colID, Resource res) {
        StringBuffer sb = new StringBuffer();
        sb.append(colID);
        ArrayList<Resource> vectorResources = this.tm.get(new String(sb));
        if (vectorResources == null) {
            vectorResources = new ArrayList();
            this.tm.put(colID, vectorResources);
        }
        vectorResources.add(res);
    }

    public Resource getResource(String colID, String resID) {
        ArrayList<Resource> vector = this.tm.get(colID);
        if (vector == null) {
            return null;
        }
        Iterator<Resource> it = vector.iterator();
        Resource resource = null;
        boolean found = false;
        while (it.hasNext() && !found) {
            resource = it.next();
            if (resource == null || !resource.getResID().equalsIgnoreCase(resID)) continue;
            return resource;
        }
        return null;
    }

    public TreeMap<String, ArrayList<Resource>> getAll() {
        return this.tm;
    }

    public boolean removeResource(String colID, String resID) {
        ArrayList<Resource> vector = this.tm.get(colID);
        boolean found = false;
        if (vector != null && !vector.isEmpty()) {
            int sizeOfArrayList = vector.size();
            int i = sizeOfArrayList - 1;
            while (i >= 0) {
                Resource resource = vector.get(i);
                if (resource.getResID().equalsIgnoreCase(resID)) {
                    vector.remove(resource);
                    return true;
                }
                --i;
            }
        }
        return found;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer(26);
        stringbuffer.append("output for class:\t");
        stringbuffer.append(this.getClass().getName());
        stringbuffer.append(this.tm);
        stringbuffer.append("TreeMap");
        return new String(stringbuffer);
    }

    public void removeAll() {
        this.tm = null;
        this.tm = new TreeMap();
    }

    public ArrayList<Resource> getAllResource(String colID) {
        ArrayList<Resource> aVec = null;
        aVec = this.tm.get(colID);
        return aVec;
    }

    public void addResources(String theColID, String theResID, String theOrgID, String theDescription, int theTimeScale, String theBackGroundColor, String theFontName, int theFontSize, String theFontBold, String theFontItalic, String theFontColor, String toolTip) {
        this.addResource(theColID, theResID, theOrgID, theDescription, theTimeScale, theBackGroundColor, theFontName, theFontSize, theFontBold, theFontItalic, theFontColor, toolTip);
    }

    private void addResource(String theColID, String theResID, String theOrgID, String theDescription, int theTimeScale, String theBackGroundColor, String theFontName, int theFontSize, String theFontBold, String theFontItalic, String theFontColor, String toolTip) {
        ArrayList<Resource> vectorResources = this.tm.get(theColID);
        if (vectorResources == null) {
            vectorResources = new ArrayList();
            this.tm.put(theColID, vectorResources);
        }
        this.add(vectorResources, theColID, theResID, theOrgID, theDescription, theTimeScale, theBackGroundColor, theFontName, theFontSize, theFontBold, theFontItalic, theFontColor, toolTip);
    }

    public void setResInZoomMode(String colID, String resID) {
        Resource res;
        if (colID != null && resID != null && (res = this.getResource(colID, resID)) != null) {
            this.saveColumnsSave();
            if (this.saveTm == null) {
                return;
            }
            this.putResource(colID, res);
        }
    }

    public void setResInZoomMode(String colID) {
        if (this.tm != null && !this.tm.containsKey(colID)) {
            return;
        }
        this.saveColumnsSave();
        if (this.saveTm == null) {
            return;
        }
        for (Resource res : this.saveTm.get(colID)) {
            this.putResource(colID, res);
        }
    }

    private void saveColumnsSave() {
        if (this.saveTm == null && this.tm != null) {
            this.saveTm = new TreeMap<String, ArrayList<Resource>>((SortedMap<String, ArrayList<Resource>>)this.tm);
        }
        this.tm.clear();
        this.tm = new TreeMap();
    }

    public void setColseZoomMode() {
        if (this.saveTm != null) {
            this.tm = new TreeMap<String, ArrayList<Resource>>((SortedMap<String, ArrayList<Resource>>)this.saveTm);
        }
        this.saveTm = null;
    }

    protected void add(ArrayList<Resource> array, String theColID, String theResID, String theOrgID, String theDescription, int theTimeScale, String theBackGroundColor, String theFontName, int theFontSize, String theFontBold, String theFontItalic, String theFontColor, String tooltip) {
        array.add(new Resource(theColID, theResID, theOrgID, theDescription, theTimeScale, theBackGroundColor, theFontName, theFontSize, theFontBold, theFontItalic, theFontColor, tooltip, this.scheduler));
    }

    public Resource getResource(String theResID) {
        Iterator<ArrayList<Resource>> it = this.tm.values().iterator();
        Resource resource = null;
        while (it.hasNext()) {
            ArrayList<Resource> arrayListResources = it.next();
            if (arrayListResources == null || arrayListResources.isEmpty()) continue;
            int sizeOfArrayList = arrayListResources.size();
            int i = 0;
            while (i < sizeOfArrayList) {
                resource = arrayListResources.get(i);
                if (resource.getResID().equals(theResID)) {
                    return resource;
                }
                ++i;
            }
        }
        return null;
    }

    public void free() {
        if (this.tm != null) {
            this.tm.clear();
        }
        this.tm = null;
        if (this.saveTm != null) {
            this.saveTm.clear();
        }
        this.saveTm = null;
        this.schedulerProperty = null;
        this.helper = null;
        this.scheduler = null;
    }

    public boolean isEmpty() {
        return this.tm.isEmpty();
    }

    public Iterator<ArrayList<Resource>> getAsIterator() {
        return this.tm.values().iterator();
    }
}

