/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.gui.resource;

import at.tsa.ishmed.appmntmgmnt.Flag;
import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.avaliability.Availability;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.ResourceAllocation;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.ResourceAllocationController;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.appointment.Appointment;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.timeObject.specialTime.resourceAllocation.progress.Progress;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.BaseJComponent;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.gui.DefaultPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;

public class Resource
extends BaseJComponent {
    private static final long serialVersionUID = -8817259199349318738L;
    protected String resID;
    protected String orgID;
    protected int timeScale;
    protected String backGroundColorString;
    protected Color backGroundColor;
    protected Color originalBackColor;
    protected ArrayList<ResourceAllocation> resAlls;
    protected ArrayList<ResourceAllocation> allResAlls = new ArrayList();
    protected SchedulerProperty schedulerProperty;
    protected Scheduler scheduler;
    protected String toolTipFontName = null;
    protected DefaultPanel resAllPane;
    protected DefaultPanel selectPane;
    protected static final int AVALIBILITY = 1;
    protected static final int SPEZIALTIME = 2;
    protected static final int APPOINTMENTOFFER = 3;
    protected static final int RESOURCEALLOCATION = 4;
    protected static final int MARKS = 5;
    protected static final int LINES = 6;
    public static final int TIMEMARK = 7;
    public static final int TIMELINE = 8;
    protected static final int APPOINTMENT = 9;
    protected static final int PROGRESS = 10;
    protected static final Integer GROUND_LAYER = 10;
    protected static final Integer AVALIBILITY_LAYER = 20;
    protected static final Integer SPEZIALTIME_LAYER = 30;
    protected static final Integer MARKS_LAYER = 40;
    protected static final Integer SCALETIME_LAYER = 60;
    protected static final Integer APPOINTMENTOFFER_LAYER = 50;
    protected static final Integer RESOURCEALLOCATION_LAYER = 70;
    protected static final Integer SELECTPANE_LAYER = 80;
    protected static final Integer LINEPANE_LAYER = 90;
    protected static final Integer TIMELINEPANE_LAYER = 91;
    protected static final Integer SING_LAYER = 100;

    public Resource(String theColID, String theResID, String theOrgID, String theDescription, int theTimeScale, String theBackGroundColor, String theFontName, int theFontSize, String theFontBold, String theFontItalic, String theFontColor, String toolTipText, Scheduler scheduler) {
        super(theColID, theDescription, theFontName, theFontSize, theFontBold, theFontItalic, theFontColor, scheduler.getHelper());
        this.schedulerProperty = scheduler.getSchedulerProperty();
        this.resID = theResID;
        this.orgID = theOrgID;
        this.timeScale = theTimeScale;
        this.backGroundColorString = theBackGroundColor;
        this.setBackGroundColor(this.getHelper().getColor(theBackGroundColor));
        this.setOriginalBackColor(this.backGroundColor);
        this.scheduler = scheduler;
        this.initComponents();
        this.setBackground(this.backGroundColor);
        this.setToolTipText(toolTipText);
        this.setDoubleBuffered(true);
        this.className = "Resource";
        this.setFocusable(Flag.focus);
        this.setRequestFocusEnabled(Flag.reFou);
        if (this.getDescription() != null && !this.getDescription().equalsIgnoreCase("")) {
            this.setFont(this.helper.getFontForString(this.getFont(), this.getDescription()));
        }
        if (toolTipText != null && toolTipText.equalsIgnoreCase("")) {
            Font font = this.helper.getFontForString(this.getFont(), toolTipText);
            this.toolTipFontName = font != null ? font.getName() : this.schedulerProperty.fontDefault;
        }
    }

    @Override
    public String toString() {
        return "\nResource:" + super.toString() + "\nresID: " + this.resID + "\norgID: " + this.orgID + "\ntimeScale: " + this.timeScale + "\nbackGroundColor: " + this.backGroundColorString + String.valueOf(this.getBounds());
    }

    public void setWidth(int theWidth) {
        this.helper.logEntering(this.className, "setWidth");
        this.setWidth(theWidth);
        this.helper.logExiting(this.className, "setWidth");
    }

    public void addResourceAllocation(ResourceAllocation theResAll) {
        this.helper.logEntering(this.className, "addResourceAllocation");
        if (this.resAlls == null) {
            this.resAlls = new ArrayList();
        }
        this.resAlls.add(theResAll);
        this.helper.logExiting(this.className, "addResourceAllocation");
    }

    public boolean removeResourceAllocation(String theResourceAllocationKey) {
        this.helper.logEntering(this.className, "removeResourceAllocation", theResourceAllocationKey);
        if (this.resAlls == null || this.resAlls.isEmpty()) {
            this.helper.logInfo("Resource: end removeResourceAllocation(key), appointments is null or empty");
            return false;
        }
        int size = this.resAlls.size();
        int i = 0;
        while (i < size) {
            ResourceAllocation resAll = this.resAlls.get(i);
            if (resAll.getKey().equalsIgnoreCase(theResourceAllocationKey)) {
                this.resAlls.remove(resAll);
                this.remove(resAll);
                this.helper.logInfo("Resource: end removeResourceAllocation(key), leaving loop");
                return true;
            }
            ++i;
        }
        this.helper.logExiting(this.className, "removeResourceAllocation", "no ResourceAllocation removed");
        return false;
    }

    public void removeResourceAllocation(ResourceAllocation theResAll) {
        this.helper.logEntering(this.className, "removeResourceAllocation", "by object");
        if (this.resAlls == null || this.resAlls.isEmpty()) {
            this.helper.logInfo("Resource: end removeResourceAllocation(ResourceAllocation), ResourceAllocation is null or empty");
            return;
        }
        int size = this.resAlls.size();
        int i = 0;
        while (i < size) {
            ResourceAllocation resAll = this.resAlls.get(i);
            if (resAll.equals(theResAll)) {
                this.resAlls.remove(theResAll);
                this.remove(theResAll);
                this.helper.logInfo("Resource: end removeResourceAllocation(Appointment), leaving loop");
                return;
            }
            ++i;
        }
        this.helper.logExiting(this.className, "removeResourceAllocation", "no ResourceAllocation removed");
    }

    public void removeResourceAllocations() {
        this.helper.logEntering(this.className, "removeResourceAllocations");
        if (this.resAlls == null || this.resAlls.isEmpty()) {
            this.helper.logExiting(this.className, "removeResourceAllocations", "ArrayList RessourceAllocation is null or empty");
            return;
        }
        int size = this.resAlls.size();
        int i = 0;
        while (i < size) {
            ResourceAllocation resAll = this.resAlls.get(i);
            this.remove(resAll);
            resAll.setBounds(0, 0, 0, 0);
            resAll.setReallyOrVirtualAdded(false);
            resAll.setVisible(false);
            ++i;
        }
        if (this.resAllPane != null) {
            this.resAllPane.removeAll();
        } else {
            Component[] components = this.getComponents();
            int countComp = components.length;
            int i2 = 0;
            while (i2 < countComp) {
                if (components[i2] instanceof Appointment || components[i2] instanceof Progress) {
                    this.remove(components[i2]);
                }
                ++i2;
            }
        }
        this.helper.logExiting(this.className, "removeResourceAllocations");
    }

    public void setResourceAllocations() {
        this.helper.logEntering(this.className, "setResourceAllocations");
        this.removeResourceAllocations();
        this.setObjects(this.resAlls, 4);
        this.helper.logExiting(this.className, "setResourceAllocations");
    }

    protected void setObjects(ArrayList theArrayList, int theType) {
    }

    protected void setObjectAvailability(ResourceAllocation resAll) {
    }

    protected void getAllCorrespondingArrayLists(ArrayList<ResourceAllocation> theAppointments) {
        for (ResourceAllocation resAll : theAppointments) {
            if (resAll == null || this.allResAlls.contains(resAll)) continue;
            this.allResAlls.add(resAll);
            ArrayList<ResourceAllocation> corrApps = resAll.getCorrespondigAllocations();
            if (corrApps == null || corrApps.isEmpty()) continue;
            this.getAllCorrespondingArrayLists(corrApps);
        }
    }

    protected ArrayList<ResourceAllocation> sortAllCorrespondingArrayLists() {
        ArrayList<ResourceAllocation> sortedArrayList = new ArrayList<ResourceAllocation>();
        if (this.allResAlls == null || this.allResAlls.isEmpty()) {
            return null;
        }
        if (this.schedulerProperty.use472) {
            return this.sortAllCorresponding472();
        }
        int size = this.allResAlls.size();
        TreeMap prioMap = new TreeMap();
        int i = 0;
        while (i < size) {
            int sizeArrayList;
            ResourceAllocation resAll1 = this.allResAlls.get(i);
            ArrayList<ResourceAllocation> appIDArrayList = (ArrayList<ResourceAllocation>)prioMap.get(resAll1.getPrio());
            if (appIDArrayList == null) {
                appIDArrayList = new ArrayList<ResourceAllocation>();
                prioMap.put(resAll1.getPrio(), appIDArrayList);
            }
            if ((sizeArrayList = appIDArrayList.size()) == 0) {
                appIDArrayList.add(resAll1);
            } else {
                double appID1Dou = Double.parseDouble(resAll1.getKey());
                int j = 0;
                while (j < sizeArrayList) {
                    ResourceAllocation resAll2 = (ResourceAllocation)appIDArrayList.get(j);
                    double appID2Dou = Double.parseDouble(resAll2.getKey());
                    if (appID1Dou < appID2Dou) break;
                    ++j;
                }
                appIDArrayList.add(j, resAll1);
            }
            ++i;
        }
        for (Map.Entry entry : prioMap.entrySet()) {
            ArrayList theArrayList = (ArrayList)entry.getValue();
            if (theArrayList == null) continue;
            int len = theArrayList.size();
            int i2 = 0;
            while (i2 < len) {
                sortedArrayList.add((ResourceAllocation)theArrayList.get(i2));
                ++i2;
            }
        }
        return sortedArrayList;
    }

    public ArrayList<ResourceAllocation> getResourceAllocations() {
        return this.resAlls;
    }

    public void setResourceAllocations(ArrayList<ResourceAllocation> resAlls) {
        this.resAlls = resAlls;
    }

    public void setResourceAllocations(ResourceAllocationController appCon) {
        this.resAlls = appCon.getTimeBasedResourceAllocation(this.getResID(), this.getColID());
    }

    public Color getBackGroundColor() {
        return this.backGroundColor;
    }

    public void setBackGroundColor(Color backGroundColor) {
        if (backGroundColor == null) {
            backGroundColor = this.schedulerProperty.colorBackgrClose;
        }
        this.backGroundColor = backGroundColor;
    }

    public String getBackGroundColorString() {
        return this.backGroundColorString;
    }

    public void setBackGroundColorString(String backGroundColorString) {
        this.backGroundColorString = backGroundColorString;
    }

    public String getOrgID() {
        return this.orgID;
    }

    public ResourceAllocation getResourceAllocationAt(int x, int y) {
        Component comp = this.resAllPane.getComponentAt(x, y);
        if (comp != null && comp instanceof ResourceAllocation) {
            return (ResourceAllocation)comp;
        }
        return null;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public Color getOriginalBackColor() {
        return this.originalBackColor;
    }

    public void setOriginalBackColor(Color originalBackColor) {
        this.originalBackColor = originalBackColor;
    }

    public String getResID() {
        return this.resID;
    }

    public void setResID(String resID) {
        this.resID = resID;
    }

    public SchedulerProperty getSchedulerProperty() {
        return this.schedulerProperty;
    }

    public void setSchedulerProperty(SchedulerProperty schedulerProperty) {
        this.schedulerProperty = schedulerProperty;
    }

    public int getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(int timeScale) {
        this.timeScale = timeScale;
    }

    public ArrayList<Availability> getAvailability() {
        return null;
    }

    public ArrayList<ResourceAllocation> getAllResAlls() {
        return this.allResAlls;
    }

    public void setAllResAlls(ArrayList<ResourceAllocation> allResAlls) {
        this.allResAlls = allResAlls;
    }

    public void addResAll(ResourceAllocation resAll) {
        this.resAllPane.add(resAll);
    }

    @Override
    public void setBackground(Color c) {
        if (c == null) {
            c = this.schedulerProperty.colorBackgrClose;
            this.setOriginalBackColor(c);
        }
        super.setBackground(c);
    }

    @Override
    public void setBounds(Rectangle rec) {
        super.setBounds(rec);
        this.resAllPane.setBounds(rec);
    }

    @Override
    public void setBounds(int x, int y, int widht, int height) {
        super.setBounds(x, y, widht, height);
        this.selectPane.setBounds(0, 0, widht - 1, height);
        this.resAllPane.setBounds(0, 0, widht, height);
    }

    public void setSelected(boolean selected) {
        this.selectPane.setOpaque(selected);
        this.repaint();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(this.backGroundColor);
        if (this.schedulerProperty.printPreview) {
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 2, this.schedulerProperty.colorLine));
        } else {
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.schedulerProperty.colorLine));
        }
        this.resAllPane = new DefaultPanel();
        this.resAllPane.setLayout(null);
        this.add((Component)this.resAllPane, RESOURCEALLOCATION_LAYER);
        this.selectPane = new DefaultPanel();
        Color c = this.schedulerProperty.colorOfResourceAtAppmntMovement;
        this.selectPane.setBackground(new Color(c.getRed(), c.getGreen(), c.getBlue(), 50));
        this.add((Component)this.selectPane, SELECTPANE_LAYER);
        this.selectPane.setOpaque(false);
        this.resAllPane.setOpaque(false);
        this.setOpaque(false);
        this.setFocusable(Flag.focus);
        this.setRequestFocusEnabled(Flag.reFou);
    }

    private ArrayList<ResourceAllocation> sortAllCorresponding472() {
        ArrayList<ResourceAllocation> sortedVector = new ArrayList<ResourceAllocation>();
        if (this.allResAlls == null || this.allResAlls.isEmpty()) {
            return null;
        }
        int size = this.allResAlls.size();
        TreeMap prioMap = new TreeMap();
        int i = 0;
        while (i < size) {
            int sizeVector;
            ResourceAllocation resAll1 = this.allResAlls.get(i);
            ArrayList<ResourceAllocation> appIDVector = (ArrayList<ResourceAllocation>)prioMap.get(resAll1.getPrio());
            if (appIDVector == null) {
                appIDVector = new ArrayList<ResourceAllocation>();
                prioMap.put(resAll1.getPrio(), appIDVector);
            }
            if ((sizeVector = appIDVector.size()) == 0) {
                appIDVector.add(resAll1);
            } else {
                int appID1Int = this.helper.getIntValue(resAll1.getKey());
                int j = 0;
                while (j < sizeVector) {
                    ResourceAllocation resAll2 = (ResourceAllocation)appIDVector.get(j);
                    int appID2Int = this.helper.getIntValue(resAll2.getKey());
                    if (appID1Int < appID2Int) break;
                    ++j;
                }
                appIDVector.add(j, resAll1);
            }
            ++i;
        }
        for (Map.Entry entry : prioMap.entrySet()) {
            ArrayList theVector = (ArrayList)entry.getValue();
            if (theVector == null) continue;
            int len = theVector.size();
            int i2 = 0;
            while (i2 < len) {
                sortedVector.add((ResourceAllocation)theVector.get(i2));
                ++i2;
            }
        }
        return sortedVector;
    }

    @Override
    public void free() {
        this.resID = null;
        this.orgID = null;
        this.backGroundColorString = null;
        this.backGroundColor = null;
        this.originalBackColor = null;
        this.resAlls = null;
        this.allResAlls = null;
        this.schedulerProperty = null;
        this.scheduler = null;
        if (this.resAllPane != null) {
            this.resAllPane.free();
        }
        this.resAllPane = null;
        if (this.selectPane != null) {
            this.selectPane.free();
        }
        this.selectPane = null;
    }

    protected class ReverseIntegerComparator
    implements Comparator<Object> {
        protected ReverseIntegerComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return ((Integer)o2).compareTo((Integer)o1);
        }
    }
}

