/*
 * Decompiled with CFR 0.152.
 */
package at.tsa.ishmed.appmntmgmnt.scheduler.gui.header.column;

import at.tsa.ishmed.appmntmgmnt.Flag;
import at.tsa.ishmed.appmntmgmnt.scheduler.Scheduler;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.header.column.Column;
import at.tsa.ishmed.appmntmgmnt.scheduler.gui.resource.Resource;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.Helper;
import at.tsa.ishmed.appmntmgmnt.scheduler.system.SchedulerProperty;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;

public class TitleOfResource
extends JTextField
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -6431434902733068390L;
    protected Resource resource;
    private Scheduler scheduler;
    private MouseEvent mouseEvent;
    public int absolutX = 0;
    private int absolutY = 0;
    private Column column;
    private SchedulerProperty schedulerProperty;
    protected Helper helper;

    public TitleOfResource(Resource theResource, Scheduler theScheduler, int width, Column theColumn) {
        this.resource = theResource;
        this.scheduler = theScheduler;
        this.helper = theScheduler.getHelper();
        this.schedulerProperty = this.scheduler.getSchedulerProperty();
        this.column = theColumn;
        this.setText(this.resource.getDescription());
        this.setFont(this.resource.getFont());
        this.setForeground(this.resource.getFontColor());
        this.setDisabledTextColor(this.resource.getFontColor());
        this.setSelectionColor(this.resource.getFontColor());
        this.setDisabledTextColor(this.resource.getFontColor());
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 40));
        this.setMinimumSize(new Dimension(0, 20));
        this.setPreferredSize(new Dimension(width, 20));
        this.setCaretPosition(0);
        this.setHorizontalAlignment(0);
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.schedulerProperty.colorLine));
        this.setFocusable(Flag.focus);
        this.setRequestFocusEnabled(Flag.reFou);
        this.setEditable(false);
        this.setMargin(new Insets(1, 1, 1, 1));
        this.setOpaque(false);
        this.setScrollOffset(1);
        this.setSelectionEnd(1);
        this.setSelectionStart(1);
        this.setVerifyInputWhenFocusTarget(false);
        if (!this.schedulerProperty.print) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
    }

    protected void showTipWindow(String text, String theFontName) {
        if (text == null || text.equals("")) {
            this.hideTipWindow();
            return;
        }
        if (this.mouseEvent == null) {
            return;
        }
        int x = this.mouseEvent.getX() + 20;
        int y = this.mouseEvent.getY();
        y = this.getYAbsoulut(y);
        String textHtml = this.helper.buildTooltipText(text, false, theFontName);
        this.scheduler.ground.showTipWindow(textHtml, this.getXForTooltip(x), y);
        this.scheduler.ground.tipShowing = true;
    }

    protected int getXForTooltip(int x) {
        return x + this.absolutX;
    }

    protected void hideTipWindow() {
        this.scheduler.ground.hideTipWindow();
    }

    protected int getYAbsoulut(int y) {
        return this.absolutY + y;
    }

    @Override
    public void setToolTipText(String text) {
        this.showTipWindow(text, this.getFont().getName());
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.mouseEvent = me;
        this.hideTipWindow();
        int button = me.getButton();
        if (me.getSource() instanceof TitleOfResource && button == 1 && me.getClickCount() == 2) {
            if (!this.schedulerProperty.zoomMode) {
                this.scheduler.getColCon().setColInZoomMode(this.resource.getColID());
                this.scheduler.getResCon().setResInZoomMode(this.resource.getColID(), this.resource.getResID());
                if (this.scheduler.getSchedulerProperty().showDayBasedApp) {
                    this.scheduler.getResDayCon().setResInZoomMode(this.resource.getColID(), this.resource.getResID());
                }
                this.schedulerProperty.saveColID = this.resource.getColID();
                this.schedulerProperty.saveResID = this.resource.getResID();
                this.schedulerProperty.zoomMode = true;
                this.schedulerProperty.zoomCollMode = false;
                if (this.column.isAreaToClear(this.resource.getColID(), this.resource.getResID())) {
                    this.column.clearAreas();
                }
                this.column.helper.unselectIfNecessary(this.resource.getColID(), this.resource.getResID());
                this.scheduler.update();
                return;
            }
            this.column.helper.closeZoomMode(true);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.mouseEvent = me;
        this.hideTipWindow();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        this.mouseEvent = me;
        this.hideTipWindow();
        ((JTextField)me.getSource()).setScrollOffset(0);
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.mouseEvent = me;
        this.hideTipWindow();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.mouseEvent = me;
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.mouseEvent = me;
        this.hideTipWindow();
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.mouseEvent = me;
        this.showTipWindow(this.getText(), this.getFont().getFontName());
    }

    public void setApsolutX(int x) {
        this.absolutX = x;
    }

    public void setAbsolutY(int absolutY) {
        this.absolutY = absolutY;
    }

    public void free() {
        if (!this.schedulerProperty.print) {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        }
        this.resource = null;
        this.scheduler = null;
        this.mouseEvent = null;
        this.absolutX = 0;
        this.absolutY = 0;
        this.column = null;
        this.schedulerProperty = null;
    }
}

