/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.tech.client.jccf.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtil {
    public static final String DOCTYPE_SPECIFICATION = "<!DOCTYPE msg SYSTEM \"msg.dtd\">";

    public static Node getNode(NodeList nodeList, String string) {
        Node node = null;
        try {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node = nodeList.item(i);
                if (!node.getNodeName().equals(string)) continue;
                return node;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return null;
    }

    public static String getNodeValueS(NodeList nodeList, String string) {
        Node node = null;
        try {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2;
                node = nodeList.item(i);
                if (!node.getNodeName().equals(string) || (node2 = node.getFirstChild()) == null) continue;
                String string2 = node2.getNodeValue().trim();
                return string2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return "";
    }

    public static int getNodeValueI(NodeList nodeList, String string) {
        String string2 = XMLUtil.getNodeValueS(nodeList, string);
        if (string2.length() > 0) {
            return Integer.parseInt(string2);
        }
        return 0;
    }

    public static String createStringFromDoc(Document document) {
        String string = "";
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            string = stringWriter.getBuffer().toString();
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            throw new RuntimeException(exception);
        }
    }

    public Document createDocument(String object) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new LoggingErrorHandler(this));
        documentBuilder.setEntityResolver(new JCCFDTDResolver(this));
        if (object == null) {
            return documentBuilder.newDocument();
        }
        if (((String)object).startsWith("<?")) {
            ((String)object).replaceFirst("\\?>", "?>\n<!DOCTYPE msg SYSTEM \"msg.dtd\">");
        } else {
            object = DOCTYPE_SPECIFICATION + (String)object;
        }
        StringReader stringReader = new StringReader((String)object);
        InputSource inputSource = new InputSource(stringReader);
        return documentBuilder.parse(inputSource);
    }

    class LoggingErrorHandler
    implements ErrorHandler {
        LoggingErrorHandler(XMLUtil xMLUtil) {
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            System.err.println("LoggingErrorHandler: Error in " + sAXParseException.getLineNumber() + ", " + sAXParseException.getColumnNumber() + " = " + String.valueOf(sAXParseException));
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.err.println("LoggingErrorHandler: Fatal error in " + sAXParseException.getLineNumber() + ", " + sAXParseException.getColumnNumber() + " = " + String.valueOf(sAXParseException));
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            System.err.println("LoggingErrorHandler: Warning in " + sAXParseException.getLineNumber() + ", " + sAXParseException.getColumnNumber() + " = " + String.valueOf(sAXParseException));
        }
    }

    class JCCFDTDResolver
    implements EntityResolver {
        JCCFDTDResolver(XMLUtil xMLUtil) {
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            try {
                URL uRL = this.getClass().getClassLoader().getResource("META-INF/msg.dtd");
                return new InputSource(uRL.openStream());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

