/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.tech.client.jccf;

import com.ishmed.tech.client.jccf.JCCFControl;
import com.ishmed.tech.client.jccf.JCCFLoggerI;
import com.ishmed.tech.client.jccf.JCCFRestrictedControl;
import com.ishmed.tech.client.jccf.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class JCCFLogger
implements JCCFLoggerI {
    public static final String START = "START ";
    public static final String END = "END ";
    private Logger logger = null;
    private String controlname = null;
    private JCCFFileTextAreaHandler filehandler = null;
    private JCCFConsoleTextAreaHandler consolehandler = null;
    private Level maxLevel = Level.WARNING;
    private Level filehandlerlevel = Level.OFF;
    private Level consolehandlerlevel = Level.WARNING;
    private Level debugconsolehandlerlevel = Level.OFF;
    protected static final String LOGNAME_START = "ISHMEDBasisControl";
    protected long logFileSize = 0L;
    protected long logOldFileAge = 0L;

    public static JCCFLogger create(Logger logger, String string) {
        return new JCCFLogger(logger, string);
    }

    public JCCFLogger(Logger logger, String string) {
        this.controlname = string;
        this.logger = logger;
        if (this.logger != null) {
            this.logger.setLevel(Level.ALL);
            this.logger.setUseParentHandlers(false);
            Handler[] handlerArray = this.logger.getHandlers();
            int n = handlerArray.length;
            for (int i = 0; i < n; ++i) {
                this.logger.removeHandler(handlerArray[i]);
            }
            if (JCCFControl.javagui) {
                return;
            }
            this.consolehandler = new JCCFConsoleTextAreaHandler();
            this.logger.addHandler(this.consolehandler);
            this.filehandler = new JCCFFileTextAreaHandler();
            this.logger.addHandler(this.filehandler);
        }
    }

    protected void calcmaxlevel() {
        this.maxLevel = this.debugconsolehandlerlevel;
        if (this.filehandlerlevel.intValue() < this.maxLevel.intValue()) {
            this.maxLevel = this.filehandlerlevel;
        }
        if (this.consolehandlerlevel.intValue() < this.maxLevel.intValue()) {
            this.maxLevel = this.consolehandlerlevel;
        }
    }

    public Level getDebugconsolehandlerlevel() {
        return this.debugconsolehandlerlevel;
    }

    public void setDebugconsolehandlerlevel(Level level) {
        this.debugconsolehandlerlevel = level;
        this.calcmaxlevel();
    }

    public Level getConsolehandlerlevel() {
        return this.consolehandlerlevel;
    }

    public void setConsolehandlerlevel(Level level) {
        this.consolehandlerlevel = level;
        this.calcmaxlevel();
    }

    public Level getFilehandlerlevel() {
        return this.filehandlerlevel;
    }

    public void setFilehandlerlevel(Level level) {
        this.filehandlerlevel = level;
        this.calcmaxlevel();
    }

    public String getControlname() {
        return this.controlname;
    }

    public void setControlname(String string) {
        this.controlname = string;
        if (!JCCFControl.javagui) {
            this.filehandler.newControlName(string);
        }
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public long getLogFileSize() {
        return this.logFileSize;
    }

    public void setLogFileSize(int n) {
        this.logFileSize *= 1000000L;
    }

    public long getLogOldFileAge() {
        return this.logOldFileAge;
    }

    public void setLogOldFileAge(long l) {
        this.logOldFileAge = l;
    }

    public String getLoggingPath() {
        return this.filehandler.getLoggingPath();
    }

    public void setLoggingPath(String string) {
        this.filehandler.setLoggingPath(string);
    }

    @Override
    public boolean isError() {
        return this.maxLevel.intValue() <= Level.SEVERE.intValue();
    }

    @Override
    public void error(String string) {
        this.error(string, null);
    }

    @Override
    public void error(String string, Throwable throwable) {
        this.error(null, null, string, throwable);
    }

    @Override
    public void error(String string, String string2, String string3) {
        this.error(string, string2, string3, null);
    }

    @Override
    public void error(String string, String string2, String string3, Throwable throwable) {
        if (this.isError()) {
            this.produceLog(Level.SEVERE, string, string2, string3, throwable);
        }
    }

    @Override
    public boolean isWarn() {
        return this.maxLevel.intValue() <= Level.WARNING.intValue();
    }

    @Override
    public void warn(String string) {
        this.warn(string, null);
    }

    @Override
    public void warn(String string, Throwable throwable) {
        this.warn(null, null, string, throwable);
    }

    @Override
    public void warn(String string, String string2, String string3) {
        this.warn(string, string2, string3, null);
    }

    @Override
    public void warn(String string, String string2, String string3, Throwable throwable) {
        if (this.isWarn()) {
            this.produceLog(Level.WARNING, string, string2, string3, throwable);
        }
    }

    @Override
    public boolean isInfo() {
        return this.maxLevel.intValue() <= Level.INFO.intValue();
    }

    @Override
    public void info(String string) {
        this.info(string, null);
    }

    @Override
    public void info(String string, Throwable throwable) {
        this.info(null, null, string, throwable);
    }

    @Override
    public void info(String string, String string2, String string3) {
        this.info(string, string2, string3, null);
    }

    @Override
    public void info(String string, String string2, String string3, Throwable throwable) {
        if (this.isInfo()) {
            this.produceLog(Level.INFO, string, string2, string3, throwable);
        }
    }

    @Override
    public boolean isDebug() {
        return this.maxLevel.intValue() <= Level.FINE.intValue();
    }

    @Override
    public void debug(String string) {
        this.debug(string, null);
    }

    @Override
    public void debug(String string, Throwable throwable) {
        this.debug(null, null, string, throwable);
    }

    @Override
    public void debug(String string, String string2, String string3) {
        this.debug(string, string2, string3, null);
    }

    @Override
    public void debug(String string, String string2, String string3, Throwable throwable) {
        if (this.isDebug()) {
            this.produceLog(Level.FINE, string, string2, string3, throwable);
        }
    }

    @Override
    public boolean isTrace() {
        return this.maxLevel.intValue() <= Level.ALL.intValue();
    }

    @Override
    public void trace(String string) {
        this.trace(string, null);
    }

    @Override
    public void trace(String string, Throwable throwable) {
        this.trace(null, null, string, throwable);
    }

    @Override
    public void trace(String string, String string2, String string3) {
        this.trace(string, string2, string3, null);
    }

    @Override
    public void trace(String string, String string2, String string3, Throwable throwable) {
        if (this.isTrace()) {
            this.produceLog(Level.ALL, string, string2, string3, throwable);
        }
    }

    protected void produceLog(Level level, String string, String string2, String string3, Throwable throwable) {
        String string4 = "";
        if (throwable != null) {
            string4 = Util.generateStackTrace(throwable);
        }
        if (JCCFControl.javagui) {
            System.err.println(this.formatForJava(level, string, string2, string3 + " " + string4));
        } else {
            this.logger.logp(level, string, string2, string3 + " " + string4);
        }
    }

    protected String formatForJava(Level level, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(new Date(System.currentTimeMillis()));
        stringBuffer.append(" ");
        if (level != null && level.toString().length() > 0) {
            stringBuffer.append(level.toString());
            stringBuffer.append(" ");
        }
        if (this.controlname != null && this.controlname.length() > 0) {
            stringBuffer.append(this.controlname);
            stringBuffer.append(" - ");
        }
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        }
        stringBuffer.append(".");
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(string2);
        }
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    class JCCFFileTextAreaHandler
    extends Handler {
        private FileOutputStream fileOS = null;
        private boolean fOSCreated = false;
        protected String loggingPath = null;
        private String fileName = null;

        public JCCFFileTextAreaHandler() {
            if (JCCFControl.javagui) {
                return;
            }
            if (JCCFLogger.this.isTrace()) {
                JCCFLogger.this.trace("JCCFFileTextAreaHandler", "constructor", JCCFLogger.START);
            }
            this.setFormatter(new JCCFTextAreaFormatter());
            this.fileName = this.createFileName(JCCFLogger.LOGNAME_START);
        }

        public void newControlName(String string) {
            if (JCCFControl.javagui) {
                return;
            }
            this.fOSCreated = false;
            if (this.fileOS != null) {
                try {
                    this.fileOS.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.fileOS = null;
            }
            this.fileName = string != null ? this.createFileName(string) : null;
        }

        private String createFileName(String string) {
            if (JCCFControl.javagui) {
                return null;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
            String string2 = simpleDateFormat.format(new Date(System.currentTimeMillis()));
            return System.getProperty("file.separator") + string + string2 + ".log";
        }

        public String getLoggingPath() {
            if (JCCFControl.javagui) {
                return null;
            }
            return this.loggingPath;
        }

        public void setLoggingPath(String string) {
            if (JCCFControl.javagui) {
                return;
            }
            if (JCCFLogger.this.isTrace()) {
                JCCFLogger.this.trace("JCCFFileTextAreaHandler", "setLoggingPath", JCCFLogger.START + string);
            }
            this.loggingPath = string;
            this.fOSCreated = false;
            if (string != null) {
                File file = this.logFileManager(string);
                if (JCCFLogger.this.isInfo()) {
                    JCCFLogger.this.info("JCCFFileTextAreaHandler", "setLoggingPath file: ", "");
                }
                if (file != null) {
                    this.fileOS = this.getFileOutputStream(file, file.getName(), false);
                    if (JCCFLogger.this.isInfo()) {
                        JCCFLogger.this.info("JCCFFileTextAreaHandler", "setLoggingPath fileOS: ", "");
                    }
                    this.fOSCreated = true;
                }
            }
        }

        @Override
        public void publish(LogRecord logRecord) {
            Object object;
            if (JCCFControl.javagui) {
                return;
            }
            if (logRecord.getLevel().intValue() < JCCFLogger.this.filehandlerlevel.intValue()) {
                return;
            }
            if (this.fileOS == null) {
                if (this.fOSCreated) {
                    return;
                }
                if (this.loggingPath != null) {
                    this.fOSCreated = true;
                    this.fileOS = this.openFile(this.loggingPath + this.fileName, true);
                    if (this.fileOS == null) {
                        JCCFLogger.this.setFilehandlerlevel(Level.OFF);
                        return;
                    }
                } else {
                    this.fOSCreated = true;
                    return;
                }
            }
            try {
                object = logRecord.getMessage() == null ? "" : (logRecord.getMessage().length() < 3 ? "" : this.getFormatter().format(logRecord));
            }
            catch (Exception exception) {
                this.reportError(null, exception, 5);
                return;
            }
            object = (String)object + "\n";
            try {
                this.fileOS.write(((String)object).getBytes());
                this.fileOS.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        protected FileOutputStream openFile(String string, boolean bl) {
            if (JCCFControl.javagui) {
                return null;
            }
            if (JCCFLogger.this.isTrace()) {
                JCCFLogger.this.trace("JCCFFileTextAreaHandler", "openFile", JCCFLogger.START + string + " " + bl);
            }
            if (string == null) {
                return null;
            }
            try {
                File file = new File(string);
                if (file.exists()) {
                    if (JCCFLogger.this.isDebug()) {
                        JCCFLogger.this.debug("JCCFFileTextAreaHandler", "openFile", "File " + string + " exists.");
                    }
                } else {
                    if (JCCFLogger.this.isDebug()) {
                        JCCFLogger.this.debug("JCCFFileTextAreaHandler", "openFile", "File " + string + " does not exist.");
                    }
                    file.createNewFile();
                    if (JCCFLogger.this.isDebug()) {
                        JCCFLogger.this.debug("JCCFFileTextAreaHandler", "openFile", "File " + string + " created.");
                    }
                }
                if (JCCFLogger.this.isDebug()) {
                    JCCFLogger.this.debug("JCCFFileTextAreaHandler", "openFile", "Write access to file " + string + " is " + file.canWrite());
                }
                return this.getFileOutputStream(file, string, bl);
            }
            catch (IOException iOException) {
                if (JCCFLogger.this.isDebug()) {
                    JCCFLogger.this.debug("JCCFFileTextAreaHandler", "openFile", "File " + string + " could not be created.");
                }
                return null;
            }
            catch (SecurityException securityException) {
                if (JCCFLogger.this.isDebug()) {
                    JCCFLogger.this.debug("JCCFFileTextAreaHandler", "openFile", "No write access to file " + string);
                }
                return null;
            }
            catch (Throwable throwable) {
                if (JCCFLogger.this.isWarn()) {
                    JCCFLogger.this.warn("JCCFFileTextAreaHandler", "openFile", "JCCF001 - Unspecified error. ", throwable);
                }
                return null;
            }
        }

        protected FileOutputStream getFileOutputStream(File file, String string, boolean bl) {
            if (JCCFControl.javagui) {
                return null;
            }
            if (JCCFLogger.this.isDebug()) {
                JCCFLogger.this.debug("JCCFFileTextAreaHandler", "openFile", "Write access to file " + string + " is " + file.canWrite());
            }
            try {
                return new FileOutputStream(file, !bl);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (JCCFLogger.this.isDebug()) {
                    JCCFLogger.this.debug("JCCFFileTextAreaHandler", "openFile", "File " + string + " not found ");
                }
                return null;
            }
        }

        protected File logFileManager(String string) {
            if (JCCFControl.javagui) {
                return null;
            }
            if (JCCFLogger.this.isTrace()) {
                JCCFLogger.this.trace("JCCFFileTextAreaHandler", "logFileManager", string);
            }
            if (string == null) {
                return null;
            }
            File file = null;
            if (JCCFLogger.this.logOldFileAge <= 0L && JCCFLogger.this.logFileSize <= 0L) {
                return null;
            }
            File file2 = new File(string);
            if (!file2.exists()) {
                file2.mkdirs();
                if (JCCFLogger.this.isInfo()) {
                    JCCFLogger.this.info("JCCFFileTextAreaHandler", "logFileManager", "Filelogging: directory  created");
                }
            } else if (file2.isDirectory()) {
                File[] fileArray = file2.listFiles(new JCCFFileNameFilter(JCCFLogger.this));
                long l = 0L;
                long l2 = 0L;
                if (fileArray == null) {
                    return null;
                }
                if (JCCFLogger.this.logOldFileAge > 0L) {
                    long l3 = System.currentTimeMillis();
                    l = l3 - JCCFLogger.this.logOldFileAge;
                }
                if (JCCFLogger.this.isInfo()) {
                    JCCFLogger.this.info("JCCFFileTextAreaHandler", "logFileManager", "Filelogging: search last File");
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    long l4 = fileArray[i].lastModified();
                    if (l > 0L && l4 < l) {
                        if (JCCFLogger.this.isInfo()) {
                            JCCFLogger.this.info("JCCFFileTextAreaHandler", "logFileManager", "Filelogging: File to old deled: " + fileArray[i].toString());
                        }
                        if (fileArray[i].delete()) {
                            if (!JCCFLogger.this.isInfo()) continue;
                            JCCFLogger.this.info("JCCFFileTextAreaHandler", "logFileManager", "Filelogging: File deleded ");
                            continue;
                        }
                        if (!JCCFLogger.this.isInfo()) continue;
                        JCCFLogger.this.info("JCCFFileTextAreaHandler", "logFileManager", "Filelogging: File not deleded");
                        continue;
                    }
                    if (!fileArray[i].getName().startsWith(JCCFLogger.LOGNAME_START) || l2 >= l4) continue;
                    l2 = l4;
                    file = fileArray[i];
                }
            }
            if (file != null) {
                if (JCCFLogger.this.isInfo()) {
                    JCCFLogger.this.info("JCCFFileTextAreaHandler", "logFileManager", "Filelogging: File: " + String.valueOf(file));
                }
                long l = file.length();
                long l5 = JCCFLogger.this.logFileSize * 1000000L;
                if (l5 > 0L && l >= l5) {
                    file = null;
                    if (JCCFLogger.this.isInfo()) {
                        JCCFLogger.this.info("JCCFFileTextAreaHandler", "logFileManager", "Filelogging: Noappend create an new one");
                    }
                } else if (JCCFLogger.this.isInfo()) {
                    JCCFLogger.this.info("JCCFFileTextAreaHandler", "logFileManager", "Filelogging: append Log to File: " + file.toString());
                }
            } else if (JCCFLogger.this.isInfo()) {
                JCCFLogger.this.info("JCCFFileTextAreaHandler", "logFileManager", "Filelogging: Noappend create an new one");
            }
            return file;
        }
    }

    class JCCFConsoleTextAreaHandler
    extends Handler {
        public JCCFConsoleTextAreaHandler() {
            if (JCCFControl.javagui) {
                return;
            }
            this.setFormatter(new JCCFTextAreaFormatter());
        }

        @Override
        public void publish(LogRecord logRecord) {
            String string;
            if (JCCFControl.javagui) {
                return;
            }
            if (logRecord.getLevel().intValue() < JCCFLogger.this.consolehandlerlevel.intValue()) {
                return;
            }
            try {
                string = logRecord.getMessage() == null ? "" : (logRecord.getMessage().length() < 3 ? "" : this.getFormatter().format(logRecord));
            }
            catch (Exception exception) {
                this.reportError(null, exception, 5);
                return;
            }
            System.err.println(string);
            System.out.println(string);
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }
    }

    class JCCFFileNameFilter
    implements FilenameFilter {
        JCCFFileNameFilter(JCCFLogger jCCFLogger) {
        }

        @Override
        public boolean accept(File file, String string) {
            if (string.startsWith(JCCFLogger.LOGNAME_START) && string.endsWith(".log")) {
                return true;
            }
            for (int i = 0; i < JCCFRestrictedControl.controls.length; ++i) {
                if (!string.startsWith(JCCFRestrictedControl.controls[i][0]) || !string.endsWith(".log")) continue;
                return true;
            }
            return false;
        }
    }

    class JCCFTextAreaFormatter
    extends Formatter {
        JCCFTextAreaFormatter() {
        }

        @Override
        public String format(LogRecord logRecord) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(new Date(System.currentTimeMillis()));
            stringBuffer.append(" ");
            if (logRecord.getLevel() != null && logRecord.getLevel().toString().length() > 0) {
                stringBuffer.append(logRecord.getLevel().toString());
                stringBuffer.append(" ");
            }
            if (JCCFLogger.this.controlname != null && JCCFLogger.this.controlname.length() > 0) {
                stringBuffer.append(JCCFLogger.this.controlname);
                stringBuffer.append(" - ");
            }
            if (logRecord.getSourceClassName() != null && logRecord.getSourceClassName().length() > 0) {
                stringBuffer.append(logRecord.getSourceClassName());
            }
            stringBuffer.append(".");
            if (logRecord.getSourceMethodName() != null && logRecord.getSourceMethodName().length() > 0) {
                stringBuffer.append(logRecord.getSourceMethodName());
            }
            if (logRecord.getMessage() != null && logRecord.getMessage().length() > 0) {
                stringBuffer.append(" - ");
                stringBuffer.append(logRecord.getMessage());
            }
            if (logRecord.getThrown() != null) {
                stringBuffer.append(" - ");
                stringBuffer.append(logRecord.getThrown());
            }
            String string = stringBuffer.toString();
            return string;
        }
    }
}

