/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.selector.font;

import com.ishmed.selector.font.ItemChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FontSelect
extends JPanel {
    private static final long serialVersionUID = 3480665760543681376L;
    private String fontName;
    private int style;
    private int size;
    private Font selectedFont;
    private String[] fontNames;
    private ItemChooser families;
    private ItemChooser styles;
    private ItemChooser sizes;
    private JTextArea preview;
    private String testString;
    private String[] styleNames = new String[]{"Plain", "Italic", "Bold", "BoldItalic"};
    private Integer[] styleValues = new Integer[]{0, 2, 1, 3};
    private String[] sizeNames = new String[]{"2", "4", "8", "10", "12", "14", "18", "20", "24", "28", "32", "40", "48", "56", "64", "72"};
    private String defaultPreviewString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\ufffd\ufffd\ufffd\nabcdefghijklmnopqrstuvwxyz\ufffd\ufffd\ufffd\ufffd\n1234567890!?|@#$&%^&*()_-=+[]{}<,.>";

    public FontSelect(String theFontHeader, String theHeaderStyle, String theHeaderSize, String thePain, String theItalic, String theFett, String theItalicFett, Font theFont, String theTestString) {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.fontNames = env.getAvailableFontFamilyNames();
        if (theFontHeader == null) {
            theFontHeader = "Font:";
        }
        if (theHeaderStyle == null) {
            theHeaderStyle = "Style:";
        }
        if (theHeaderSize == null) {
            theHeaderSize = "Size:";
        }
        if (thePain != null) {
            this.styleNames[0] = thePain;
        }
        if (theItalic != null) {
            this.styleNames[1] = theItalic;
        }
        if (theFett != null) {
            this.styleNames[2] = theFett;
        }
        if (theItalicFett != null) {
            this.styleNames[3] = theItalicFett;
        }
        if (theFont != null) {
            this.fontName = theFont.getFamily();
            this.style = theFont.getStyle();
            this.size = theFont.getSize();
            this.selectedFont = theFont;
            this.families = new ItemChooser(theFontHeader, this.fontNames, null, this.fontName);
            String s = null;
            if (this.style == 0) {
                s = this.styleNames[0];
            } else if (this.style == 2) {
                s = this.styleNames[1];
            } else if (this.style == 1) {
                s = this.styleNames[2];
            } else if (this.style == 3) {
                s = this.styleNames[3];
            }
            this.styles = new ItemChooser(theHeaderStyle, this.styleNames, (Object[])this.styleValues, s);
            this.sizes = new ItemChooser(theHeaderSize, this.sizeNames, null, this.size);
        } else {
            this.fontName = this.fontNames[0];
            this.style = 0;
            this.size = 12;
            this.selectedFont = new Font(this.fontName, this.style, this.size);
            this.families = new ItemChooser(theFontHeader, this.fontNames, null, 0);
            this.styles = new ItemChooser(theHeaderStyle, this.styleNames, (Object[])this.styleValues, 0);
            this.sizes = new ItemChooser(theHeaderSize, this.sizeNames, null, 4);
        }
        this.testString = theTestString == null || theTestString.length() == 0 || theTestString.equals(" ") ? this.defaultPreviewString : theTestString;
        this.families.addItemChooserListener(new ItemChooser.Listener(){

            @Override
            public void itemChosen(ItemChooser.Event e) {
                FontSelect.this.setFontFamily((String)e.getSelectedValue());
            }
        });
        this.styles.addItemChooserListener(new ItemChooser.Listener(){

            @Override
            public void itemChosen(ItemChooser.Event e) {
                FontSelect.this.setFontStyle((Integer)e.getSelectedValue());
            }
        });
        this.sizes.addItemChooserListener(new ItemChooser.Listener(){

            @Override
            public void itemChosen(ItemChooser.Event e) {
                Object o = e.getSelectedValue();
                if (o != null) {
                    FontSelect.this.setFontSize(Integer.parseInt((String)o));
                }
            }
        });
        this.preview = new JTextArea(this.testString, 5, 40);
        this.preview.setFont(this.selectedFont);
        Box choosersBox = Box.createHorizontalBox();
        choosersBox.add(Box.createHorizontalStrut(15));
        choosersBox.add(this.families);
        choosersBox.add(Box.createHorizontalStrut(15));
        choosersBox.add(this.styles);
        choosersBox.add(Box.createHorizontalStrut(15));
        choosersBox.add(this.sizes);
        choosersBox.add(Box.createHorizontalStrut(15));
        choosersBox.add(Box.createGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.preview), "Center");
        this.add((Component)choosersBox, "North");
    }

    private void changeFont() {
        this.selectedFont = new Font(this.fontName, this.style, this.size);
        this.preview.setFont(this.selectedFont);
    }

    public void setFontFamily(String name) {
        this.fontName = name;
        this.changeFont();
    }

    public void setFontStyle(int style) {
        this.style = style;
        this.changeFont();
    }

    public void setFontSize(int size) {
        this.size = size;
        this.changeFont();
    }

    public void setSelectedFont(Font font) {
        this.selectedFont = font;
        this.fontName = font.getFamily();
        this.style = font.getStyle();
        this.size = font.getSize();
        this.preview.setFont(font);
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void free() {
        this.fontName = null;
        this.selectedFont = null;
        this.fontNames = null;
        this.families = null;
        this.styles = null;
        this.sizes = null;
        this.preview = null;
        this.testString = null;
    }
}

