/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.selector.color;

import com.ishmed.gui.client.utl.ColorSelector;
import com.ishmed.gui.client.utl.UtilsProperty;
import com.ishmed.gui.client.utl.system.ColorRadioButton;
import com.ishmed.gui.client.utl.system.Helper;
import com.ishmed.selector.color.PropertyColor;
import com.ishmed.tech.client.jccf.util.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ColorSelect
extends JPanel
implements ChangeListener,
ActionListener {
    private static final long serialVersionUID = 1819586565717931942L;
    private JColorChooser jColorChooser;
    private String colorHeader;
    private JLabel jLabelColor;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private HashMap<ColorRadioButton, JTextField> hashMapControls = new HashMap();
    private JPanel jPanelControls;
    private JScrollPane jScrollPaneControls;
    private int lenOfRadioButton = 260;
    private int defaultValue = 20;
    private int xOfTextFieldColor = 275;
    private ArrayList<PropertyColor> arrayColors;
    protected ColorSelector colorFontSelector;
    private UtilsProperty colorChoiceProperty;
    private Helper helper;

    public ColorSelect(ColorSelector theCFS, UtilsProperty theColorChoiceProperty, Helper theHelper, String theData) {
        this.colorFontSelector = theCFS;
        this.colorChoiceProperty = theColorChoiceProperty;
        this.helper = theHelper;
        if (theData != null) {
            this.setColors(theData);
        }
        this.setName("ColorSelector");
    }

    @Override
    public String getName() {
        return "ColorSelect";
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.helper.logEntering("ColorSelect", "actionPerformed");
        if (this.hashMapControls == null || this.hashMapControls.isEmpty()) {
            return;
        }
        Object actionObject = ae.getSource();
        Set<ColorRadioButton> keys = this.hashMapControls.keySet();
        Iterator<ColorRadioButton> iterator = keys.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != actionObject) continue;
            this.jColorChooser.setColor(this.hashMapControls.get(actionObject).getBackground());
            break;
        }
        this.helper.logExiting("ColorSelect", "actionPerformed");
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (this.hashMapControls == null || this.hashMapControls.isEmpty()) {
            return;
        }
        Set<ColorRadioButton> keys = this.hashMapControls.keySet();
        Iterator<Object> iterator = keys.iterator();
        String selRadioButton = null;
        while (iterator.hasNext()) {
            ColorRadioButton jRadioButton = iterator.next();
            if (!jRadioButton.isSelected()) continue;
            selRadioButton = jRadioButton.getId();
            this.hashMapControls.get(jRadioButton).setBackground(this.jColorChooser.getColor());
            break;
        }
        if (selRadioButton != null && this.arrayColors != null && !this.arrayColors.isEmpty()) {
            iterator = null;
            for (PropertyColor pc : this.arrayColors) {
                if (!pc.getId().equals(selRadioButton)) continue;
                pc.setColor(this.jColorChooser.getColor());
                break;
            }
        }
    }

    private void setColorSelect() {
        Set<ColorRadioButton> keys = this.hashMapControls.keySet();
        for (ColorRadioButton rB : keys) {
            if (!rB.isSelected()) continue;
            this.jColorChooser.setColor(this.hashMapControls.get(rB).getBackground());
            break;
        }
    }

    public void update() {
        this.helper.logEntering(this.getName(), "update");
        this.initComponents();
        this.setVisible(true);
        this.helper.logExiting(this.getName(), "update");
    }

    private void initComponents() {
        this.helper.logEntering(this.getName(), "initComponents");
        this.buttonGroup = new ButtonGroup();
        this.jScrollPaneControls = new JScrollPane();
        this.jPanelControls = new JPanel();
        this.jColorChooser = new JColorChooser();
        JPanel jPColorChoice = new JPanel();
        JPanel jLabelPanel = new JPanel();
        this.jLabelColor = new JLabel(this.colorHeader);
        this.setLayout(new BorderLayout());
        this.jPanelControls.setLayout(new GridLayout(0, 1, 0, 0));
        this.jScrollPaneControls.setHorizontalScrollBarPolicy(31);
        this.jPanelControls.setMinimumSize(new Dimension(300, 0));
        if (this.jLabelColor.getText() == null || this.jLabelColor.getText().equals("")) {
            this.jLabelColor.setText("Farbdefinitionen:");
        }
        this.jLabelColor.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jLabelColor.setVerticalAlignment(1);
        jLabelPanel.setLayout(new FlowLayout(0, 15, 5));
        jLabelPanel.setMaximumSize(new Dimension(300, this.defaultValue));
        jLabelPanel.setMinimumSize(new Dimension(this.defaultValue, this.defaultValue));
        jLabelPanel.setPreferredSize(new Dimension(300, this.defaultValue));
        jLabelPanel.add(this.jLabelColor);
        this.jPanelControls.add(jLabelPanel);
        this.jScrollPaneControls.setViewportView(this.jPanelControls);
        this.jScrollPaneControls.setPreferredSize(new Dimension(320, this.colorChoiceProperty.choice_heigth));
        this.jScrollPaneControls.setMinimumSize(new Dimension(320, this.colorChoiceProperty.choice_heigth));
        this.jScrollPaneControls.setMaximumSize(new Dimension(320, this.colorChoiceProperty.choice_heigth));
        if (this.arrayColors != null && this.arrayColors.size() > 1) {
            this.add((Component)this.jScrollPaneControls, "West");
        }
        jPColorChoice.setLayout(new BorderLayout());
        jPColorChoice.add((Component)this.jColorChooser, "Center");
        this.jColorChooser.getSelectionModel().addChangeListener(this);
        this.add((Component)jPColorChoice, "Center");
        if (this.arrayColors != null && !this.arrayColors.isEmpty()) {
            Iterator<PropertyColor> it = this.arrayColors.iterator();
            boolean first = true;
            while (it.hasNext()) {
                PropertyColor pc = it.next();
                JPanel jPanel2 = new JPanel();
                jPanel2.setLayout(null);
                ColorRadioButton jRadioButton = new ColorRadioButton(pc.getName());
                jRadioButton.setId(pc.getId());
                jRadioButton.setBounds(5, 5, this.lenOfRadioButton, this.defaultValue);
                jRadioButton.addActionListener(this);
                if (first) {
                    jRadioButton.setSelected(true);
                    first = false;
                }
                this.buttonGroup.add(jRadioButton);
                jPanel2.add(jRadioButton);
                JTextField jTextField = new JTextField();
                jTextField.setEditable(false);
                jTextField.setBounds(this.xOfTextFieldColor, 5, this.defaultValue, this.defaultValue);
                jTextField.setBackground(pc.getColor());
                jPanel2.add(jTextField);
                this.jPanelControls.add(jPanel2);
                this.hashMapControls.put(jRadioButton, jTextField);
            }
            this.setColorSelect();
        }
        this.helper.logExiting(this.getName(), "initComponents");
    }

    public void free() {
        if (this.helper != null) {
            this.helper.logEntering(this.getName(), "free");
        }
        this.jColorChooser = null;
        this.colorHeader = null;
        this.jLabelColor = null;
        this.buttonGroup = null;
        this.hashMapControls = null;
        this.jPanelControls = null;
        this.jScrollPaneControls = null;
        this.arrayColors = null;
        this.colorChoiceProperty = null;
        this.colorFontSelector = null;
        if (this.helper != null) {
            this.helper.logExiting(this.getName(), "free");
        }
        this.helper = null;
    }

    private void setColor(String id, String name, String color) {
        PropertyColor property = new PropertyColor(id, name, color);
        if (this.arrayColors != null) {
            this.arrayColors.add(property);
        }
    }

    protected void setColors(String data) {
        this.helper.logEntering(this.getName(), "setColors");
        this.arrayColors = null;
        this.arrayColors = new ArrayList();
        try {
            NodeList nodeList = this.helper.getRootNode(data).getChildNodes();
            String title = XMLUtil.getNodeValueS((NodeList)nodeList, (String)"TI");
            this.setColorHeader(title);
            Node node = XMLUtil.getNode((NodeList)nodeList, (String)"T_COLORS");
            nodeList = node.getChildNodes();
            int x = 0;
            while (x < nodeList.getLength()) {
                NodeList nodeList2 = nodeList.item(x).getChildNodes();
                this.setColor(XMLUtil.getNodeValueS((NodeList)nodeList2, (String)"ID"), XMLUtil.getNodeValueS((NodeList)nodeList2, (String)"TEXT"), XMLUtil.getNodeValueS((NodeList)nodeList2, (String)"COLOR"));
                ++x;
            }
        }
        catch (Exception e) {
            this.helper.logThrowing(this.getName(), "setColors", e);
            e.printStackTrace(System.err);
        }
        this.helper.logExiting(this.getName(), "setColors");
    }

    protected void setColorHeader(String data) {
        this.helper.logEntering(this.getName(), "setColorHeader");
        this.colorHeader = data;
        this.helper.logExiting(this.getName(), "setColorHeader");
    }

    protected String getColorHeader() {
        this.helper.logEntering(this.getName(), "getColorHeader");
        return this.colorHeader;
    }

    public String getColors() {
        this.helper.logEntering(this.getName(), "getColors");
        String result = "";
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement("COLORS");
            doc.appendChild(root);
            this.appendColorHeaderElement(doc);
            this.appendColorElement(doc);
            result = this.helper.createStringFromDoc(doc);
        }
        catch (Exception e) {
            this.helper.logThrowing(this.getName(), "getColors", e);
            e.printStackTrace(System.err);
        }
        this.helper.logExiting(this.getName(), "getColors", result);
        return result;
    }

    protected void appendColorHeaderElement(Document doc) {
        try {
            Element root = doc.createElement("TI");
            Node firstChild = doc.getFirstChild();
            if (firstChild != null) {
                firstChild.appendChild(root);
            } else {
                doc.appendChild(root);
            }
            root.appendChild(doc.createTextNode(this.getColorHeader()));
        }
        catch (Exception e) {
            this.helper.logThrowing(this.getName(), "getColors", e);
            e.printStackTrace(System.err);
        }
    }

    protected void appendColorElement(Document doc) {
        try {
            Element root = doc.createElement("T_COLORS");
            Node firstChild = doc.getFirstChild();
            if (firstChild != null) {
                firstChild.appendChild(root);
            } else {
                doc.appendChild(root);
            }
            if (this.arrayColors == null || this.arrayColors.isEmpty()) {
                return;
            }
            Iterator<PropertyColor> it = this.arrayColors.iterator();
            while (it.hasNext()) {
                Element item = doc.createElement("A");
                root.appendChild(item);
                PropertyColor pc = it.next();
                Element attrib = doc.createElement("ID");
                item.appendChild(attrib);
                attrib.appendChild(doc.createTextNode(pc.getId()));
                attrib = doc.createElement("TEXT");
                item.appendChild(attrib);
                attrib.appendChild(doc.createTextNode(pc.getName()));
                attrib = doc.createElement("COLOR");
                item.appendChild(attrib);
                attrib.appendChild(doc.createTextNode(pc.getValue()));
            }
        }
        catch (Exception e) {
            this.helper.logThrowing(this.getName(), "getColors", e);
            e.printStackTrace(System.err);
        }
    }
}

