/*
 * Decompiled with CFR 0.152.
 */
package com.ishmed.gui.client.utl;

import com.ishmed.gui.client.utl.Utils;
import com.ishmed.selector.color.ColorSelect;
import com.ishmed.tech.client.jccf.JCCFContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;

public class ColorSelector
extends Utils {
    private static final long serialVersionUID = 1819586565717931942L;
    private ColorSelect colorSelector;

    @Override
    public void update() {
        this.helper.logEntering("ColorSelector", "update");
        try {
            try {
                this.removeAll();
                Dimension d = this.getParent().getSize();
                this.colorChoiceProperty.choice_width = (int)d.getWidth();
                this.colorChoiceProperty.choice_heigth = (int)d.getHeight();
                this.setLayout(new BorderLayout());
                this.add((Component)this.colorSelector, "Center");
                this.colorSelector.update();
                this.repaint();
                this.setVisible(true);
            }
            catch (Exception e) {
                this.helper.logThrowing("ColorSelector", "update", e);
                this.colorChoiceProperty.error.append("update: " + e.toString() + ".\n");
                e.printStackTrace();
                this.validate();
                this.repaint();
                this.setVisible(true);
                if (this.colorChoiceProperty.error.length() > 0) {
                    this.helper.showMessage(this.colorChoiceProperty.error.toString());
                }
                this.helper.logExiting("ColorSelector", "update");
            }
        }
        finally {
            this.validate();
            this.repaint();
            this.setVisible(true);
            if (this.colorChoiceProperty.error.length() > 0) {
                this.helper.showMessage(this.colorChoiceProperty.error.toString());
            }
            this.helper.logExiting("ColorSelector", "update");
        }
    }

    public void setColors(String data) {
        this.helper.logEntering("ColorSelector", "setColors", data);
        try {
            this.colorSelector = null;
            this.colorSelector = new ColorSelect(this, this.colorChoiceProperty, this.helper, data);
        }
        catch (Exception e) {
            this.helper.logThrowing("ColorSelector", "setColors", e);
            this.colorChoiceProperty.error.append("setColors: " + e.toString() + ". Daten" + data + "\n");
            e.printStackTrace(System.err);
        }
        this.update();
        this.helper.logExiting("ColorSelector", "setColors");
    }

    public String getColors(String s) {
        this.helper.logEntering("ColorSelector", "getColors");
        try {
            String result = this.colorSelector.getColors();
            this.helper.logExiting("ColorSelector", "getColors", result);
            return result;
        }
        catch (Exception e) {
            this.helper.logThrowing("ColorSelector", "getColors", e);
            this.colorChoiceProperty.error.append("getColors: " + e.toString() + ".\n");
            e.printStackTrace(System.err);
            return "";
        }
    }

    @Override
    public JComponent getControl() {
        return this;
    }

    @Override
    public Object getPrint() {
        return this;
    }

    @Override
    public void init(JCCFContext context) {
        this.context = context;
        if (context != null) {
            this.colorChoiceProperty.log = context.getLogger();
        }
    }

    @Override
    public void free() {
        if (this.helper != null) {
            this.helper.logEntering("ColorSelector", "free");
        }
        this.colorChoiceProperty = null;
        if (this.colorSelector != null) {
            this.colorSelector.free();
        }
        this.colorSelector = null;
        if (this.helper != null) {
            this.helper.logExiting("ColorSelector", "free");
        }
        this.helper = null;
    }

    @Override
    public void destroyMe(String s) {
        this.free();
    }
}

